#define ANTIALIASING_RELATED_SETTINGS
#define SHADOWMAP_CONSTANT_RELATED_SETTINGS
#include "/lib/settings.glsl"
#include "/lib/res_params.glsl"

#ifdef END_SHADER
	flat varying float Flashing;
#endif

#include "/lib/scene_controller.glsl"

flat varying vec3 WsunVec;
flat varying vec3 WmoonVec;
flat varying vec3 unsigned_WsunVec;
flat varying vec3 averageSkyCol_Clouds;
flat varying vec4 lightCol;
flat varying vec3 moonCol;

// #ifdef FLASHLIGHT
// 	flat varying vec3 albedoSmooth;
// #endif


flat varying vec3 zMults;
uniform sampler2D colortex4;

// uniform float far;
uniform float near;

uniform mat4 gbufferModelViewInverse;
uniform vec3 sunPosition;
uniform vec3 moonPosition;

uniform float rainStrength;
uniform float sunElevation;
uniform int frameCounter;
uniform float frameTimeCounter;


#include "/lib/TAA_jitter.glsl"



#include "/lib/util.glsl"
#include "/lib/Shadow_Params.glsl"

void main() {
	gl_Position = ftransform();

	#ifdef END_SHADER
		Flashing = texelFetch(colortex4,ivec2(1,1),0).x/150.0;
	#endif

	zMults = vec3(1.0/(far * near),far+near,far-near);

	lightCol.rgb = texelFetch(colortex4,ivec2(6,37),0).rgb;
	lightCol.a = float(sunElevation > 1e-5)*2.0 - 1.0;

	moonCol = texelFetch(colortex4,ivec2(9,37),0).rgb;
	
	// #if defined FLASHLIGHT && defined FLASHLIGHT_BOUNCED_INDIRECT
	// 	albedoSmooth = texelFetch(colortex4,ivec2(15.5,2.5),0).rgb;
	// #endif

	averageSkyCol_Clouds = texelFetch(colortex4,ivec2(0,37),0).rgb;

	unsigned_WsunVec = normalize(mat3(gbufferModelViewInverse) * sunPosition);
	
	vec3 moonVec = normalize(mat3(gbufferModelViewInverse) * moonPosition);

	WmoonVec = moonVec;
	
	if(dot(-moonVec, unsigned_WsunVec) < 0.9999) WmoonVec = -moonVec;

	WsunVec = mix(WmoonVec, unsigned_WsunVec, clamp(lightCol.a,0,1));
	
	#define READ_SCENE_CONTROLLER_PARAMETERS
	#include "/lib/scene_controller.glsl"
	// readSceneControllerParameters(colortex4, parameters.smallCumulus, parameters.largeCumulus, parameters.altostratus, parameters.fog);

	#if TAA_MODE == 3
		gl_Position.xy = (gl_Position.xy*0.5+0.5)*RENDER_SCALE*2.0-1.0;
	#endif
}
