#define ANTIALIASING_RELATED_SETTINGS

#include "/lib/settings.glsl"


flat varying vec3 WsunVec;

uniform sampler2D colortex4;

uniform int frameCounter;

uniform float sunElevation;
uniform vec3 sunPosition;
uniform mat4 gbufferModelViewInverse;


flat varying vec3 zMults;

uniform float far;
uniform float near;

#include "/lib/util.glsl"
#include "/lib/res_params.glsl"
#include "/lib/TAA_jitter.glsl"

void main() {
	gl_Position = ftransform();

	WsunVec = (float(sunElevation > 1e-5)*2-1.)*normalize(mat3(gbufferModelViewInverse) * sunPosition);
	
	zMults = vec3(1.0/(far * near),far+near,far-near);

	#if TAA_MODE == 3
		gl_Position.xy = (gl_Position.xy*0.5+0.5)*RENDER_SCALE*2.0-1.0;
	#endif
}
