#define HANDHELD_LIGHTSOURCE_RELATED_SETTINGS
#define ANTIALIASING_RELATED_SETTINGS
#include "/lib/settings.glsl"
#include "/lib/res_params.glsl"
#include "/lib/items.glsl"

/*
!! DO NOT REMOVE !!
This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

varying vec4 lmtexcoord;
varying vec4 color;
uniform sampler2D colortex4;

#ifdef LINES
	flat varying int SELECTION_BOX;
#endif

#ifdef OVERWORLD_SHADER
	flat varying vec3 averageSkyCol_Clouds;
	flat varying vec4 lightCol;
	flat varying vec3 WsunVec;

	#include "/lib/scene_controller.glsl"
#endif
	

uniform bool isInRainFallEnviornment;
uniform vec3 sunPosition;
uniform float sunElevation;

uniform vec2 texelSize;

uniform float frameTimeCounter;
uniform vec3 cameraPosition;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform ivec2 eyeBrightnessSmooth;

uniform int heldItemId;
uniform int heldItemId2;

#include "/lib/TAA_jitter.glsl"

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)
vec4 toClipSpace3(vec3 viewSpacePosition) {
    return vec4(projMAD(gl_ProjectionMatrix, viewSpacePosition),-viewSpacePosition.z);
}		




#ifdef DAMAGE_BLOCK_EFFECT
	varying vec4 vtexcoordam; // .st for add, .pq for mul
	varying vec4 vtexcoord;

	attribute vec4 mc_midTexCoord;
	varying vec4 tangent;
	attribute vec4 at_tangent;
	varying vec4 normalMat;
#endif

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {

	lmtexcoord.xy = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
	vec2 lmcoord = gl_MultiTexCoord1.xy / 240.0;
	lmtexcoord.zw = lmcoord;

	#ifdef DAMAGE_BLOCK_EFFECT
		vec2 midcoord = (gl_TextureMatrix[0] *  mc_midTexCoord).st;
		vec2 texcoordminusmid = lmtexcoord.xy-midcoord;
		vtexcoordam.pq  = abs(texcoordminusmid)*2;
		vtexcoordam.st  = min(lmtexcoord.xy,midcoord-texcoordminusmid);
		vtexcoord.xy    = sign(texcoordminusmid)*0.5+0.5;

		tangent = vec4(normalize(gl_NormalMatrix * at_tangent.rgb), at_tangent.w);
		
		normalMat = vec4(normalize(gl_NormalMatrix * gl_Normal), 1.0);
	#endif

	#if defined WEATHER || defined LINES
		vec3 position = mat3(gl_ModelViewMatrix) * vec3(gl_Vertex) + gl_ModelViewMatrix[3].xyz;
   		vec3 worldpos = mat3(gbufferModelViewInverse) * position + gbufferModelViewInverse[3].xyz;
		
		#ifdef WEATHER
			worldpos += cameraPosition;
			bool istopv = (worldpos.y > cameraPosition.y + 5.0 && lmtexcoord.w > 0.99);

			if(!istopv && isInRainFallEnviornment){
				worldpos.xyz -= cameraPosition - vec3(2.0,0.0,2.0) * min(max(clamp(eyeBrightnessSmooth.y/240.0,0,1)-0.95,0)/0.05,1);
			}else{
				worldpos.xyz -= cameraPosition;
			}
		#endif
		
		#if defined LINES && CURVATURE_AMOUNT != 0
			float curvature = length(worldpos) / (16*8);
			worldpos.y -= curvature*curvature * (float(CURVATURE_AMOUNT)/10.0f);
		#endif

		position = mat3(gbufferModelView) * worldpos + gbufferModelView[3].xyz;

		gl_Position = toClipSpace3(position);
	#else
		gl_Position = ftransform();
	#endif

	color = gl_Color;
	
	#ifdef LINES
		SELECTION_BOX = 0;
		if(dot(color.rgb,vec3(0.33333))	 < 0.00001) SELECTION_BOX = 1;
	#endif
	
	#ifdef OVERWORLD_SHADER
		lightCol.rgb = texelFetch(colortex4,ivec2(6,37),0).rgb;
		lightCol.a = float(sunElevation > 1e-5)*2.0 - 1.0;
		averageSkyCol_Clouds = texelFetch(colortex4,ivec2(0,37),0).rgb;
		WsunVec = lightCol.a * normalize(mat3(gbufferModelViewInverse) * sunPosition);

		#define READ_SCENE_CONTROLLER_PARAMETERS
		#include "/lib/scene_controller.glsl"
		// readSceneControllerParameters(colortex4, parameters.smallCumulus, parameters.largeCumulus, parameters.altostratus, parameters.fog);
	#endif
	

	#if TAA_MODE == 3
		gl_Position.xy = gl_Position.xy * RENDER_SCALE + RENDER_SCALE * gl_Position.w - gl_Position.w;
	#endif
	#ifndef WEATHER
		#if TAA_MODE > 0
			gl_Position.xy += taaJitter * gl_Position.w*texelSize;
		#endif
	#endif
}
