/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.satisfy.herbalbrews.core.effects.BalancedEffect;
import net.satisfy.herbalbrews.core.effects.BondingEffect;
import net.satisfy.herbalbrews.core.effects.DeeprushEffect;
import net.satisfy.herbalbrews.core.effects.FeralEffect;
import net.satisfy.herbalbrews.core.effects.FortuneEffect;
import net.satisfy.herbalbrews.core.effects.LifeleechEffect;
import net.satisfy.herbalbrews.core.effects.ToughEffect;
import net.satisfy.herbalbrews.core.util.HerbalBrewsIdentifier;

public class EffectRegistry {
    private static final DeferredRegister<class_1291> MOB_EFFECTS = DeferredRegister.create((String)"herbalbrews", (class_5321)class_7924.field_41208);
    private static final Registrar<class_1291> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<class_1291> DEEPRUSH = EffectRegistry.registerEffect("deeprush", DeeprushEffect::new);
    public static final RegistrySupplier<class_1291> BONDING;
    public static final RegistrySupplier<class_1291> FORTUNE;
    public static final RegistrySupplier<class_1291> BALANCED;
    public static final RegistrySupplier<class_1291> FERAL;
    public static final RegistrySupplier<class_1291> LIFELEECH;
    public static final RegistrySupplier<class_1291> TOUGH;

    private static RegistrySupplier<class_1291> registerEffect(String name, Supplier<class_1291> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((class_2960)new HerbalBrewsIdentifier(name), effect);
    }

    public static void init() {
        MOB_EFFECTS.register();
    }

    static {
        FORTUNE = EffectRegistry.registerEffect("fortune", FortuneEffect::new);
        BALANCED = EffectRegistry.registerEffect("balanced", BalancedEffect::new);
        LIFELEECH = EffectRegistry.registerEffect("lifeleech", LifeleechEffect::new);
        BONDING = EffectRegistry.registerEffect("bonding", BondingEffect::new);
        FERAL = EffectRegistry.registerEffect("feral", FeralEffect::new);
        TOUGH = EffectRegistry.registerEffect("tough", ToughEffect::new);
    }
}

