/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.compat.jei.category;

import java.awt.Rectangle;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.satisfy.herbalbrews.core.recipe.TeaKettleRecipe;
import net.satisfy.herbalbrews.core.registry.ObjectRegistry;
import net.satisfy.herbalbrews.core.registry.TagsRegistry;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;

public class TeaKettleCategory
implements IRecipeCategory<TeaKettleRecipe> {
    public static final RecipeType<TeaKettleRecipe> TEA_KETTLE_TYPE = RecipeType.create((String)"herbalbrews", (String)"tea_kettle_brewing", TeaKettleRecipe.class);
    private static final int BACKGROUND_WIDTH = 160;
    private static final int BACKGROUND_HEIGHT = 70;
    private static final int X_OFFSET = 10;
    private static final int Y_OFFSET = 10;
    private static final Vector2i ARROW_POS = new Vector2i(54, 22);
    private static final int ARROW_U = 176;
    private static final int ARROW_V = 14;
    private static final int ARROW_WIDTH = 24;
    private static final int ARROW_HEIGHT = 17;
    private static final int MAX_TIME = 200;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable burnIcon;
    private final IDrawableAnimated arrow;
    private final class_2561 title;
    private final class_2960 texture = new class_2960("herbalbrews", "textures/gui/tea_kettle.png");

    public TeaKettleCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(this.texture, 10, 10, 160, 70);
        this.arrow = helper.drawableBuilder(this.texture, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        class_1799 kettleStack = new class_1799((class_1935)ObjectRegistry.TEA_KETTLE.get());
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)kettleStack);
        this.burnIcon = helper.createDrawable(this.texture, 176, 0, 14, 14);
        this.title = ((class_2248)ObjectRegistry.TEA_KETTLE.get()).method_9518();
    }

    @NotNull
    public RecipeType<TeaKettleRecipe> getRecipeType() {
        return TEA_KETTLE_TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TeaKettleRecipe recipe, IFocusGroup focuses) {
        class_2371<class_1856> ingredients = recipe.method_8117();
        int s = Math.min(ingredients.size(), 4);
        assert (class_310.method_1551().field_1687 != null);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 12).addItemStack(recipe.method_8110(class_310.method_1551().field_1687.method_30349()));
        class_1799 waterBottle = new class_1799((class_1935)class_1802.field_8574);
        waterBottle.method_7948().method_10582("Potion", "minecraft:water");
        builder.addSlot(RecipeIngredientRole.INPUT, 108, 33).addIngredients(class_1856.method_8101((class_1799[])new class_1799[]{new class_1799((class_1935)class_1802.field_8705), waterBottle}));
        int idx = 0;
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 2 && idx < s; ++idx, ++col) {
                class_1856 ingredient = (class_1856)ingredients.get(idx);
                class_1856 filteredIngredient = this.filterOutTag(ingredient);
                if (filteredIngredient.method_8103()) continue;
                int xPos = 13 + col * 18;
                int yPos = 12 + row * 18;
                builder.addSlot(RecipeIngredientRole.INPUT, xPos - 10, yPos - 10).addIngredients(filteredIngredient);
            }
        }
        if (this.containsTagIngredient(ingredients)) {
            builder.addSlot(RecipeIngredientRole.INPUT, 21, 42).addIngredients(class_1856.method_8106((class_6862)class_3489.method_15102((String)TagsRegistry.CONTAINER_ITEMS.comp_327().toString())));
        }
        if (this.containsTagIngredient(ingredients)) {
            builder.addSlot(RecipeIngredientRole.INPUT, 85, 48).addIngredients(class_1856.method_8106((class_6862)class_3489.method_15102((String)TagsRegistry.HEAT_ITEMS.comp_327().toString())));
        }
    }

    private class_1856 filterOutTag(class_1856 ingredient) {
        ArrayList<class_1799> filteredStacks = new ArrayList<class_1799>();
        for (class_1799 stack : ingredient.method_8105()) {
            if (stack.method_31573(TagsRegistry.CONTAINER_ITEMS)) continue;
            filteredStacks.add(stack);
        }
        return filteredStacks.isEmpty() ? class_1856.field_9017 : class_1856.method_8101((class_1799[])filteredStacks.toArray(new class_1799[0]));
    }

    private boolean containsTagIngredient(class_2371<class_1856> ingredients) {
        for (class_1856 ingredient : ingredients) {
            for (class_1799 stack : ingredient.method_8105()) {
                if (!stack.method_31573(TagsRegistry.CONTAINER_ITEMS)) continue;
                return true;
            }
        }
        return false;
    }

    public void draw(TeaKettleRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, ARROW_POS.x() - 10, ARROW_POS.y() - 10);
        this.burnIcon.draw(guiGraphics, 142, 52);
        int requiredWater = recipe.getRequiredWater();
        int fluidFillHeight = Math.min(requiredWater * 43 / 100, 43);
        guiGraphics.method_25302(this.texture, 131, 6 + (43 - fluidFillHeight), 183, 31 + (43 - fluidFillHeight), 8, fluidFillHeight);
        int requiredHeat = recipe.getRequiredHeat();
        int heatFillHeight = Math.min(requiredHeat * 43 / 100, 43);
        guiGraphics.method_25302(this.texture, 146, 6 + (43 - heatFillHeight), 176, 31 + (43 - heatFillHeight), 5, heatFillHeight);
        Rectangle requiredFluidPos = new Rectangle(131, 6, 8, 43);
        Rectangle requiredHeatPos = new Rectangle(146, 6, 5, 43);
    }
}

