/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.itemlayers;

import com.google.common.collect.Maps;
import com.minecraftserverzone.weaponmaster.WeaponMasterMod;
import com.minecraftserverzone.weaponmaster.itemlayers.HumanoidItemLayer;
import com.minecraftserverzone.weaponmaster.renderer.quiver.QuiverWithArrowsModel;
import com.minecraftserverzone.weaponmaster.setup.helper.ModUtils;
import com.minecraftserverzone.weaponmaster.setup.helper.ServerHelper;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import java.util.Map;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1744;
import net.minecraft.class_1746;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1825;
import net.minecraft.class_1831;
import net.minecraft.class_1835;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5151;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_947;
import net.minecraft.class_954;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class RenderHelper {
    public static final Map<String, QuiverWithArrowsModel<class_1657>> quiverModels = Maps.newHashMap();
    public static final Map<String, QuiverWithArrowsModel<class_1657>> arrowsModels = Maps.newHashMap();

    public static int[] uniqueSettings(class_1799 stack, int slotNumber, String txt) {
        String selectedSlotNumber = "0";
        if (slotNumber < 9) {
            selectedSlotNumber = String.valueOf(slotNumber + 1);
        } else if (slotNumber == 9) {
            selectedSlotNumber = "shield";
        } else if (slotNumber == 10) {
            selectedSlotNumber = "banner";
        } else if (slotNumber == 11) {
            selectedSlotNumber = "offhand";
        } else if (slotNumber == 12) {
            selectedSlotNumber = "quiver";
        }
        if (stack != null && stack.method_7909() != null && ModUtils.stringContains(txt, ",")) {
            if (ModUtils.stringContains(txt, " ")) {
                String[] allData = txt.split(" ");
                for (int i = 0; i < allData.length; ++i) {
                    String temp;
                    if (!ModUtils.stringContains(allData[i], ",")) continue;
                    String name = StringUtils.substringBefore((String)allData[i], (String)",");
                    String[] data = allData[i].split(",");
                    if (!ModUtils.arrayExist(data, 9) || !(ModUtils.stringContains(stack.method_7909().toString(), ":") ? ModUtils.stringEquals(temp = StringUtils.substringAfter((String)stack.method_7909().toString(), (String)":"), name) && ModUtils.stringEquals(data[8], selectedSlotNumber) : stack.method_7909().toString() != null && stack.method_7909().toString().equals(name) && ModUtils.stringEquals(data[8], selectedSlotNumber))) continue;
                    return RenderHelper.getData(allData[i]);
                }
            } else {
                String temp;
                String name = StringUtils.substringBefore((String)txt, (String)",");
                String[] data = txt.split(",");
                if (ModUtils.arrayExist(data, 9) && (ModUtils.stringContains(stack.method_7909().toString(), ":") ? ModUtils.stringEquals(temp = StringUtils.substringAfter((String)stack.method_7909().toString(), (String)":"), name) && ModUtils.stringEquals(data[8], selectedSlotNumber) : stack.method_7909().toString() != null && stack.method_7909().toString().equals(name) && ModUtils.stringEquals(data[8], selectedSlotNumber))) {
                    return RenderHelper.getData(txt);
                }
            }
        }
        return new int[]{0, 0, 0, 0, 0, 0, 0};
    }

    public static int[] getData(String s) {
        String[] txtArray = s.split(",");
        if (ModUtils.arrayExist(txtArray, 8)) {
            int x = 0;
            if (NumberUtils.isCreatable((String)txtArray[1])) {
                x = NumberUtils.createInteger((String)txtArray[1]);
            }
            int y = 0;
            if (NumberUtils.isCreatable((String)txtArray[2])) {
                y = NumberUtils.createInteger((String)txtArray[2]);
            }
            int z = 0;
            if (NumberUtils.isCreatable((String)txtArray[3])) {
                z = NumberUtils.createInteger((String)txtArray[3]);
            }
            int xrot = 0;
            if (NumberUtils.isCreatable((String)txtArray[4])) {
                xrot = NumberUtils.createInteger((String)txtArray[4]);
            }
            int yrot = 0;
            if (NumberUtils.isCreatable((String)txtArray[5])) {
                yrot = NumberUtils.createInteger((String)txtArray[5]);
            }
            int zrot = 0;
            if (NumberUtils.isCreatable((String)txtArray[6])) {
                zrot = NumberUtils.createInteger((String)txtArray[6]);
            }
            int scale = 0;
            if (NumberUtils.isCreatable((String)txtArray[7])) {
                scale = NumberUtils.createInteger((String)txtArray[7]);
            }
            return new int[]{x, y, z, xrot, yrot, zrot, scale};
        }
        return new int[]{0, 0, 0, 0, 0, 0, 0};
    }

    public static boolean blackListed(class_1799 item, String txt) {
        if (txt != null) {
            String[] blacklist;
            if (item == null) {
                return false;
            }
            for (String bl : blacklist = txt.split(",")) {
                String temp;
                if (!(ModUtils.stringContains(item.toString(), ":") ? ModUtils.stringEquals(temp = StringUtils.substringAfter((String)item.toString(), (String)":"), bl) : ModUtils.stringEquals(item.method_7909().toString(), bl))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean whiteListed(class_1799 item, String txt) {
        if (txt != null) {
            String[] whitelist;
            if (item == null) {
                return false;
            }
            for (String wl : whitelist = txt.split(",")) {
                String temp;
                if (!(ModUtils.stringContains(item.toString(), ":") ? ModUtils.stringEquals(temp = StringUtils.substringAfter((String)item.toString(), (String)":"), wl) : ModUtils.stringEquals(item.method_7909().toString(), wl))) continue;
                return true;
            }
        }
        return false;
    }

    public static void move(class_4587 matrixStack, String[][] moveTypes, int slot, float translation) {
        if (moveTypes[slot][2].equals("-")) {
            translation = -translation;
        }
        if (moveTypes[slot][1].equals("x")) {
            matrixStack.method_46416(translation, 0.0f, 0.0f);
        } else if (moveTypes[slot][1].equals("y")) {
            matrixStack.method_46416(0.0f, translation, 0.0f);
        } else if (moveTypes[slot][1].equals("z")) {
            matrixStack.method_46416(0.0f, 0.0f, translation);
        }
    }

    public static int hasItems(class_1799[] items, class_1657 player, String[][] moveTypes, int slot, int selected, int shieldSlot, int bannerSlot, int[] toggleSlots) {
        int j;
        int i = 0;
        for (j = 0; j < 9; ++j) {
            if (!moveTypes[slot][0].contains(String.valueOf(j + 1)) || items[j] == null || items[j].method_7960() || selected == j || toggleSlots[j] != 1) continue;
            ++i;
        }
        if (moveTypes[slot][0].contains("shield") && shieldSlot > -1 && selected != shieldSlot && toggleSlots[9] == 1) {
            ++i;
        }
        if (moveTypes[slot][0].contains("banner") && bannerSlot > -1 && selected != bannerSlot && toggleSlots[10] == 1) {
            ++i;
        }
        if (moveTypes[slot][0].contains("quiver")) {
            for (j = 0; j < 9; ++j) {
                if (ServerHelper.getProjectile(player, items[j]) == null || !(ServerHelper.getProjectile(player, items[j]).method_7909() instanceof class_1744) || items[j].method_7960() || toggleSlots[10] != 1) continue;
                ++i;
                break;
            }
        }
        return i;
    }

    public static boolean hasEquipments(class_1657 player, String[][] moveTypes, int slot) {
        boolean move = false;
        if (moveTypes[slot][0].contains("helm") && !player.method_31548().method_7372(3).method_7960()) {
            move = true;
        }
        if (moveTypes[slot][0].contains("chest") && !player.method_31548().method_7372(2).method_7960()) {
            move = true;
        }
        if (moveTypes[slot][0].contains("legs") && !player.method_31548().method_7372(1).method_7960()) {
            move = true;
        }
        if (moveTypes[slot][0].contains("boots") && !player.method_31548().method_7372(0).method_7960()) {
            move = true;
        }
        return move;
    }

    public static void translateToHand(class_630 part, class_1306 p_102854_, class_4587 p_102855_) {
        part.method_22703(p_102855_);
    }

    public static void translateAndRotate(class_4587 p_104300_, float x, float y, float z, float xRot, float yRot, float zRot, float xScale, float yScale, float zScale) {
        p_104300_.method_22904((double)(x / 16.0f), (double)(y / 16.0f), (double)(z / 16.0f));
        if (zRot != 0.0f) {
            p_104300_.method_22907(class_7833.field_40718.rotation(zRot));
        }
        if (yRot != 0.0f) {
            p_104300_.method_22907(class_7833.field_40716.rotation(yRot));
        }
        if (xRot != 0.0f) {
            p_104300_.method_22907(class_7833.field_40714.rotation(xRot));
        }
        if (xScale != 1.0f || yScale != 1.0f || zScale != 1.0f) {
            p_104300_.method_22905(xScale, yScale, zScale);
        }
    }

    public static void copyModelPartRotation(class_572<class_1309> model, class_4587 ps, int slot, String[][] bodyattachment, float multiplier, float maxRotateChanger) {
        class_630 part = model.field_3391;
        if (bodyattachment[slot][1].equals("head")) {
            part = model.method_2838();
        } else if (bodyattachment[slot][1].equals("body")) {
            part = model.field_3391;
        } else if (bodyattachment[slot][1].equals("rarm")) {
            part = model.field_3401;
        } else if (bodyattachment[slot][1].equals("larm")) {
            part = model.field_27433;
        } else if (bodyattachment[slot][1].equals("rleg")) {
            part = model.field_3392;
        } else if (bodyattachment[slot][1].equals("lleg")) {
            part = model.field_3397;
        }
        part.method_22703(ps);
    }

    public static void renderTridentItem(int slot, class_1309 player, class_1799 itemStack, class_4587 p_174521_, class_4597 p_174522_, int p_174523_, class_811 ctx) {
        p_174521_.method_22903();
        p_174521_.method_22907(class_7833.field_40718.rotationDegrees(140.0f));
        p_174521_.method_22904((double)0.7f, 0.9, 0.61);
        p_174521_.method_22905(0.9f, 0.9f, 0.9f);
        p_174521_.method_46416(-0.45f, -1.07f, -0.535f);
        p_174521_.method_22907(class_7833.field_40716.rotationDegrees(-60.0f));
        class_310.method_1551().method_1561().method_43336().method_3233(player, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.method_22909();
    }

    public static void renderCrossbowItem(int slot, class_1309 player, class_1799 itemStack, class_4587 p_174521_, class_4597 p_174522_, int p_174523_, class_811 ctx) {
        p_174521_.method_22903();
        p_174521_.method_22904(-0.05, 0.35, 0.16);
        p_174521_.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        p_174521_.method_22907(class_7833.field_40718.rotationDegrees(270.0f));
        p_174521_.method_22905(0.8f, -0.8f, -0.8f);
        p_174521_.method_46416(0.1f, -0.2f, 0.0f);
        p_174521_.method_22907(class_7833.field_40716.rotationDegrees(0.0f));
        p_174521_.method_22907(class_7833.field_40718.rotationDegrees(60.0f));
        p_174521_.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        class_310.method_1551().method_1561().method_43336().method_3233(player, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.method_22909();
    }

    public static void renderBowItem(int slot, class_1309 player, class_1799 itemStack, class_4587 p_174521_, class_4597 p_174522_, int p_174523_, class_811 ctx) {
        p_174521_.method_22903();
        p_174521_.method_22904(0.0, 0.35, 0.16);
        p_174521_.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        p_174521_.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        p_174521_.method_22905(0.8f, -0.8f, -0.8f);
        p_174521_.method_22904(-0.05, 0.2, -0.07);
        p_174521_.method_22907(class_7833.field_40716.rotationDegrees(97.0f));
        p_174521_.method_22907(class_7833.field_40718.rotationDegrees(-6.0f));
        p_174521_.method_22907(class_7833.field_40714.rotationDegrees(40.0f));
        class_310.method_1551().method_1561().method_43336().method_3233(player, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.method_22909();
    }

    public static void renderNormalItem(int slot, class_1309 player, class_1799 itemStack, class_4587 p_174521_, class_4597 p_174522_, int p_174523_, class_811 ctx) {
        p_174521_.method_22903();
        p_174521_.method_22904(0.0, 0.35, 0.16);
        p_174521_.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        p_174521_.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        p_174521_.method_22905(0.8f, -0.8f, -0.8f);
        p_174521_.method_46416(0.1f, -0.1f, -0.08f);
        class_310.method_1551().method_1561().method_43336().method_3233(player, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.method_22909();
    }

    public static void renderTieredItem(int slot, class_1309 player, class_1799 itemStack, class_4587 p_174521_, class_4597 p_174522_, int p_174523_, class_811 ctx) {
        p_174521_.method_22903();
        p_174521_.method_22904(-0.05, 0.3, 0.16);
        p_174521_.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        p_174521_.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        p_174521_.method_22905(0.8f, -0.8f, -0.8f);
        p_174521_.method_22904(-0.2, -0.1, -0.0);
        p_174521_.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        p_174521_.method_22907(class_7833.field_40714.rotationDegrees(55.0f));
        class_310.method_1551().method_1561().method_43336().method_3233(player, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.method_22909();
    }

    public static void renderOtherPlayerWithItems(class_1657 player, class_4587 p_174521_, class_4597 p_174522_, int p_174523_, class_572<class_1309> model) {
        float f;
        float scalePlus;
        float f2;
        float scalePlus2;
        int[] add;
        float moveBy;
        QuiverWithArrowsModel<class_1657> quiver = null;
        QuiverWithArrowsModel<class_1657> arrows = null;
        String playername = player.method_5477().getString();
        if (!quiverModels.containsKey(playername)) {
            quiverModels.put(playername, new QuiverWithArrowsModel(QuiverWithArrowsModel.createBodyLayer().method_32109()));
            quiver = quiverModels.get(playername);
        } else {
            quiver = quiverModels.get(playername);
        }
        if (!arrowsModels.containsKey(playername)) {
            arrowsModels.put(playername, new QuiverWithArrowsModel(QuiverWithArrowsModel.createArrowBodyLayer().method_32109()));
            arrows = arrowsModels.get(playername);
        } else {
            arrows = arrowsModels.get(playername);
        }
        PlayerData data = ((IPlayerData)player).getPlayerData();
        String uniqueItemSettings = data.uniqueItemDisplay;
        String whitelist = data.whitelist;
        String[] moveSlots = data.mover.split("_");
        String[][] moveTypes = new String[][]{moveSlots[0].split(";"), moveSlots[1].split(";"), moveSlots[2].split(";"), moveSlots[3].split(";"), moveSlots[4].split(";"), moveSlots[5].split(";"), moveSlots[6].split(";"), moveSlots[7].split(";"), moveSlots[8].split(";"), moveSlots[9].split(";"), moveSlots[10].split(";"), moveSlots[11].split(";"), moveSlots[12].split(";")};
        int selected = data.selectedSlot;
        int num = 0;
        class_1799 stack1 = RenderHelper.blackListed(data.inventory[num], data.blacklist) ? class_1799.field_8037 : data.inventory[num];
        class_1799 stack2 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? class_1799.field_8037 : data.inventory[num];
        class_1799 stack3 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? class_1799.field_8037 : data.inventory[num];
        class_1799 stack4 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? class_1799.field_8037 : data.inventory[num];
        class_1799 stack5 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? class_1799.field_8037 : data.inventory[num];
        class_1799 stack6 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? class_1799.field_8037 : data.inventory[num];
        class_1799 stack7 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? class_1799.field_8037 : data.inventory[num];
        class_1799 stack8 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? class_1799.field_8037 : data.inventory[num];
        class_1799 stack9 = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? class_1799.field_8037 : data.inventory[num];
        class_1799 offhand = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? class_1799.field_8037 : data.inventory[num];
        class_1799 ammo = RenderHelper.blackListed(data.inventory[++num], data.blacklist) ? class_1799.field_8037 : data.inventory[num];
        class_1799[] items = new class_1799[]{stack1, stack2, stack3, stack4, stack5, stack6, stack7, stack8, stack9, offhand, ammo};
        int[] toggleSlots = data.toggleSlots;
        int[] slotPositions = data.positions;
        int[] slotRotations = data.rotations;
        int[] scale = data.scale;
        String[] bodyattachments = data.slotAttachments.split(",");
        String[][] bodyattachment = new String[WeaponMasterMod.maxDisplaySlotNum][2];
        for (int i = 0; i < WeaponMasterMod.maxDisplaySlotNum; ++i) {
            bodyattachment[i][0] = bodyattachments[i].split("-")[0];
            bodyattachment[i][1] = bodyattachments[i].split("-")[1];
        }
        if (data.lastMainhandHit >= data.hideTick && data.toggleSlots[11] == 1) {
            selected = -1;
        }
        int shieldAt = -1;
        for (int i = 0; i < 9; ++i) {
            if (!(items[i].method_7909() instanceof class_1819)) continue;
            shieldAt = i;
            break;
        }
        int bannerAt = -1;
        for (int i = 0; i < 9; ++i) {
            if (!(items[i].method_7909() instanceof class_1746)) continue;
            bannerAt = i;
            break;
        }
        if (bannerAt != -1 && selected != bannerAt && toggleSlots[10] == 1) {
            p_174521_.method_22903();
            RenderHelper.copyModelPartRotation(model, p_174521_, 10, bodyattachment, 0.01f, 1.0f);
            float moveBy2 = (float)RenderHelper.hasItems(items, player, moveTypes, 10, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
            RenderHelper.move(p_174521_, moveTypes, 10, moveBy2);
            moveBy = RenderHelper.hasEquipments(player, moveTypes, 10) ? 0.038f : 0.0f;
            RenderHelper.move(p_174521_, moveTypes, 10, moveBy);
            add = RenderHelper.uniqueSettings(items[bannerAt], 10, uniqueItemSettings);
            p_174521_.method_46416((float)(slotPositions[30] + add[0]) / 100.0f, (float)(slotPositions[31] + add[1]) / 100.0f, (float)(slotPositions[32] + add[2]) / 100.0f);
            p_174521_.method_22907(class_7833.field_40714.rotationDegrees((float)(slotRotations[30] + add[3])));
            p_174521_.method_22907(class_7833.field_40716.rotationDegrees((float)(slotRotations[31] + add[4])));
            p_174521_.method_22907(class_7833.field_40718.rotationDegrees((float)(slotRotations[32] + add[5])));
            p_174521_.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            p_174521_.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            p_174521_.method_22904(0.0, 0.6, -0.3);
            scalePlus2 = ((float)scale[10] + 0.001f + (float)add[6]) / 100.0f;
            f2 = 0.75f;
            p_174521_.method_22905(f2 + scalePlus2, f2 + scalePlus2, f2 + scalePlus2);
            class_310.method_1551().method_1561().method_43336().method_3233((class_1309)player, items[bannerAt], class_811.field_4315, false, p_174521_, p_174522_, p_174523_);
            p_174521_.method_22909();
        }
        p_174521_.method_22903();
        if (shieldAt != -1 && selected != shieldAt && toggleSlots[9] == 1) {
            p_174521_.method_22903();
            RenderHelper.copyModelPartRotation(model, p_174521_, 9, bodyattachment, 1.0f, 1.0f);
            float moveBy2 = (float)RenderHelper.hasItems(items, player, moveTypes, 9, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
            RenderHelper.move(p_174521_, moveTypes, 9, moveBy2);
            moveBy = RenderHelper.hasEquipments(player, moveTypes, 9) ? 0.038f : 0.0f;
            RenderHelper.move(p_174521_, moveTypes, 9, moveBy);
            add = RenderHelper.uniqueSettings(items[shieldAt], 9, uniqueItemSettings);
            p_174521_.method_46416((float)(slotPositions[27] + add[0]) / 100.0f, (float)(slotPositions[28] + add[1]) / 100.0f, (float)(slotPositions[29] + add[2]) / 100.0f);
            p_174521_.method_22904(0.0, 0.0, 0.015);
            p_174521_.method_22907(class_7833.field_40714.rotationDegrees((float)(slotRotations[27] + add[3])));
            p_174521_.method_22907(class_7833.field_40716.rotationDegrees((float)(slotRotations[28] + add[4])));
            p_174521_.method_22907(class_7833.field_40718.rotationDegrees((float)(slotRotations[29] + add[5])));
            p_174521_.method_22904((double)0.3f, 0.7, 0.5);
            scalePlus2 = ((float)scale[9] + 0.001f + (float)add[6]) / 100.0f;
            f2 = 0.6f;
            p_174521_.method_22905(f2 + scalePlus2, f2 + scalePlus2, f2 + scalePlus2);
            p_174521_.method_22904(-0.25, -0.375, -0.625);
            p_174521_.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            class_310.method_1551().method_1561().method_43336().method_3233((class_1309)player, items[shieldAt], class_811.field_4320, false, p_174521_, p_174522_, p_174523_);
            p_174521_.method_22909();
        }
        if (items != null && toggleSlots[13] == 1) {
            int size;
            boolean hasBowOrCrossbow = false;
            class_1799 projectile = new class_1799((class_1935)class_1802.field_8162);
            if (ammo != null && ammo != class_1799.field_8037) {
                projectile = ammo;
                hasBowOrCrossbow = true;
            }
            if ((size = projectile.method_7947()) > 0 && hasBowOrCrossbow) {
                p_174521_.method_22903();
                RenderHelper.copyModelPartRotation(model, p_174521_, 12, bodyattachment, 1.0f, 1.0f);
                int[] add2 = new int[]{0, 0, 0, 0, 0, 0, 0};
                p_174521_.method_46416((float)(slotPositions[36] + add2[0]) / 100.0f, (float)(slotPositions[37] + add2[1]) / 100.0f, (float)(slotPositions[38] + add2[2]) / 100.0f);
                float moveBy2 = (float)RenderHelper.hasItems(items, player, moveTypes, 12, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
                RenderHelper.move(p_174521_, moveTypes, 12, moveBy2);
                float moveByArmor = RenderHelper.hasEquipments(player, moveTypes, 12) ? 0.038f : 0.0f;
                RenderHelper.move(p_174521_, moveTypes, 12, moveByArmor);
                p_174521_.method_22907(class_7833.field_40714.rotationDegrees((float)(slotRotations[36] + add2[3])));
                p_174521_.method_22907(class_7833.field_40716.rotationDegrees((float)(slotRotations[37] + add2[4])));
                p_174521_.method_22907(class_7833.field_40718.rotationDegrees((float)(slotRotations[38] + add2[5])));
                scalePlus = ((float)scale[12] + 0.001f + (float)add2[6]) / 100.0f;
                f = 0.5f;
                p_174521_.method_22905(f + scalePlus, f + scalePlus, f + scalePlus);
                quiver.setupAnim(0, player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                class_2960 texture = HumanoidItemLayer.QUIVER;
                if (projectile.method_7909() != null && projectile.method_7909() != class_1802.field_8162) {
                    if (projectile.method_7909() instanceof class_1825) {
                        arrow = class_947.field_4787;
                        vertexConsumer = p_174522_.getBuffer(class_1921.method_23578((class_2960)arrow));
                        arrows.setupAnim(size, player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                        arrows.method_2828(p_174521_, vertexConsumer, p_174523_, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                    } else if (projectile.method_7909() instanceof class_1744) {
                        arrow = class_954.field_4795;
                        vertexConsumer = p_174522_.getBuffer(class_1921.method_23578((class_2960)arrow));
                        arrows.setupAnim(size, player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                        arrows.method_2828(p_174521_, vertexConsumer, p_174523_, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                }
                class_4588 vertexConsumer = p_174522_.getBuffer(class_1921.method_23578((class_2960)texture));
                quiver.method_2828(p_174521_, vertexConsumer, p_174523_, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                p_174521_.method_22909();
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            boolean rightHanded;
            if (items[slot].method_7960() || selected == slot || shieldAt == slot || bannerAt == slot || toggleSlots[slot] != 1) continue;
            p_174521_.method_22903();
            RenderHelper.copyModelPartRotation(model, p_174521_, slot, bodyattachment, 1.0f, 1.0f);
            int[] add3 = RenderHelper.uniqueSettings(items[slot], slot, uniqueItemSettings);
            p_174521_.method_46416((float)(slotPositions[slot * 3] + add3[0]) / 100.0f, (float)(slotPositions[slot * 3 + 1] + add3[1]) / 100.0f, (float)(slotPositions[slot * 3 + 2] + add3[2]) / 100.0f);
            float moveBy3 = (float)RenderHelper.hasItems(items, player, moveTypes, slot, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
            RenderHelper.move(p_174521_, moveTypes, slot, moveBy3);
            float moveByArmor = RenderHelper.hasEquipments(player, moveTypes, slot) ? 0.038f : 0.0f;
            RenderHelper.move(p_174521_, moveTypes, slot, moveByArmor);
            p_174521_.method_22907(class_7833.field_40714.rotationDegrees((float)(slotRotations[slot * 3] + add3[3])));
            p_174521_.method_22907(class_7833.field_40716.rotationDegrees((float)(slotRotations[slot * 3 + 1] + add3[4])));
            p_174521_.method_22907(class_7833.field_40718.rotationDegrees((float)(slotRotations[slot * 3 + 2] + add3[5])));
            class_811 ctx = class_811.field_4320;
            boolean bl = rightHanded = player.method_6068() == class_1306.field_6183;
            if (slot == 11) {
                ctx = rightHanded ? class_811.field_4320 : class_811.field_4323;
            }
            scalePlus = ((float)scale[slot] + 0.001f + (float)add3[6]) / 100.0f;
            f = 1.0f;
            p_174521_.method_22905(f + scalePlus, f + scalePlus, f + scalePlus);
            if (items[slot].method_7909() instanceof class_1753) {
                RenderHelper.renderBowItem(slot, (class_1309)player, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            } else if (items[slot].method_7909() instanceof class_1764) {
                RenderHelper.renderCrossbowItem(slot, (class_1309)player, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            } else if (items[slot].method_7909().getClass().equals(class_1835.class)) {
                RenderHelper.renderTridentItem(slot, (class_1309)player, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            } else if (items[slot].method_7909() instanceof class_1831 && !(items[slot].method_7909() instanceof class_5151)) {
                RenderHelper.renderTieredItem(slot, (class_1309)player, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            } else if (RenderHelper.whiteListed(items[slot], whitelist)) {
                p_174521_.method_22904(0.0, 0.7, 0.0);
                p_174521_.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
                RenderHelper.renderNormalItem(slot, (class_1309)player, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            }
            p_174521_.method_22909();
        }
        int itemslot = 9;
        int slot = 11;
        if (!items[itemslot].method_7960() && toggleSlots[slot + 1] == 1 && data.lastOffhandHit >= data.hideTick) {
            if (items[itemslot].method_7909() != null && items[itemslot].method_7909() instanceof class_1819) {
                p_174521_.method_22903();
                RenderHelper.copyModelPartRotation(model, p_174521_, slot, bodyattachment, 1.0f, 1.0f);
                int[] add4 = RenderHelper.uniqueSettings(items[itemslot], 11, uniqueItemSettings);
                p_174521_.method_46416((float)(slotPositions[slot * 3] + add4[0]) / 100.0f, (float)(slotPositions[slot * 3 + 1] + add4[1]) / 100.0f, (float)(slotPositions[slot * 3 + 2] + add4[2]) / 100.0f);
                float moveBy4 = (float)RenderHelper.hasItems(items, player, moveTypes, slot, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
                RenderHelper.move(p_174521_, moveTypes, slot, moveBy4);
                moveByArmor = RenderHelper.hasEquipments(player, moveTypes, slot) ? 0.038f : 0.0f;
                RenderHelper.move(p_174521_, moveTypes, slot, moveByArmor);
                p_174521_.method_22907(class_7833.field_40714.rotationDegrees((float)(slotRotations[slot * 3] + add4[3])));
                p_174521_.method_22907(class_7833.field_40716.rotationDegrees((float)(slotRotations[slot * 3 + 1] + add4[4])));
                p_174521_.method_22907(class_7833.field_40718.rotationDegrees((float)(slotRotations[slot * 3 + 2] + add4[5])));
                class_811 ctx = class_811.field_4320;
                p_174521_.method_22904((double)0.3f, 0.35, 0.38);
                scalePlus = ((float)scale[slot] + 0.001f + (float)add4[6]) / 100.0f;
                f = 0.6f;
                p_174521_.method_22905(f + scalePlus, f + scalePlus, f + scalePlus);
                p_174521_.method_22904(-0.25, -0.375, -0.625);
                p_174521_.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
                p_174521_.method_22907(class_7833.field_40714.rotationDegrees(-35.0f));
                class_310.method_1551().method_1561().method_43336().method_3233((class_1309)player, items[itemslot], ctx, false, p_174521_, p_174522_, p_174523_);
                p_174521_.method_22909();
            } else {
                p_174521_.method_22903();
                RenderHelper.copyModelPartRotation(model, p_174521_, slot, bodyattachment, 1.0f, 1.0f);
                int[] add5 = RenderHelper.uniqueSettings(items[itemslot], 11, uniqueItemSettings);
                p_174521_.method_46416((float)(slotPositions[slot * 3] + add5[0]) / 100.0f, (float)(slotPositions[slot * 3 + 1] + add5[1]) / 100.0f, (float)(slotPositions[slot * 3 + 2] + add5[2]) / 100.0f);
                float moveBy5 = (float)RenderHelper.hasItems(items, player, moveTypes, slot, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
                RenderHelper.move(p_174521_, moveTypes, slot, moveBy5);
                moveByArmor = RenderHelper.hasEquipments(player, moveTypes, slot) ? 0.038f : 0.0f;
                RenderHelper.move(p_174521_, moveTypes, slot, moveByArmor);
                p_174521_.method_22907(class_7833.field_40714.rotationDegrees((float)slotRotations[slot * 3 + add5[3]]));
                p_174521_.method_22907(class_7833.field_40716.rotationDegrees((float)(slotRotations[slot * 3 + 1] + add5[4])));
                p_174521_.method_22907(class_7833.field_40718.rotationDegrees((float)(slotRotations[slot * 3 + 2] + add5[5])));
                class_811 ctx = class_811.field_4320;
                scalePlus = ((float)scale[slot] + 0.001f + (float)add5[6]) / 100.0f;
                f = 1.0f;
                p_174521_.method_22905(f + scalePlus, f + scalePlus, f + scalePlus);
                if (items[itemslot].method_7909() instanceof class_1753) {
                    RenderHelper.renderBowItem(itemslot, (class_1309)player, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                } else if (items[itemslot].method_7909() instanceof class_1764) {
                    RenderHelper.renderCrossbowItem(itemslot, (class_1309)player, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                } else if (items[itemslot].method_7909().getClass().equals(class_1835.class)) {
                    RenderHelper.renderTridentItem(itemslot, (class_1309)player, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                } else if (items[itemslot].method_7909() instanceof class_1831 && !(items[itemslot].method_7909() instanceof class_5151)) {
                    RenderHelper.renderTieredItem(itemslot, (class_1309)player, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                } else if (RenderHelper.whiteListed(items[itemslot], whitelist)) {
                    p_174521_.method_22904(0.0, 0.7, 0.0);
                    p_174521_.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
                    RenderHelper.renderNormalItem(itemslot, (class_1309)player, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                }
                p_174521_.method_22909();
            }
        }
        p_174521_.method_22909();
    }
}

