/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.fabrictailor.client.screen;

import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_457;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_490;
import net.minecraft.class_5244;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_7919;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.samo_lego.fabrictailor.client.ClientTailor;
import org.samo_lego.fabrictailor.client.screen.tabs.CapeTab;
import org.samo_lego.fabrictailor.client.screen.tabs.LocalSkinTab;
import org.samo_lego.fabrictailor.client.screen.tabs.PlayerSkinTab;
import org.samo_lego.fabrictailor.client.screen.tabs.SkinTabType;
import org.samo_lego.fabrictailor.client.screen.tabs.UrlSkinTab;
import org.samo_lego.fabrictailor.mixin.accessors.client.AAdvancementsScreen;
import org.samo_lego.fabrictailor.mixin.client.AAbstractClientPlayer;
import org.samo_lego.fabrictailor.util.TextTranslations;

@Environment(value=EnvType.CLIENT)
public class SkinChangeScreen
extends class_437 {
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTON_WIDTH = 100;
    private static final List<SkinTabType> TABS = new ArrayList<SkinTabType>(Arrays.asList(new PlayerSkinTab(), new UrlSkinTab(), new LocalSkinTab(), new CapeTab()));
    private class_342 skinInput;
    private int startX;
    private int startY;
    protected SkinTabType selectedTab;
    protected class_4286 skinModelCheckbox;
    private class_4185 openExplorerButton;

    public SkinChangeScreen() {
        super((class_2561)TextTranslations.create("options.skinCustomisation.title", new Object[0]));
    }

    protected void method_25426() {
        super.method_25426();
        int verticalSpacing = 8;
        this.openExplorerButton = class_4185.method_46430((class_2561)TextTranslations.create("button.fabrictailor.open_explorer", new Object[0]), buttonWidget -> class_156.method_668().method_672(new File(""))).method_46433(this.field_22789 / 2, this.field_22790 / 2 + 10).method_46436(class_7919.method_47407((class_2561)TextTranslations.create("hint.fabrictailor.dragAndDrop", new Object[0]))).method_46437(100, 20).method_46431();
        this.method_37063((class_364)this.openExplorerButton);
        this.skinModelCheckbox = new class_4286(this.field_22789 / 2, this.field_22790 / 2 - 12, 150, 20, (class_2561)TextTranslations.create("button.fabrictailor.use_slim", new Object[0]), false);
        this.method_37063((class_364)this.skinModelCheckbox);
        this.openExplorerButton.field_22764 = false;
        this.skinModelCheckbox.field_22764 = false;
        this.skinInput = new class_342(this.field_22793, this.field_22789 / 2, this.field_22790 / 2 - 29, 100, 14, (class_2561)class_2561.method_43471((String)"itemGroup.search").method_27692(class_124.field_1068));
        this.skinInput.method_1880(256);
        this.skinInput.method_1862(true);
        this.skinInput.method_1858(true);
        this.skinInput.method_1868(0xFFFFFF);
        this.method_25429((class_364)this.skinInput);
        this.method_37063((class_364)class_4185.method_46430((class_2561)TextTranslations.create("button.fabrictailor.apply", new Object[0]), onClick -> {
            this.applyNewSkin();
            this.method_25419();
        }).method_46433(this.field_22789 / 2, this.field_22790 / 2 + 30).method_46437(100, 20).method_46431());
        int buttonY = this.field_22790 - 20 - verticalSpacing;
        boolean allowDefaultSkinButton = ClientTailor.ALLOW_DEFAULT_SKIN || this.field_22787.method_1496();
        this.method_37063((class_364)class_4185.method_46430((class_2561)TextTranslations.create("button.fabrictailor.clear_skin", new Object[0]), onClick -> {
            this.clearSkin();
            this.method_25419();
        }).method_46433(this.field_22789 / 2 - 100 - (allowDefaultSkinButton ? 50 : 0) - 2, buttonY).method_46437(100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, onClick -> this.method_25419()).method_46433(this.field_22789 / 2 + (allowDefaultSkinButton ? 50 : 0) + 2, buttonY).method_46437(100, 20).method_46431());
        if (allowDefaultSkinButton) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)TextTranslations.create("button.fabrictailor.set_default_skin", new Object[0]), onClick -> {
                this.field_22787.field_1724.field_3944.method_45731("skin default");
                this.method_25419();
            }).method_46433(this.field_22789 / 2 - 50 - 1, buttonY).method_46437(100, 20).method_46431());
        }
    }

    private void clearSkin() {
        if (ClientTailor.TAILORED_SERVER) {
            this.field_22787.field_1724.field_3944.method_45731("skin clear");
        } else {
            ((AAbstractClientPlayer)this.field_22787.field_1724).ft_getPlayerInfo().method_2966().getProperties().removeAll((Object)"textures");
        }
    }

    private void applyNewSkin() {
        new CompletableFuture<Object>().completeAsync(() -> {
            Optional<Pair<class_2960, class_2540>> packetInfo = this.selectedTab.getSkinChangePacket(this.field_22787.field_1724, this.skinInput.method_1882(), this.skinModelCheckbox.method_20372());
            packetInfo.ifPresent(packet -> {
                if (ClientTailor.TAILORED_SERVER) {
                    ClientPlayNetworking.send((class_2960)((class_2960)packet.getFirst()), (class_2540)((class_2540)packet.getSecond()));
                } else {
                    PropertyMap map = ((AAbstractClientPlayer)this.field_22787.field_1724).ft_getPlayerInfo().method_2966().getProperties();
                    try {
                        map.removeAll((Object)"textures");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Property skinData = ((class_2540)packet.getSecond()).method_43624();
                    map.put((Object)"textures", (Object)skinData);
                    class_310.method_1551().method_1582().method_4652(((AAbstractClientPlayer)this.field_22787.field_1724).ft_getPlayerInfo().method_2966(), (type, resourceLocation, minecraftProfileTexture) -> {}, true);
                }
            });
            return null;
        });
    }

    public void method_25393() {
        super.method_25393();
        if (this.skinInput != null) {
            this.skinInput.method_1865();
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        this.startX = (this.field_22789 - 252) / 2;
        this.startY = (this.field_22790 - 140) / 2;
        RenderSystem.enableBlend();
        guiGraphics.method_25302(AAdvancementsScreen.getWINDOW_LOCATION(), this.startX, this.startY, 0, 0, 252, 140);
        this.skinInput.method_25394(guiGraphics, this.startX, this.startY, delta);
        this.drawTabs(guiGraphics, this.startX, this.startY, mouseX, mouseY);
        this.drawIcons(guiGraphics, this.startX, this.startY);
        this.drawWidgetTooltip(guiGraphics, this.startX, this.startY, mouseX, mouseY, delta);
        if (this.selectedTab.showModelBackwards()) {
            int x = this.startX + 50;
            int y = this.startY + 120;
            int size = 50;
            float mousex = -((float)this.field_22789 / 2.0f - 75.0f - (float)mouseX);
            float mousey = (float)this.field_22790 / 2.0f - (float)mouseY;
            class_746 entity = this.field_22787.field_1724;
            float f = (float)Math.atan(mousex / 40.0f);
            float g = (float)Math.atan(mousey / 40.0f);
            class_4587 poseStack = RenderSystem.getModelViewStack();
            poseStack.method_22903();
            poseStack.method_22904((double)x, (double)y, 1050.0);
            poseStack.method_22905(1.0f, 1.0f, -1.0f);
            RenderSystem.applyModelViewMatrix();
            class_4587 poseStack2 = new class_4587();
            poseStack2.method_22904(0.0, 0.0, 1000.0);
            poseStack2.method_22905((float)size, (float)size, (float)size);
            Quaternionf quaternion = class_7833.field_40718.rotationDegrees(180.0f);
            Quaternionf quaternion2 = class_7833.field_40714.rotationDegrees(g * 20.0f);
            quaternion.mul((Quaternionfc)quaternion2);
            poseStack2.method_22907(quaternion);
            float h = entity.field_6283;
            float i = entity.method_36454();
            float j = entity.method_36455();
            float k = entity.field_6259;
            float l = entity.field_6241;
            entity.field_6283 = f * 20.0f;
            entity.method_36456(f * 40.0f);
            entity.method_36457(-g * 20.0f);
            entity.field_6241 = entity.method_36454();
            entity.field_6259 = entity.method_36454();
            class_308.method_34742();
            class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
            quaternion2.conjugate();
            entityRenderDispatcher.method_24196(quaternion2);
            entityRenderDispatcher.method_3948(false);
            class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
            RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack2, (class_4597)bufferSource, 0xF000F0));
            bufferSource.method_22993();
            entityRenderDispatcher.method_3948(true);
            entity.field_6283 = h;
            entity.method_36456(i);
            entity.method_36457(j);
            entity.field_6259 = k;
            entity.field_6241 = l;
            poseStack.method_22909();
            RenderSystem.applyModelViewMatrix();
            class_308.method_24211();
        } else {
            float mousex = (float)this.field_22789 / 2.0f - 75.0f - (float)mouseX;
            float mousey = (float)this.field_22790 / 2.0f - (float)mouseY;
            class_490.method_2486((class_332)guiGraphics, (int)(this.startX + 51), (int)(this.startY + 120), (int)50, (float)mousex, (float)mousey, (class_1309)this.field_22787.field_1724);
        }
    }

    private void drawTabs(class_332 guiGraphics, int startX, int startY, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        for (int i = 0; i < TABS.size(); ++i) {
            SkinTabType tab = TABS.get(i);
            if (this.selectedTab == null) {
                this.selectedTab = tab;
                continue;
            }
            if (this.selectedTab == tab) {
                guiGraphics.method_25302(class_457.field_2716, startX + 224 - i * 27, startY - 28, i == 0 ? 56 : 28, 32, 28, 32);
                this.skinModelCheckbox.field_22764 = tab.hasSkinModels();
                this.openExplorerButton.field_22764 = tab.showExplorerButton();
                continue;
            }
            guiGraphics.method_25302(class_457.field_2716, startX + 224 - i * 27, startY - 28, i == 0 ? 56 : 28, 0, 28, i == 0 ? 31 : 29);
        }
        guiGraphics.method_27535(this.field_22793, this.selectedTab.getTitle(), startX + 10, startY + 5, 0xFFFFFF);
        guiGraphics.method_27535(this.field_22793, this.selectedTab.getDescription(), this.field_22789 / 2, this.field_22790 / 2 - 40, 0xFFFFFF);
        RenderSystem.defaultBlendFunc();
    }

    private void drawIcons(class_332 guiGraphics, int startX, int startY) {
        for (int i = 0; i < TABS.size(); ++i) {
            SkinTabType tab = TABS.get(i);
            guiGraphics.method_51427(tab.getIcon(), startX + 231 - i * 27, startY - 18);
        }
        RenderSystem.disableBlend();
    }

    private void drawWidgetTooltip(class_332 guiGraphics, int startX, int startY, int mouseX, int mouseY, float delta) {
        for (int i = 0; i < TABS.size(); ++i) {
            SkinTabType tab = TABS.get(i);
            if (!tab.isSelected(startX + 225 - i * 27, startY - 28, mouseX, mouseY)) continue;
            guiGraphics.method_51438(this.field_22793, tab.getTitle(), mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (int i = 0; i < TABS.size(); ++i) {
                SkinTabType tab = TABS.get(i);
                if (!tab.isSelected(this.startX + 225 - i * 27, this.startY - 28, (int)mouseX, (int)mouseY)) continue;
                this.selectedTab = tab;
                break;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_29638(List<Path> paths) {
        if (!(this.selectedTab instanceof PlayerSkinTab)) {
            this.skinInput.method_1852(paths.iterator().next().toString());
        }
    }
}

