/*
 * Decompiled with CFR 0.152.
 */
package io.github.steveplays28.stevesrealisticsleep.util;

import io.github.steveplays28.stevesrealisticsleep.StevesRealisticSleep;
import io.github.steveplays28.stevesrealisticsleep.config.StevesRealisticSleepConfig;

public class SleepMathUtil {
    public static final int DAY_LENGTH = 24000;
    public static final int DAWN_WAKE_UP_TIME = 23449;
    public static final int DUSK_WAKE_UP_TIME = 12449;
    public static final double WAKE_UP_GRACE_PERIOD_TICKS = Math.max(StevesRealisticSleep.config.sleepSpeedMultiplier, 20.0);
    public static final int MINIMUM_SLEEP_TICKS_TO_CLEAR_WEATHER = 2400;

    public static double calculateTimeStepPerTick(double sleepingRatio, double multiplier, double lastTimeStepPerTick) {
        return switch (StevesRealisticSleep.config.sleepSpeedCurve) {
            default -> throw new IncompatibleClassChangeError();
            case StevesRealisticSleepConfig.SleepSpeedCurve.STATIC -> multiplier;
            case StevesRealisticSleepConfig.SleepSpeedCurve.LINEAR -> sleepingRatio * multiplier;
            case StevesRealisticSleepConfig.SleepSpeedCurve.EXPONENTIAL -> Math.pow(lastTimeStepPerTick, 1.0 + sleepingRatio * multiplier);
        };
    }

    public static int calculateTicksToTimeOfDay(int timeOfDay, int targetTimeOfDay) {
        return targetTimeOfDay - timeOfDay;
    }

    public static int calculateTicksUntilAwake(int currentTimeOfDay) {
        return Math.abs(SleepMathUtil.calculateTicksToTimeOfDay(currentTimeOfDay, SleepMathUtil.isNightTime(currentTimeOfDay) ? 23449 : 12449));
    }

    public static int calculateSecondsUntilAwake(int currentTimeOfDay, double timeStepPerTick, double tps) {
        return (int)Math.round((double)SleepMathUtil.calculateTicksUntilAwake(currentTimeOfDay % 24000) / timeStepPerTick / tps);
    }

    public static double getRandomNumberInRange(double min, double max) {
        return Math.random() * (max - min) + min;
    }

    public static boolean isNightTime(long currentTimeOfDay) {
        return currentTimeOfDay > 12449L && currentTimeOfDay < 23449L;
    }
}

