/*
 * Decompiled with CFR 0.152.
 */
package io.github.steveplays28.stevesrealisticsleep.mixin;

import io.github.steveplays28.stevesrealisticsleep.StevesRealisticSleep;
import io.github.steveplays28.stevesrealisticsleep.api.StevesRealisticSleepApi;
import io.github.steveplays28.stevesrealisticsleep.extension.ServerWorldExtension;
import io.github.steveplays28.stevesrealisticsleep.util.SleepMathUtil;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2513;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2761;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_3767;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5268;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5838;
import net.minecraft.class_6757;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3218.class})
public abstract class ServerWorldMixin
extends class_1937
implements ServerWorldExtension {
    @Shadow
    @Final
    protected class_3767 field_18811;
    @Shadow
    @Final
    List<class_3222> field_18261;
    @Shadow
    @Final
    private static int field_35441;
    @Shadow
    @Final
    private class_5268 field_24456;
    @Shadow
    @Final
    private MinecraftServer field_13959;
    @Shadow
    @Final
    private class_5838 field_28859;
    @Shadow
    @Final
    private class_3215 field_24624;
    @Shadow
    @Final
    private class_6757<class_3611> field_13951;
    @Shadow
    @Final
    private boolean field_25143;
    @Unique
    private double stevesrealisticsleep$timeStepPerTick = 2.0;
    @Unique
    private long stevesrealisticsleep$tickDelay;
    @Unique
    private class_5250 stevesrealisticsleep$sleepMessage;
    @Unique
    private boolean stevesrealisticsleep$shouldSkipWeather = false;
    @Unique
    private int stevesrealisticsleep$consecutiveSleepTicks = 0;

    protected ServerWorldMixin(class_5269 properties, class_5321<class_1937> registryRef, class_5455 registryManager, class_6880<class_2874> dimensionEntry, Supplier<class_3695> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }

    @Shadow
    public abstract class_3218 method_8410();

    @Shadow
    public abstract List<class_3222> method_18456();

    @Shadow
    protected abstract void method_23660();

    @Shadow
    protected abstract class_2338 method_18210(class_2338 var1);

    @Shadow
    protected abstract void method_14171(class_2338 var1, class_3611 var2);

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getInt(Lnet/minecraft/world/GameRules$Key;)I")})
    public void stevesrealisticsleep$tick(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        int i;
        int sleepingPlayerCount = this.field_28859.method_33815();
        int playerCount = this.method_18456().size();
        double sleepingRatio = (double)sleepingPlayerCount / (double)playerCount;
        this.stevesrealisticsleep$timeStepPerTick = SleepMathUtil.calculateTimeStepPerTick(sleepingRatio, StevesRealisticSleep.config.sleepSpeedMultiplier, this.stevesrealisticsleep$timeStepPerTick);
        int timeOfDay = StevesRealisticSleepApi.getTimeOfDay(this);
        int secondsUntilAwake = Math.abs(SleepMathUtil.calculateSecondsUntilAwake(timeOfDay, this.stevesrealisticsleep$timeStepPerTick, 20.0));
        if (secondsUntilAwake <= 2 && this.stevesrealisticsleep$shouldSkipWeather) {
            this.stevesrealisticsleep$clearWeather();
            this.stevesrealisticsleep$shouldSkipWeather = false;
        }
        if (sleepingPlayerCount <= 0) {
            this.stevesrealisticsleep$consecutiveSleepTicks = 0;
            return;
        }
        boolean isNight = SleepMathUtil.isNightTime(timeOfDay);
        class_5250 nightDayOrThunderstormText = class_2561.method_43471((String)String.format("%s.text.%s", "steves_realistic_sleep", this.field_24456.method_203() ? "thunderstorm" : (isNight ? "night" : "day")));
        if (!StevesRealisticSleepApi.isSleeping(this)) {
            if (!StevesRealisticSleep.config.sendNotEnoughPlayersSleepingMessage) {
                return;
            }
            double playersRequiredToSleepRatio = (double)this.field_13959.method_3767().method_8356(class_1928.field_28357) / 100.0;
            int playersRequiredToSleep = (int)Math.ceil(playersRequiredToSleepRatio * (double)playerCount);
            for (class_3222 player : this.field_18261) {
                player.method_7353((class_2561)class_2561.method_43469((String)String.format("%s.text.not_enough_players_sleeping_message", "steves_realistic_sleep"), (Object[])new Object[]{sleepingPlayerCount, playerCount, playersRequiredToSleep, playerCount, nightDayOrThunderstormText}), true);
            }
            return;
        }
        int timeStepPerTickRounded = (int)Math.round(this.stevesrealisticsleep$timeStepPerTick);
        int ticksUntilAwake = SleepMathUtil.calculateTicksUntilAwake(timeOfDay);
        boolean doDayLightCycle = this.field_13959.method_3767().method_8355(class_1928.field_19396);
        int blockEntityTickSpeedMultiplier = (int)Math.round(StevesRealisticSleep.config.blockEntityTickSpeedMultiplier);
        int chunkTickSpeedMultiplier = (int)Math.round(StevesRealisticSleep.config.chunkTickSpeedMultiplier);
        int raidTickSpeedMultiplier = (int)Math.round(StevesRealisticSleep.config.raidTickSpeedMultiplier);
        int fluidScheduledTickSpeedMultiplier = (int)Math.round(StevesRealisticSleep.config.fluidScheduledTickSpeedMultiplier);
        if (doDayLightCycle) {
            this.field_24456.method_29035(this.field_24456.method_217() + (long)timeStepPerTickRounded);
        }
        for (i = blockEntityTickSpeedMultiplier; i > 1; --i) {
            this.method_18471();
        }
        for (i = chunkTickSpeedMultiplier; i > 1; --i) {
            this.field_24624.method_12127(shouldKeepTicking, true);
        }
        for (i = raidTickSpeedMultiplier; i > 1; --i) {
            this.field_18811.method_16539();
        }
        for (i = fluidScheduledTickSpeedMultiplier; i > 1; --i) {
            this.field_13951.method_39377(this.field_24456.method_217(), field_35441, this::method_14171);
        }
        this.field_13959.method_3760().method_14589((class_2596)new class_2761(this.field_24456.method_188(), this.field_24456.method_217(), doDayLightCycle), this.method_27983());
        if ((double)ticksUntilAwake > SleepMathUtil.WAKE_UP_GRACE_PERIOD_TICKS) {
            if (this.stevesrealisticsleep$consecutiveSleepTicks >= 2400) {
                this.stevesrealisticsleep$shouldSkipWeather = true;
            }
            if (StevesRealisticSleep.config.sendSleepingMessage) {
                this.stevesrealisticsleep$sleepMessage = class_2561.method_43469((String)String.format("%s.text.sleep_message", "steves_realistic_sleep"), (Object[])new Object[]{sleepingPlayerCount, playerCount}).method_10852((class_2561)nightDayOrThunderstormText);
                if (isNight) {
                    if (StevesRealisticSleep.config.showTimeUntilDawn) {
                        this.stevesrealisticsleep$sleepMessage.method_10852((class_2561)class_2561.method_43469((String)String.format("%s.text.time_until_dawn", "steves_realistic_sleep"), (Object[])new Object[]{secondsUntilAwake}));
                    }
                } else if (StevesRealisticSleep.config.showTimeUntilDusk) {
                    this.stevesrealisticsleep$sleepMessage.method_10852((class_2561)class_2561.method_43469((String)String.format("%s.text.time_until_dusk", "steves_realistic_sleep"), (Object[])new Object[]{secondsUntilAwake}));
                }
            }
            for (class_3222 player : this.field_18261) {
                player.method_7353((class_2561)this.stevesrealisticsleep$sleepMessage, true);
            }
            this.stevesrealisticsleep$consecutiveSleepTicks += timeStepPerTickRounded;
        }
        if ((double)ticksUntilAwake <= SleepMathUtil.WAKE_UP_GRACE_PERIOD_TICKS) {
            this.method_23660();
            this.stevesrealisticsleep$timeStepPerTick = 2.0;
        }
    }

    @Inject(method={"tickTime"}, at={@At(value="HEAD")}, cancellable=true)
    public void stevesrealisticsleep$tickTimeWithTimeTickSpeedMultiplier(@NotNull CallbackInfo ci) {
        this.field_24456.method_143().method_988((Object)this.field_13959, this.field_9232.method_188());
        if (!this.field_25143) {
            ci.cancel();
            return;
        }
        long l = this.field_9232.method_188() + 1L;
        if (this.field_28859.method_33815() <= 0) {
            this.field_24456.method_29034(l);
        }
        if (this.stevesrealisticsleep$tickDelay > 0L) {
            --this.stevesrealisticsleep$tickDelay;
            this.field_13959.method_3760().method_14589((class_2596)new class_2761(this.field_24456.method_188(), this.field_24456.method_217(), this.field_9232.method_146().method_8355(class_1928.field_19396)), this.method_27983());
            ci.cancel();
            return;
        }
        if (this.field_28859.method_33815() > 0) {
            return;
        }
        if (this.field_9232.method_146().method_8355(class_1928.field_19396)) {
            this.field_24456.method_29035(this.field_9232.method_217() + 1L);
        }
        this.stevesrealisticsleep$tickDelay = StevesRealisticSleep.config.tickDelay;
        ci.cancel();
    }

    @Inject(method={"sendSleepingStatus"}, at={@At(value="HEAD")}, cancellable=true)
    private void stevesrealisticsleep$preventSendingSleepingStatus(@NotNull CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"tickChunk"}, at={@At(value="HEAD")})
    private void stevesrealisticsleep$tickChunksWithChunkTickSpeedMultiplier(@NotNull class_2818 chunk, int randomTickSpeed, CallbackInfo ci) {
        class_2338 blockPos;
        int i;
        if (!StevesRealisticSleepApi.isSleeping(this)) {
            return;
        }
        int thunderTickSpeedMultiplier = (int)Math.round(StevesRealisticSleep.config.thunderTickSpeedMultiplier);
        int iceAndSnowTickSpeedMultiplier = (int)Math.round(StevesRealisticSleep.config.iceAndSnowTickSpeedMultiplier);
        class_3695 profiler = this.method_16107();
        class_1923 chunkPos = chunk.method_12004();
        int chunkStartPosX = chunkPos.method_8326();
        int chunkStartPosZ = chunkPos.method_8328();
        profiler.method_15396(String.format("Thunder (%s)", "Steve's Realistic Sleep"));
        for (i = 0; i < thunderTickSpeedMultiplier; ++i) {
            class_1538 lightningEntity;
            if (!this.method_8419() || !this.method_8546() || this.field_9229.method_43048(100000) != 0 || !this.method_8520(blockPos = this.method_18210(this.method_8536(chunkStartPosX, 0, chunkStartPosZ, 15))) || (lightningEntity = (class_1538)class_1299.field_6112.method_5883((class_1937)this)) == null) continue;
            lightningEntity.method_29495(class_243.method_24955((class_2382)blockPos));
            lightningEntity.method_29498(true);
            this.method_8649((class_1297)lightningEntity);
        }
        if (randomTickSpeed <= 0) {
            profiler.method_15407();
            return;
        }
        profiler.method_15405(String.format("Form ice and snow (%s)", "Steve's Realistic Sleep"));
        for (i = 0; i < iceAndSnowTickSpeedMultiplier; ++i) {
            if (this.field_9229.method_43048(16) != 0) continue;
            blockPos = this.method_8598(class_2902.class_2903.field_13197, this.method_8536(chunkStartPosX, 0, chunkStartPosZ, 15));
            class_2338 blockPosDown = blockPos.method_10074();
            class_1959 biome = (class_1959)this.method_23753(blockPos).comp_349();
            if (biome.method_8705((class_4538)this, blockPosDown)) {
                this.method_8501(blockPosDown, class_2246.field_10295.method_9564());
            }
            if (!this.method_8419() || !biome.method_8696((class_4538)this, blockPos)) continue;
            this.method_8501(blockPos, class_2246.field_10477.method_9564());
        }
        profiler.method_15405(String.format("Tick blocks (%s)", "Steve's Realistic Sleep"));
        for (int l = 0; l < chunk.method_12006().length; ++l) {
            class_2680 randomBlockStateInChunk;
            class_2338 randomPosInChunk;
            int chunkSectionYOffset;
            int i2;
            class_2826 chunkSection = chunk.method_12006()[l];
            if (!chunkSection.method_12262()) continue;
            int cropGrowthTickSpeedMultiplier = (int)Math.round(StevesRealisticSleep.config.cropGrowthTickSpeedMultiplier);
            int precipitationTickSpeedMultiplier = (int)Math.round(StevesRealisticSleep.config.precipitationTickSpeedMultiplier);
            int blockRandomTickSpeedMultiplier = (int)Math.round(StevesRealisticSleep.config.blockRandomTickSpeedMultiplier);
            int fluidRandomTickSpeedMultiplier = (int)Math.round(StevesRealisticSleep.config.fluidRandomTickSpeedMultiplier);
            for (i2 = 0; i2 < cropGrowthTickSpeedMultiplier; ++i2) {
                chunkSectionYOffset = class_4076.method_18688((int)chunk.method_31604(l));
                randomPosInChunk = this.method_8536(chunkStartPosX, chunkSectionYOffset, chunkStartPosZ, 15);
                randomBlockStateInChunk = chunkSection.method_12254(randomPosInChunk.method_10263() - chunkStartPosX, randomPosInChunk.method_10264() - chunkSectionYOffset, randomPosInChunk.method_10260() - chunkStartPosZ);
                class_2248 randomBlockInChunk = randomBlockStateInChunk.method_26204();
                if (this.method_22346(randomPosInChunk, 0) < 9) continue;
                if (randomBlockInChunk instanceof class_2302) {
                    class_2302 cropBlock = (class_2302)randomBlockInChunk;
                    cropBlock.method_9652(this.method_8410(), this.field_9229, randomPosInChunk, randomBlockStateInChunk);
                    continue;
                }
                if (!(randomBlockInChunk instanceof class_2513)) continue;
                class_2513 stemBlock = (class_2513)randomBlockInChunk;
                stemBlock.method_9652(this.method_8410(), this.field_9229, randomPosInChunk, randomBlockStateInChunk);
            }
            for (i2 = 0; i2 < precipitationTickSpeedMultiplier; ++i2) {
                class_2680 randomBlockStateInChunk2;
                class_2248 randomBlockInChunk;
                chunkSectionYOffset = class_4076.method_18688((int)chunk.method_31604(l));
                randomPosInChunk = this.method_8536(chunkStartPosX, chunkSectionYOffset, chunkStartPosZ, 15);
                class_1959 biome = (class_1959)this.method_23753(randomPosInChunk).comp_349();
                class_1959.class_1963 precipitation = biome.method_48162(randomPosInChunk);
                if (precipitation == class_1959.class_1963.field_9384 || !((randomBlockInChunk = (randomBlockStateInChunk2 = chunkSection.method_12254(randomPosInChunk.method_10263() - chunkStartPosX, randomPosInChunk.method_10264() - chunkSectionYOffset, randomPosInChunk.method_10260() - chunkStartPosZ)).method_26204()) instanceof class_2275)) continue;
                class_2275 cauldronBlock = (class_2275)randomBlockInChunk;
                cauldronBlock.method_9504(randomBlockStateInChunk2, (class_1937)this, randomPosInChunk, precipitation);
                cauldronBlock.method_9588(randomBlockStateInChunk2, this.method_8410(), randomPosInChunk, this.field_9229);
            }
            for (int j = 0; j < randomTickSpeed; ++j) {
                int k;
                chunkSectionYOffset = class_4076.method_18688((int)chunk.method_31604(l));
                randomPosInChunk = this.method_8536(chunkStartPosX, chunkSectionYOffset, chunkStartPosZ, 15);
                randomBlockStateInChunk = chunkSection.method_12254(randomPosInChunk.method_10263() - chunkStartPosX, randomPosInChunk.method_10264() - chunkSectionYOffset, randomPosInChunk.method_10260() - chunkStartPosZ);
                class_3610 fluidState = randomBlockStateInChunk.method_26227();
                for (k = 0; k < blockRandomTickSpeedMultiplier; ++k) {
                    if (!randomBlockStateInChunk.method_26229()) continue;
                    randomBlockStateInChunk.method_26199(this.method_8410(), randomPosInChunk, this.field_9229);
                }
                for (k = 0; k < fluidRandomTickSpeedMultiplier; ++k) {
                    if (!fluidState.method_15773()) continue;
                    fluidState.method_15757((class_1937)this, randomPosInChunk, this.field_9229);
                }
            }
            profiler.method_15407();
        }
    }

    @Unique
    private void stevesrealisticsleep$clearWeather() {
        boolean doWeatherCycle = this.field_13959.method_3767().method_8355(class_1928.field_19406);
        if (doWeatherCycle && (this.field_24456.method_156() || this.field_24456.method_203())) {
            int nextRainTime = (int)(24000.0 * SleepMathUtil.getRandomNumberInRange(0.5, 7.5));
            this.field_24456.method_164(nextRainTime);
            this.field_24456.method_173(nextRainTime + (Math.random() > 0.0 ? 1 : -1));
            this.field_24456.method_147(false);
            this.field_24456.method_157(false);
        }
    }
}

