/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.vfx;

import com.lootbeams.LootBeams;
import com.lootbeams.compat.iris.IrisCompat;
import com.lootbeams.config.Configuration;
import com.lootbeams.features.CustomLootBeamsConfig;
import com.lootbeams.managers.ParticleManager;
import com.lootbeams.managers.RenderManager;
import com.lootbeams.render.LootBeamRenderLayers;
import com.lootbeams.render.ParticleRenderType;
import com.lootbeams.shaders.LootBeamShaders;
import com.lootbeams.vfx.Trail;
import com.lootbeams.vfx.VFXParticleType;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class VFXParticle
extends class_4003 {
    private final boolean fullbright;
    private boolean stoppedByCollision;
    private boolean hasTrail = false;
    private float yHeightCompensation = 0.5f;
    private static final class_2960 TEXTURE = LootBeams.id("textures/trail/white.png");
    Trail trail;
    class_243 particleCenter = class_243.field_1353;
    class_243 axis;
    class_1799 itemStack;
    ParticleManager.ParticleTexture texture;
    Configuration config;
    private long lastUpdate = 0L;
    private static final int TARGET_FPS = 60;
    private static final long TARGET_FRAME_TIME = 16L;
    private int currentFrame = 0;
    private int tickDelayCounter = 0;
    public static final ParticleRenderType RENDER_TYPE = new ParticleRenderType();

    public VFXParticle(class_638 world, ParticleManager.ParticleTexture texture, class_1799 itemStack, float r, float g, float b, float a, int lifetime, float size, class_243 pos, class_243 motion, float gravity, boolean collision, boolean fullbright) {
        super(world, pos.field_1352, pos.field_1351, pos.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
        this.texture = texture;
        this.method_18141(this.texture.getSprite());
        this.itemStack = itemStack;
        this.config = CustomLootBeamsConfig.fromItemStack(this.itemStack);
        this.axis = new class_243(0.0, (double)(this.config.beamYOffset + this.config.beamHeight + this.yHeightCompensation), 0.0);
        this.field_3861 = r;
        this.field_3842 = g;
        this.field_3859 = b;
        this.field_3841 = Math.min(a, 1.0f);
        this.field_3847 = lifetime + 5;
        this.setSize(size);
        this.field_3852 = motion.field_1352;
        this.field_3869 = motion.field_1351;
        this.field_3850 = motion.field_1350;
        this.field_3844 = gravity;
        this.field_3862 = collision;
        this.fullbright = fullbright;
        boolean bl = this.hasTrail = Math.random() < (double)this.config.trailChance;
        if (this.hasTrail && this.config.trailParticlesInvisible) {
            this.setSize(1.0E-5f);
        }
        if (this.config.trails && this.hasTrail) {
            this.trail = new Trail(class_5253.class_5254.method_27764((int)((int)(r * 255.0f)), (int)((int)(g * 255.0f)), (int)((int)(b * 255.0f)), (int)((int)(a * 255.0f))), width -> Float.valueOf((float)((double)((float)Math.sin((double)width.floatValue() * 3.15) / 2.0f * 0.09f * this.config.trailWidth) * (1.0 + Math.random()))));
            this.trail.setStack(this.itemStack);
            this.trail.setColor(r, g, b, a);
            this.trail.setBillboard(true);
            this.trail.setLength((int)((double)this.config.trailLength * (1.0 + Math.random())));
            this.trail.setFrequency(this.config.trailFrequency);
            this.trail.pushPoint(new class_243(this.field_3874, this.field_3854, this.field_3871));
        }
    }

    private void updateTrailPoints(float partialTicks) {
        if (this.config.trails && this.hasTrail && this.trail != null) {
            this.trail.pushPoint(new class_243((double)((float)class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874)), (double)((float)class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854)), (double)((float)class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871))));
        }
    }

    private Vector3f[] calculateParticleVectors(class_4184 camera, float partialTicks) {
        class_243 vec3 = camera.method_19326();
        float f = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874) - vec3.method_10216());
        float f1 = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854) - vec3.method_10214());
        float f2 = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871) - vec3.method_10215());
        Quaternionf quaternionf = new Quaternionf((Quaternionfc)camera.method_23767());
        if (this.field_3839 != 0.0f) {
            quaternionf.rotateZ(class_3532.method_16439((float)partialTicks, (float)this.field_3857, (float)this.field_3839));
        }
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f3 = this.method_18132(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(f3);
            vector3f.add(f, f1, f2);
        }
        return avector3f;
    }

    private void renderParticles(class_4588 vertexConsumer, class_4184 camera, float partialTicks) {
        float A;
        Vector3f[] particleVectors = this.calculateParticleVectors(camera, partialTicks);
        float minX = this.method_18133();
        float maxX = this.method_18134();
        float minY = this.method_18135();
        float maxY = this.method_18136();
        int j = this.method_3068(partialTicks);
        boolean particleInheritsColor = this.config.particleInheritsColor && !this.texture.isColored();
        float averageColor = LootBeamShaders.getAverageColor(this.config.particleColorMode);
        float R = particleInheritsColor ? this.field_3861 : averageColor;
        float G = particleInheritsColor ? this.field_3842 : averageColor;
        float B = particleInheritsColor ? this.field_3859 : averageColor;
        float f = A = particleInheritsColor ? this.field_3841 : 1.0f;
        if (IrisCompat.isShaderPackInUse()) {
            vertexConsumer.method_22912((double)particleVectors[0].x(), (double)particleVectors[0].y(), (double)particleVectors[0].z()).method_22915(R, G, B, A).method_22913(maxX, maxY).method_22922(class_4608.field_21444).method_22916(j).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            vertexConsumer.method_22912((double)particleVectors[1].x(), (double)particleVectors[1].y(), (double)particleVectors[1].z()).method_22915(R, G, B, A).method_22913(maxX, minY).method_22922(class_4608.field_21444).method_22916(j).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            vertexConsumer.method_22912((double)particleVectors[2].x(), (double)particleVectors[2].y(), (double)particleVectors[2].z()).method_22915(R, G, B, A).method_22913(minX, minY).method_22922(class_4608.field_21444).method_22916(j).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            vertexConsumer.method_22912((double)particleVectors[3].x(), (double)particleVectors[3].y(), (double)particleVectors[3].z()).method_22915(R, G, B, A).method_22913(minX, maxY).method_22922(class_4608.field_21444).method_22916(j).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            return;
        }
        vertexConsumer.method_22912((double)particleVectors[0].x(), (double)particleVectors[0].y(), (double)particleVectors[0].z()).method_22913(maxX, maxY).method_22915(R, G, B, A).method_22916(j).method_1344();
        vertexConsumer.method_22912((double)particleVectors[1].x(), (double)particleVectors[1].y(), (double)particleVectors[1].z()).method_22913(maxX, minY).method_22915(R, G, B, A).method_22916(j).method_1344();
        vertexConsumer.method_22912((double)particleVectors[2].x(), (double)particleVectors[2].y(), (double)particleVectors[2].z()).method_22913(minX, minY).method_22915(R, G, B, A).method_22916(j).method_1344();
        vertexConsumer.method_22912((double)particleVectors[3].x(), (double)particleVectors[3].y(), (double)particleVectors[3].z()).method_22913(minX, maxY).method_22915(R, G, B, A).method_22916(j).method_1344();
    }

    private void renderTrail() {
        if (this.config.trails && this.hasTrail && this.trail != null) {
            this.trail.setColor(this.field_3861, this.field_3842, this.field_3859, this.field_3841);
            this.trail.setCenterPoint(this.particleCenter);
            RenderManager.addRenderBeforeEnd((matrixStack, consumer) -> {
                this.trail.render((class_4587)matrixStack, class_310.method_1551().method_22940().method_23000().getBuffer(LootBeamRenderLayers.translucentNoCull(TEXTURE)));
                consumer.method_22993();
            });
        }
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float partialTicks) {
        long currentTime = System.currentTimeMillis();
        this.renderParticles(vertexConsumer, camera, partialTicks);
        if (currentTime - this.lastUpdate > 16L) {
            this.updateTrailPoints(partialTicks);
            this.lastUpdate = currentTime;
        }
        this.renderTrail();
    }

    public void setParticleCenter(class_243 particleCenter) {
        this.particleCenter = particleCenter;
    }

    private void applyForce() {
        class_243 particleToCenter = this.particleCenter.method_1020(this.getPosition());
        class_243 particleToCenterOnAxis = particleToCenter.method_1020(this.axis.method_1021(particleToCenter.method_1026(this.axis)));
        class_243 particleToCenterOnAxisUnit = particleToCenterOnAxis.method_1029();
        class_243 particleToCenterOnAxisUnitCrossVortexAxis = particleToCenterOnAxisUnit.method_1036(this.axis);
        class_243 particleToCenterOnAxisUnitCrossVortexAxisUnit = particleToCenterOnAxisUnitCrossVortexAxis.method_1029();
        class_243 particleToCenterOnAxisUnitCrossVortexAxisUnitScaled = particleToCenterOnAxisUnitCrossVortexAxisUnit.method_1021((double)0.01f);
        this.field_3852 += particleToCenterOnAxisUnitCrossVortexAxisUnitScaled.field_1352 * 0.65;
        this.field_3869 += particleToCenterOnAxisUnitCrossVortexAxisUnitScaled.field_1351;
        this.field_3850 += particleToCenterOnAxisUnitCrossVortexAxisUnitScaled.field_1350 * 0.65;
        class_243 target = this.particleCenter.method_1019(this.axis.method_1031(0.0, (double)this.config.beamYOffset, 0.0));
        class_243 particleToTarget = target.method_1020(this.getPosition());
        class_243 particleToTargetUnit = particleToTarget.method_1029();
        int mod = this.config.particleDirectionY >= 0.0f ? (this.field_3854 > target.field_1351 ? 0 : 1) : (this.field_3854 < target.field_1351 ? 0 : -1);
        class_243 particleToTargetUnitScaled = particleToTargetUnit.method_18805((double)(this.config.particleSpeedX * (float)mod), (double)(this.config.particleSpeedY * (float)mod), (double)(this.config.particleSpeedZ * (float)mod));
        this.field_3852 += particleToTargetUnitScaled.field_1352;
        this.field_3869 += this.config.particleUseConstantVerticalSpeed ? (double)this.config.particleSpeedY : particleToTargetUnitScaled.field_1351;
        this.field_3850 += particleToTargetUnitScaled.field_1350;
    }

    private class_243 getPosition() {
        return new class_243(this.field_3874, this.field_3854, this.field_3871);
    }

    protected int method_3068(float tint) {
        if (this.fullbright) {
            return class_765.method_23687((int)15, (int)15);
        }
        return super.method_3068(tint);
    }

    public void setSize(float size) {
        this.field_17867 = size / 10.0f;
        this.method_3080(size / 10.0f, size / 10.0f);
    }

    private void updateParticleSprite() {
        if (this.texture.isSplitted()) {
            ++this.tickDelayCounter;
            if (this.tickDelayCounter >= this.config.tickPerParticleSpriteUpdate) {
                ++this.currentFrame;
                if (this.currentFrame >= this.texture.getFrameCount()) {
                    this.currentFrame = 0;
                }
                this.tickDelayCounter = 0;
            }
        }
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.config.spinAroundBeam) {
            this.applyForce();
        }
        if (this.texture.isSplitted() && this.config.tickPerParticleSpriteUpdate > 0) {
            this.updateParticleSprite();
            this.method_18141(this.texture.getSprite(this.currentFrame));
        }
        if (this.field_3866 > this.field_3847 - 5) {
            this.field_3841 = 1.0f - (float)(this.field_3866 - (this.field_3847 - 5)) / 5.0f;
        }
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        } else {
            this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        }
    }

    public void method_3069(double x, double y, double z) {
        if (!this.stoppedByCollision) {
            double dX = x;
            double dY = y;
            double dZ = z;
            if (this.field_3862 && (x != 0.0 || y != 0.0 || z != 0.0)) {
                class_243 vector3d = class_1297.method_20736(null, (class_243)new class_243(x, y, z), (class_238)this.method_3064(), (class_1937)this.field_3851, List.of());
                x = vector3d.field_1352;
                y = vector3d.field_1351;
                z = vector3d.field_1350;
            }
            if (x != 0.0 || y != 0.0 || z != 0.0) {
                this.method_3067(this.method_3064().method_989(x, y, z));
                this.method_3072();
            } else {
                this.stoppedByCollision = true;
            }
            if (dX != x) {
                this.field_3852 = 0.0;
            }
            if (dY != y) {
                this.field_3869 = 0.0;
            }
            if (dZ != z) {
                this.field_3850 = 0.0;
            }
        }
    }

    public class_3999 method_18122() {
        if (this.config.particleColorMode != null) {
            return RENDER_TYPE.setTexture(this.field_17886.method_45852()).setShader(this.config.particleColorMode);
        }
        return RENDER_TYPE.setTexture(this.field_17886.method_45852());
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<class_2400> {
        public Factory(class_4002 spriteSet) {
        }

        @Nullable
        public class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velX, double velY, double velZ) {
            if (parameters instanceof VFXParticleType) {
                VFXParticleType type = (VFXParticleType)parameters;
                VFXParticle vfxParticle = new VFXParticle(world, type.texture, type.itemStack, type.red, type.green, type.blue, type.alpha, type.lifetime, type.size, new class_243(x, y, z), new class_243(velX, velY, velZ), type.gravity, type.collision, type.fullbright);
                vfxParticle.setParticleCenter(type.sourcePos);
                return vfxParticle;
            }
            return null;
        }
    }
}

