/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.vfx;

import com.lootbeams.LootBeams;
import com.lootbeams.config.Configuration;
import com.lootbeams.features.CustomLootBeamsConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Trail {
    private class_243[] points;
    private class_243[] rotations;
    private class_243 centerPoint;
    private int color;
    private Function<Float, Float> widthFunction;
    private int length = 100;
    private boolean billboard = true;
    private TilingMode tilingMode = TilingMode.STRETCH;
    private int frequency = 1;
    private float minDistance = 0.0f;
    private class_2960 texture = null;
    private boolean parentRotation = false;
    private class_1799 stack = null;
    private Configuration config = LootBeams.config;

    public Trail(class_243[] points, int color, Function<Float, Float> widthFunction) {
        this.points = points;
        this.color = color;
        this.widthFunction = widthFunction;
    }

    public Trail(int color, Function<Float, Float> widthFunction) {
        this(new class_243[]{class_243.field_1353}, color, widthFunction);
    }

    public void setParentRotation(boolean parentRotation) {
        this.parentRotation = parentRotation;
    }

    public void setTilingMode(TilingMode tilingMode) {
        this.tilingMode = tilingMode;
    }

    public void setTexture(class_2960 texture) {
        this.texture = texture;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public void setMinDistance(float minDistance) {
        this.minDistance = minDistance;
    }

    public void setCenterPoint(class_243 centerPoint) {
        this.centerPoint = centerPoint;
    }

    public void setStack(class_1799 stack) {
        this.stack = stack;
        this.setConfig(CustomLootBeamsConfig.fromItemStack(this.stack));
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public void setPoints(class_243[] points) {
        if (points.length > this.length) {
            class_243[] newPoints = new class_243[this.length];
            System.arraycopy(points, points.length - this.length, newPoints, 0, this.length);
            points = newPoints;
        }
        this.points = points;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setColor(float r, float g, float b, float a) {
        this.color = (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f) | (int)(a * 255.0f) << 24;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setBillboard(boolean billboard) {
        this.billboard = billboard;
    }

    public void setWidthFunction(Function<Float, Float> widthFunction) {
        this.widthFunction = widthFunction;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public int getLength() {
        return this.length;
    }

    public void pushPoint(class_243 point) {
        if (this.points.length == 0) {
            this.points = new class_243[]{point};
            return;
        }
        if (this.points[this.points.length - 1].method_1022(point) < (double)this.minDistance) {
            return;
        }
        if (this.points[this.points.length - 1].equals((Object)point)) {
            return;
        }
        if (this.points[0] == class_243.field_1353) {
            this.points[0] = point;
            return;
        }
        class_243[] newPoints = new class_243[this.points.length + 1];
        System.arraycopy(this.points, 0, newPoints, 0, this.points.length);
        newPoints[this.points.length] = point;
        if (newPoints.length > this.length) {
            class_243[] newPoints2 = new class_243[this.length];
            System.arraycopy(newPoints, 1, newPoints2, 0, this.length);
            newPoints = newPoints2;
        }
        this.points = newPoints;
    }

    public void pushRotatedPoint(class_243 point, class_243 rotation) {
        if (this.points.length == 0) {
            this.points = new class_243[]{point};
            this.rotations = new class_243[]{rotation};
            return;
        }
        if (this.points[0] == class_243.field_1353) {
            this.points[0] = point;
            this.rotations = new class_243[]{rotation};
            return;
        }
        if (this.points[this.points.length - 1].method_1022(point) < (double)this.minDistance) {
            return;
        }
        if (this.points.length > 0 && this.points[this.points.length - 1].equals((Object)point)) {
            return;
        }
        if (this.rotations == null) {
            this.rotations = new class_243[]{rotation};
        }
        class_243[] newPoints = new class_243[this.points.length + 1];
        class_243[] newRotations = new class_243[this.points.length + 1];
        System.arraycopy(this.points, 0, newPoints, 0, this.points.length);
        System.arraycopy(this.rotations, 0, newRotations, 0, this.rotations.length);
        newPoints[this.points.length] = point;
        newRotations[this.rotations.length] = rotation;
        if (newPoints.length > this.length) {
            class_243[] newPoints2 = new class_243[this.length];
            class_243[] newRotations2 = new class_243[this.length];
            System.arraycopy(newPoints, 1, newPoints2, 0, this.length);
            System.arraycopy(newRotations, 1, newRotations2, 0, this.length);
            newPoints = newPoints2;
            newRotations = newRotations2;
        }
        this.points = newPoints;
        this.rotations = newRotations;
    }

    public void render(class_4587 stack, class_4588 consumer) {
        stack.method_22903();
        RenderSystem.disableCull();
        double maxY = Arrays.stream(this.points).mapToDouble(p -> p.field_1351).max().orElse(1.0);
        double minY = Arrays.stream(this.points).mapToDouble(p -> p.field_1351).min().orElse(0.0);
        double pathHeight = maxY - minY;
        if (pathHeight <= 0.0) {
            pathHeight = 1.0E-4;
        }
        double scaleHeight = this.config.trailScaleHeightEqualsBeamHeight ? (double)this.config.beamHeight : (double)this.config.trailScaleHeight;
        double scaleY = scaleHeight / pathHeight;
        scaleY = Math.min(scaleY, scaleHeight);
        double baseY = this.centerPoint.field_1351;
        Vector3f[][] corners = new Vector3f[this.points.length][2];
        for (int i = 0; i < this.points.length; ++i) {
            if (i % this.frequency != 0) continue;
            double pointY = baseY + (this.points[i].field_1351 - baseY) * (this.config.trailUseScale ? scaleY : 1.0);
            class_243 scaledPoint = new class_243(this.points[i].field_1352, pointY, this.points[i].field_1350);
            float width = this.widthFunction.apply(Float.valueOf((float)i / (float)(this.points.length - 1))).floatValue();
            Vector3f topOffset = new Vector3f(0.0f, width / 2.0f, 0.0f);
            Vector3f bottomOffset = new Vector3f(0.0f, -(width / 2.0f), 0.0f);
            if (this.billboard) {
                class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
                class_243 directionToCamera = cameraPos.method_1020(scaledPoint).method_1029();
                class_243 dirToNext = this.points[Math.min(i + this.frequency, this.points.length - 1)].method_1020(this.points[i]).method_1029();
                Vector3f dirToNextPoint = new Vector3f((float)dirToNext.field_1352, (float)dirToNext.field_1351, (float)dirToNext.field_1350);
                Vector3f axis = new Vector3f((float)directionToCamera.field_1352, (float)directionToCamera.field_1351, (float)directionToCamera.field_1350);
                axis.mul(-1.0f);
                axis.cross((Vector3fc)dirToNextPoint);
                axis.normalize();
                topOffset = new Vector3f((Vector3fc)axis);
                topOffset.mul(width / 2.0f);
                bottomOffset = new Vector3f((Vector3fc)axis);
                bottomOffset.mul(-width / 2.0f);
            }
            topOffset.add((float)scaledPoint.field_1352, (float)scaledPoint.field_1351, (float)scaledPoint.field_1350);
            bottomOffset.add((float)scaledPoint.field_1352, (float)scaledPoint.field_1351, (float)scaledPoint.field_1350);
            corners[i / this.frequency][0] = topOffset;
            corners[i / this.frequency][1] = bottomOffset;
        }
        this.renderPoints(stack, consumer, corners, this.color);
        RenderSystem.enableCull();
    }

    private void renderPoints(class_4587 stack, class_4588 consumer, Vector3f[][] corners, int color) {
        stack.method_22903();
        float scaleHeight = this.config.trailScaleHeightEqualsBeamHeight ? this.config.beamHeight : this.config.trailScaleHeight;
        float yOffset = this.config.beamYOffset;
        double baseY = this.centerPoint.method_10214();
        double maxScaleHeight = baseY + (double)yOffset + (double)scaleHeight;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        for (int i = 0; i < corners.length - 1; ++i) {
            Vector3f top = corners[i][0];
            Vector3f bottom = corners[i][1];
            Vector3f nextTop = corners[i + 1][0];
            Vector3f nextBottom = corners[i + 1][1];
            if (nextTop == null || nextBottom == null || top == null || bottom == null) continue;
            float u = 0.0f;
            float u1 = 1.0f;
            if (this.tilingMode == TilingMode.STRETCH) {
                u = (float)i / (float)(corners.length - 1);
                u1 = (float)(i + 1) / (float)(corners.length - 1);
            }
            float alpha = a;
            float relativeHeightBottom = (float)((double)bottom.y() - baseY) / (float)(maxScaleHeight - baseY);
            float relativeHeightTop = (float)((double)top.y() - baseY) / (float)(maxScaleHeight - baseY);
            if (relativeHeightTop > 0.75f || relativeHeightBottom > 0.75f) {
                float fadeFactorTop = relativeHeightTop > 0.75f ? (relativeHeightTop - 0.75f) / 0.25f : 0.0f;
                float fadeFactorBottom = relativeHeightBottom > 0.75f ? (relativeHeightBottom - 0.75f) / 0.25f : 0.0f;
                float fadeFactor = Math.max(fadeFactorTop, fadeFactorBottom);
                alpha *= 1.0f - fadeFactor;
                alpha = Math.min(Math.max(alpha, 0.0f), a);
            }
            consumer.method_22918(stack.method_23760().method_23761(), bottom.x(), bottom.y() + yOffset, bottom.z()).method_22915(r, g, b, alpha).method_22913(u, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            consumer.method_22918(stack.method_23760().method_23761(), top.x(), top.y() + yOffset, top.z()).method_22915(r, g, b, alpha).method_22913(u, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            consumer.method_22918(stack.method_23760().method_23761(), nextTop.x(), nextTop.y() + yOffset, nextTop.z()).method_22915(r, g, b, alpha).method_22913(u1, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            consumer.method_22918(stack.method_23760().method_23761(), nextBottom.x(), nextBottom.y() + yOffset, nextBottom.z()).method_22915(r, g, b, alpha).method_22913(u1, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        }
        stack.method_22909();
    }

    public static enum TilingMode {
        NONE,
        STRETCH,
        REPEAT;

    }
}

