/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.utils;

import com.lootbeams.config.Configuration;
import com.lootbeams.helpers.ColorHelper;
import com.lootbeams.helpers.RarityHelper;
import com.lootbeams.managers.ParticleManager;
import com.lootbeams.vfx.VFXParticleType;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.class_1542;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5251;

public class ParticleEmitter {
    private static final Random RANDOM = new Random();
    private static final float TICK_PER_SECOND = 20.0f;
    private static final WeakHashMap<class_1542, Float> nextParticleSpawnTicks = new WeakHashMap();

    public static void createParticlesForItem(class_1542 itemEntity, Configuration itemConfig, int entityTime, class_5251 color, float alpha, float pticks) {
        if (!itemConfig.particles) {
            return;
        }
        if (itemConfig.particleRareOnly && !RarityHelper.rarityCheck(itemEntity.method_6983(), false)) {
            return;
        }
        if (class_310.method_1551().method_1493()) {
            return;
        }
        if (!nextParticleSpawnTicks.containsKey(itemEntity)) {
            nextParticleSpawnTicks.put(itemEntity, Float.valueOf(20.0f / itemConfig.particleCount));
        }
        ColorHelper.Color particleColor = ColorHelper.Color.of(color);
        float particleCount = itemConfig.particleCount;
        float currentTick = (float)entityTime % 20.0f;
        float currentTickValue = currentTick + pticks;
        float ticksPerOneParticle = 20.0f / particleCount;
        if (currentTick == 0.0f && nextParticleSpawnTicks.get(itemEntity).floatValue() >= 20.0f) {
            nextParticleSpawnTicks.put(itemEntity, Float.valueOf(ticksPerOneParticle));
        }
        if (currentTickValue >= nextParticleSpawnTicks.get(itemEntity).floatValue()) {
            nextParticleSpawnTicks.put(itemEntity, Float.valueOf(((float)Math.floor(currentTickValue / ticksPerOneParticle) + 1.0f) * ticksPerOneParticle));
            float particleSize = itemConfig.particleRandomSize ? RANDOM.nextFloat(0.25f * itemConfig.particleSize, 1.1f * itemConfig.particleSize) : itemConfig.particleSize;
            float particleSpeed = itemConfig.particleSpeed;
            float particleRadius = itemConfig.particleRadius;
            float randomnessIntensity = itemConfig.randomnessIntensity;
            class_243 randomDir = new class_243(RANDOM.nextDouble(-particleSpeed / 2.0f, particleSpeed / 2.0f), itemConfig.particleRandomY ? RANDOM.nextDouble(particleSpeed / 2.0f, particleSpeed) : (double)particleSpeed, RANDOM.nextDouble(-particleSpeed / 2.0f, particleSpeed / 2.0f)).method_18805((double)randomnessIntensity, (double)randomnessIntensity, (double)randomnessIntensity);
            class_243 particleDir = new class_243((double)itemConfig.particleDirectionX, (double)itemConfig.particleDirectionY, (double)itemConfig.particleDirectionZ).method_18806(randomDir);
            ParticleManager.ParticleTexture texture = itemConfig.particleTexture;
            double particleY = itemConfig.particleRandomY ? RANDOM.nextDouble(itemEntity.method_23318() + (double)itemConfig.particleYOffset - (double)(particleRadius / 3.0f), itemEntity.method_23318() + (double)itemConfig.particleYOffset + (double)(particleRadius / 3.0f)) : itemEntity.method_23318() + (double)itemConfig.particleYOffset + (double)(particleSize / 10.0f);
            ParticleEmitter.addParticle(texture, particleColor.fR, particleColor.fG, particleColor.fB, alpha, itemConfig.particleLifetime, particleSize, new class_243(RANDOM.nextDouble(itemEntity.method_23317() - (double)particleRadius, itemEntity.method_23317() + (double)particleRadius), particleY, RANDOM.nextDouble(itemEntity.method_23321() - (double)particleRadius, itemEntity.method_23321() + (double)particleRadius)), particleDir, itemEntity);
        }
    }

    private static void addParticle(ParticleManager.ParticleTexture texture, float red, float green, float blue, float alpha, int lifetime, float size, class_243 pos, class_243 motion, class_1542 itemEntity) {
        class_310 mc = class_310.method_1551();
        VFXParticleType glowParticle = ParticleManager.GLOW_PARTICLE.setTexture(texture).setColor(red, green, blue, alpha *= 1.5f).setLifetime(lifetime).setSize(size).setSourcePos(itemEntity.method_19538()).setGravity(0.0f).setCollision(false).setFullbright(true).setItemStack(itemEntity.method_6983());
        if (mc.field_1687 != null) {
            mc.field_1687.method_8406((class_2394)glowParticle, pos.field_1352, pos.field_1351, pos.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
        }
    }
}

