/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.shaders;

import com.lootbeams.LootBeams;
import com.lootbeams.render.CustomVertexFormats;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_5944;

public class LootBeamShaders {
    private static final Map<Shader, class_5944> SHADERS_MAP = new HashMap<Shader, class_5944>();
    private static final Map<DroplightShader, class_5944> DROPLIGHT_SHADERS_MAP = new HashMap<DroplightShader, class_5944>();
    private static final Map<String, class_5944> CUSTOM_SHADERS_MAP = new HashMap<String, class_5944>();
    private static final String CUSTOM_SHADERS_DIRECTORY = "shaders/core/custom";
    private static final String CUSTOM_SHADERS_EXTENSION = ".json";

    public static void registerShader(CoreShaderRegistrationCallback.RegistrationContext registry, Shader shader, String name, class_293 format) {
        try {
            registry.register(LootBeams.id(name), format, shaderProgram -> SHADERS_MAP.put(shader, (class_5944)shaderProgram));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerDroplightShader(CoreShaderRegistrationCallback.RegistrationContext registry, DroplightShader shader, String name, class_293 format) {
        try {
            registry.register(LootBeams.id(name), format, shaderProgram -> DROPLIGHT_SHADERS_MAP.put(shader, (class_5944)shaderProgram));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerCustomShader(CoreShaderRegistrationCallback.RegistrationContext registry, CustomShader shader, String name, class_293 format) {
        try {
            registry.register(LootBeams.id(name), format, shaderProgram -> CUSTOM_SHADERS_MAP.put(shader.name(), (class_5944)shaderProgram));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class_5944 getShader(Shader shader) {
        return SHADERS_MAP.get((Object)shader);
    }

    public static class_5944 getShader(DroplightShader shader) {
        return DROPLIGHT_SHADERS_MAP.get((Object)shader);
    }

    public static class_5944 getShader(CustomShader shader) {
        return CUSTOM_SHADERS_MAP.get(shader.name());
    }

    public static float getAverageColor(Shader shader) {
        return switch (shader.ordinal()) {
            case 0 -> 1.0f;
            case 1 -> 0.5f;
            case 2 -> 0.5f;
            default -> 0.5f;
        };
    }

    public static void registerCoreShaders(CoreShaderRegistrationCallback.RegistrationContext shaderRegistry) {
        for (Shader shader : Shader.values()) {
            String registryShaderName = "lootbeams_" + shader.name().toLowerCase();
            LootBeamShaders.registerShader(shaderRegistry, shader, registryShaderName, class_290.field_1584);
        }
    }

    private static void registerDroplightCoreShader(CoreShaderRegistrationCallback.RegistrationContext shaderRegistry, DroplightShader shader, class_293 vertexFormat) {
        String registryShaderName = "lootbeams_" + shader.name().toLowerCase();
        LootBeamShaders.registerDroplightShader(shaderRegistry, shader, registryShaderName, vertexFormat);
    }

    public static void registerDroplightCoreShaders(CoreShaderRegistrationCallback.RegistrationContext shaderRegistry) {
        LootBeamShaders.registerDroplightCoreShader(shaderRegistry, DroplightShader.DROPLIGHT, CustomVertexFormats.POSITION_TEX_COLOR0_COLOR1_CUSTOM);
        LootBeamShaders.registerDroplightCoreShader(shaderRegistry, DroplightShader.DROPLIGHT_ANIMATED, CustomVertexFormats.POSITION_TEX_COLOR0_COLOR1_CUSTOM);
        LootBeamShaders.registerDroplightCoreShader(shaderRegistry, DroplightShader.DROPLIGHT_GLOW, CustomVertexFormats.POSITION_TEX_COLOR0_COLOR1_CENTER);
    }

    public static void registerCustomCoreShaders(CoreShaderRegistrationCallback.RegistrationContext shaderRegistry) {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        if (resourceManager != null) {
            LootBeamShaders.onCustomShadersReload(shaderRegistry, resourceManager);
        }
    }

    public static String getFormattedName(String path) {
        String result = path;
        if (result.contains(".")) {
            result = result.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46));
        }
        return result.toUpperCase();
    }

    public static void onCustomShadersReload(CoreShaderRegistrationCallback.RegistrationContext shaderRegistry, class_3300 resourceManager) {
        CustomShader.clearDynamicValues();
        CUSTOM_SHADERS_MAP.clear();
        Map RESOURCE_SHADERS_MAP = resourceManager.method_14488(CUSTOM_SHADERS_DIRECTORY, identifier -> identifier.method_12832().endsWith(CUSTOM_SHADERS_EXTENSION));
        for (class_2960 shaderId : RESOURCE_SHADERS_MAP.keySet()) {
            CustomShader newShader = CustomShader.addValue(LootBeamShaders.getFormattedName(shaderId.method_12832()));
            String registryShaderName = newShader.name().toLowerCase();
            if (shaderRegistry == null) continue;
            LootBeamShaders.registerCustomShader(shaderRegistry, newShader, "custom/" + registryShaderName, CustomVertexFormats.POSITION_TEX_COLOR0_COLOR1_CENTER);
        }
    }

    public static enum Shader {
        ADD,
        GLOW_OVERLAY,
        PARTICLE_OVERLAY;

    }

    public static enum DroplightShader {
        DROPLIGHT,
        DROPLIGHT_ANIMATED,
        DROPLIGHT_GLOW;

    }

    public static class CustomShader {
        public static final CustomShader NONE = new CustomShader("NONE");
        private final String name;
        private static final List<CustomShader> dynamicValues = new ArrayList<CustomShader>();
        private static final List<CustomShader> staticValues = new ArrayList<CustomShader>();

        private CustomShader(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CustomShader addValue(String name) {
            List<CustomShader> list = dynamicValues;
            synchronized (list) {
                for (CustomShader value : CustomShader.values()) {
                    if (!value.name.equals(name)) continue;
                    return value;
                }
                CustomShader newValue = new CustomShader(name);
                dynamicValues.add(newValue);
                return newValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void clearDynamicValues() {
            List<CustomShader> list = dynamicValues;
            synchronized (list) {
                dynamicValues.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static List<CustomShader> values() {
            List<CustomShader> list = dynamicValues;
            synchronized (list) {
                ArrayList<CustomShader> allValues = new ArrayList<CustomShader>(staticValues);
                allValues.addAll(dynamicValues);
                return allValues;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CustomShader valueOf(String name) {
            for (CustomShader shader : staticValues) {
                if (!shader.name.equals(name)) continue;
                return shader;
            }
            List<CustomShader> list = dynamicValues;
            synchronized (list) {
                for (CustomShader shader : dynamicValues) {
                    if (!shader.name.equals(name)) continue;
                    return shader;
                }
            }
            return CustomShader.addValue(name);
        }

        public String toString() {
            return this.name;
        }

        static {
            staticValues.add(NONE);
        }
    }
}

