/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.renderers;

import com.lootbeams.compat.iris.IrisCompat;
import com.lootbeams.config.Configuration;
import com.lootbeams.extensions.LootbeamsBufferBuilder;
import com.lootbeams.helpers.ColorHelper;
import com.lootbeams.helpers.NumberHelper;
import com.lootbeams.managers.GlowEffectManager;
import com.lootbeams.render.LootBeamRenderLayers;
import com.lootbeams.renderers.DroplightRenderer;
import com.lootbeams.shaders.LootBeamShaders;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1542;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5251;
import net.minecraft.class_7833;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class GroundEffectRenderer {
    public static void renderGroundEffect(class_4597.class_4598 buffer, class_4587 matrixStack, class_1542 itemEntity, Configuration itemConfig, class_5251 color, float sizeMultiplier, float fadeAlpha, float currentGroundTime, long worldtime, float pticks) {
        ColorHelper.Color effectColor = ColorHelper.Color.of(color);
        if (itemConfig.glowEffect) {
            matrixStack.method_22903();
            matrixStack.method_46416(0.0f, 0.001f, 0.0f);
            if (itemConfig.rotateGlow) {
                float rotationSpeed = itemConfig.glowRotationSpeed;
                float rotation = currentGroundTime * rotationSpeed % 360.0f;
                float rotationDirection = itemConfig.glowRotateClockwise ? -1.0f : 1.0f;
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotation * rotationDirection));
            }
            class_1058 glowEffectSprite = itemConfig.glowEffectTexture.getSprite();
            if (IrisCompat.isShaderPackInUse() && itemConfig.glowEffectTexture == GlowEffectManager.GLOW_TEXTURE) {
                glowEffectSprite = GlowEffectManager.GLOW_SHADER_TEXTURE.getSprite();
            }
            if (!IrisCompat.isShaderPackInUse() && itemConfig.glowEffectTexture == GlowEffectManager.GLOW_SHADER_TEXTURE) {
                glowEffectSprite = GlowEffectManager.GLOW_TEXTURE.getSprite();
            }
            class_1921 glowLayer = LootBeamRenderLayers.groundGlowEffect(glowEffectSprite.method_45852(), itemConfig.glowEffectTexture.isColored(), itemConfig.useGlowGradient, itemConfig.glowCustomShader);
            float radius = itemConfig.glowEffectRadius;
            float glowEffectAlpha = fadeAlpha * itemConfig.glowEffectAlpha;
            if (itemConfig.pulseGlow) {
                float pulseSpeed = itemConfig.pulseGlowSpeed / 10.0f;
                float pulseMinAlpha = itemConfig.pulseGlowMinAlpha;
                float pulseMaxAlpha = itemConfig.pulseGlowMaxAlpha;
                float pulseMinRadius = itemConfig.pulseGlowMinRadius;
                float pulseMaxRadius = itemConfig.pulseGlowMaxRadius;
                float cosineFactor = (float)Math.cos(currentGroundTime * pulseSpeed);
                float normalizedCosine = cosineFactor * 0.5f + 0.5f;
                float pulseAlpha = (float)NumberHelper.clampedMapRange(Float.valueOf(normalizedCosine), 0, 1, Float.valueOf(pulseMinAlpha), Float.valueOf(pulseMaxAlpha));
                float pulseRadius = (float)NumberHelper.clampedMapRange(Float.valueOf(normalizedCosine), 0, 1, Float.valueOf(pulseMinRadius), Float.valueOf(pulseMaxRadius));
                glowEffectAlpha = pulseAlpha * fadeAlpha;
                radius = pulseRadius;
            }
            if ((radius *= sizeMultiplier) < itemConfig.pulseGlowMinRadius) {
                radius = itemConfig.pulseGlowMinRadius;
            }
            float glowR = effectColor.fR;
            float glowG = effectColor.fG;
            float glowB = effectColor.fB;
            if (itemConfig.glowEffectTexture.isColored()) {
                float averageColor;
                glowR = averageColor = LootBeamShaders.getAverageColor(LootBeamShaders.Shader.GLOW_OVERLAY);
                glowG = averageColor;
                glowB = averageColor;
            }
            if (itemConfig.smoothGlowEffectRadius) {
                radius = NumberHelper.smoothValue(radius, currentGroundTime, itemConfig.smoothDuration);
            }
            if (itemConfig.smoothGlowEffectAlpha) {
                glowEffectAlpha = NumberHelper.smoothValue(glowEffectAlpha, currentGroundTime, itemConfig.smoothDuration);
            }
            boolean useGlowGradient = !itemConfig.glowEffectTexture.isColored() && itemConfig.useGlowGradient || itemConfig.glowCustomShader != LootBeamShaders.CustomShader.NONE;
            GroundEffectRenderer.renderGlow(matrixStack, buffer.getBuffer(glowLayer), glowR, glowG, glowB, glowEffectAlpha, radius, glowEffectSprite, useGlowGradient, itemConfig.glowGradientModifiers, itemConfig.glowGradientStart / 100.0f, itemConfig.glowGradientEnd / 100.0f);
            buffer.method_22993();
            matrixStack.method_22909();
        }
    }

    private static class_4588 addGlowVertex(class_4588 builder, class_4587.class_4665 matrixEntry, float x, float y, float z, float red, float green, float blue, float alpha, float u, float v, boolean shadersLoaded) {
        Matrix4f poseMatrix = matrixEntry.method_23761();
        Matrix3f normal = matrixEntry.method_23762();
        if (shadersLoaded) {
            return builder.method_22918(poseMatrix, x, y, z).method_22915(red, green, blue, alpha).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f);
        }
        return builder.method_22918(poseMatrix, x, y, z).method_22913(u, v).method_22915(red, green, blue, alpha);
    }

    private static class_4588 modifyGlowVertex(class_4588 builder, ColorHelper.Color color1, float centerU, float centerV, float uvWidth, float uvHeight, float gradientStart, float gradientEnd, boolean useGlowGradient) {
        if (useGlowGradient) {
            builder.method_22915(color1.fR, color1.fG, color1.fB, color1.fA);
            ((LootbeamsBufferBuilder)builder).uvCenter(centerU, centerV);
            ((LootbeamsBufferBuilder)builder).uvSize(uvWidth, uvHeight);
            ((LootbeamsBufferBuilder)builder).shortCustomData(gradientStart, gradientEnd);
        }
        return builder;
    }

    private static void renderGlow(class_4587 stack, class_4588 builder, float red, float green, float blue, float alpha, float radius, class_1058 glowSprite, boolean useGlowGradient, List<String> gradientModifiers, float gradientStart, float gradientEnd) {
        class_4587.class_4665 matrixentry = stack.method_23760();
        boolean shadersLoaded = IrisCompat.isShaderPackInUse();
        float minX = glowSprite.method_4594();
        float maxX = glowSprite.method_4577();
        float minY = glowSprite.method_4593();
        float maxY = glowSprite.method_4575();
        float centerU = (minX + maxX) / 2.0f;
        float centerV = (minY + maxY) / 2.0f;
        float uvWidth = maxX - minX;
        float uvHeight = maxY - minY;
        ColorHelper.Color secondColor = ColorHelper.Color.of(DroplightRenderer.getSecondColor(red, green, blue, alpha, gradientModifiers));
        GroundEffectRenderer.modifyGlowVertex(GroundEffectRenderer.addGlowVertex(builder, matrixentry, -radius, 0.0f, -radius, red, green, blue, alpha, minX, minY, shadersLoaded), secondColor, centerU, centerV, uvWidth, uvHeight, gradientStart, gradientEnd, useGlowGradient && !shadersLoaded).method_1344();
        GroundEffectRenderer.modifyGlowVertex(GroundEffectRenderer.addGlowVertex(builder, matrixentry, -radius, 0.0f, radius, red, green, blue, alpha, minX, maxY, shadersLoaded), secondColor, centerU, centerV, uvWidth, uvHeight, gradientStart, gradientEnd, useGlowGradient && !shadersLoaded).method_1344();
        GroundEffectRenderer.modifyGlowVertex(GroundEffectRenderer.addGlowVertex(builder, matrixentry, radius, 0.0f, radius, red, green, blue, alpha, maxX, maxY, shadersLoaded), secondColor, centerU, centerV, uvWidth, uvHeight, gradientStart, gradientEnd, useGlowGradient && !shadersLoaded).method_1344();
        GroundEffectRenderer.modifyGlowVertex(GroundEffectRenderer.addGlowVertex(builder, matrixentry, radius, 0.0f, -radius, red, green, blue, alpha, maxX, minY, shadersLoaded), secondColor, centerU, centerV, uvWidth, uvHeight, gradientStart, gradientEnd, useGlowGradient && !shadersLoaded).method_1344();
    }
}

