/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.render;

import com.lootbeams.config.Configuration;
import com.lootbeams.features.BeamOpacityOnApproach;
import com.lootbeams.features.BeamSizeOnApproach;
import com.lootbeams.features.CustomLootBeamsConfig;
import com.lootbeams.helpers.NumberHelper;
import com.lootbeams.helpers.TextColorHelper;
import com.lootbeams.renderers.DroplightRenderer;
import com.lootbeams.renderers.GroundEffectRenderer;
import com.lootbeams.renderers.IBeamRenderer;
import com.lootbeams.renderers.LootBeamRenderer;
import com.lootbeams.renderers.NameTagRenderer;
import com.lootbeams.utils.ParticleEmitter;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5251;
import net.minecraft.class_746;

public class BeamRender {
    private static final Map<class_1542, Integer> ITEM_GROUND_START_TIMES = new HashMap<class_1542, Integer>();

    private static float fadeDistanceAlpha(float distance, Configuration itemConfig) {
        float defaultMultiplier = 1.0f;
        if (itemConfig.beamOpacityOnApproach == BeamOpacityOnApproach.DISABLED) {
            return defaultMultiplier;
        }
        if (itemConfig.beamOpacityOnApproach == BeamOpacityOnApproach.FADE_IN) {
            return (float)NumberHelper.clampedMapRange(Float.valueOf(distance), Float.valueOf(itemConfig.changeOffset), Float.valueOf(itemConfig.changeDistance), Float.valueOf(1.0f), Float.valueOf(0.0f));
        }
        if (itemConfig.beamOpacityOnApproach == BeamOpacityOnApproach.FADE_OUT) {
            return (float)NumberHelper.clampedMapRange(Float.valueOf(distance), Float.valueOf(itemConfig.changeOffset), Float.valueOf(itemConfig.changeDistance), Float.valueOf(0.0f), Float.valueOf(1.0f));
        }
        return defaultMultiplier;
    }

    private static float getBeamSizeMultiplier(float distance, Configuration itemConfig) {
        float defaultMultiplier = 1.0f;
        if (itemConfig.beamSizeOnApproach == BeamSizeOnApproach.DISABLED) {
            return defaultMultiplier;
        }
        if (itemConfig.beamSizeOnApproach == BeamSizeOnApproach.SHRINK) {
            return (float)NumberHelper.clampedMapRange(Float.valueOf(distance), Float.valueOf(itemConfig.changeOffset), Float.valueOf(itemConfig.changeDistance), Float.valueOf(0.0f), Float.valueOf(1.0f));
        }
        if (itemConfig.beamSizeOnApproach == BeamSizeOnApproach.GROW) {
            return (float)NumberHelper.clampedMapRange(Float.valueOf(distance), Float.valueOf(itemConfig.changeOffset), Float.valueOf(itemConfig.changeDistance), Float.valueOf(1.0f), Float.valueOf(0.0f));
        }
        return defaultMultiplier;
    }

    public static boolean canRenderBeam(Configuration itemConfig, float fadeAlpha) {
        return !(itemConfig.beamAlpha * fadeAlpha < 0.01f);
    }

    public static void render(class_4587 stack, class_4597.class_4598 buffer, class_1542 item, long worldtime, float pticks) {
        if (!ITEM_GROUND_START_TIMES.containsKey(item)) {
            ITEM_GROUND_START_TIMES.put(item, item.method_6985());
        }
        float itemGroundStartTime = ITEM_GROUND_START_TIMES.getOrDefault(item, 0).intValue();
        float currentGroundTime = (float)item.method_6985() - itemGroundStartTime + pticks;
        Configuration itemConfig = CustomLootBeamsConfig.fromItemStack(item.method_6983());
        class_746 player = class_310.method_1551().field_1724;
        float distance = player != null ? player.method_5739((class_1297)item) : 0.0f;
        float sizeMultiplier = BeamRender.getBeamSizeMultiplier(distance, itemConfig);
        float fadeAlpha = BeamRender.fadeDistanceAlpha(distance, itemConfig);
        if (!BeamRender.canRenderBeam(itemConfig, fadeAlpha)) {
            return;
        }
        RenderSystem.enableDepthTest();
        class_5251 color = TextColorHelper.getItemColor(item.method_6983());
        if (item.method_24828()) {
            stack.method_22903();
            GroundEffectRenderer.renderGroundEffect(buffer, stack, item, itemConfig, color, sizeMultiplier, fadeAlpha, currentGroundTime, worldtime, pticks);
            IBeamRenderer BeamRenderer = itemConfig.renderDroplightBeam ? DroplightRenderer::renderBeam : LootBeamRenderer::renderBeam;
            BeamRenderer.renderBeam(buffer, stack, item, itemConfig, color, sizeMultiplier, fadeAlpha, currentGroundTime, worldtime, pticks);
            stack.method_22909();
            NameTagRenderer.renderNameTags(buffer, stack, item, itemConfig, color, fadeAlpha, currentGroundTime, worldtime, pticks);
            ParticleEmitter.createParticlesForItem(item, itemConfig, item.method_6985(), color, fadeAlpha, pticks);
        }
        RenderSystem.disableDepthTest();
        ITEM_GROUND_START_TIMES.keySet().removeIf(itemEntity -> !itemEntity.method_24828());
    }
}

