/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.managers;

import com.lootbeams.LootBeams;
import com.lootbeams.events.PresetEvents;
import com.lootbeams.helpers.FileHelper;
import com.lootbeams.helpers.StringHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_368;
import net.minecraft.class_370;

public class PresetManager {
    private static final String PRESET_ASSETS_DIRECTORY = "data/presets";
    private static final String PRESET_CONFIG_DIRECTORY = "lootbeams/presets";
    private static final String PRESET_EXTENSION = ".json";
    private static Map<class_2960, class_3298> RESOURCE_PRESETS_MAP = new HashMap<class_2960, class_3298>();
    private static List<Preset> presetList = null;

    public static void init() {
        PresetManager.getPresetFiles();
    }

    public static String getPresetFormattedName(String path) {
        String result = path;
        if (result.contains(".")) {
            result = result.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46));
        }
        if (result.contains("_")) {
            result = result.replace('_', ' ');
        }
        return StringHelper.capitalize(result);
    }

    public static String getPresetFileName(String presetName) {
        return presetName.replace(' ', '_');
    }

    public static Preset getFirstPreset() {
        if (presetList == null || presetList.isEmpty()) {
            return null;
        }
        return presetList.get(0);
    }

    public static String getFirstPresetName() {
        Preset preset = PresetManager.getFirstPreset();
        if (preset == null) {
            return "";
        }
        return preset.getDisplayName();
    }

    public static Set<String> getPresetNames() {
        HashSet<String> presetNames = new HashSet<String>();
        if (presetList == null || presetList.isEmpty()) {
            return presetNames;
        }
        for (Preset preset : presetList) {
            presetNames.add(preset.getDisplayName());
        }
        return presetNames;
    }

    public static Map<String, class_2960> getDefaultPresets() {
        HashMap<String, class_2960> defaultPresetMap = new HashMap<String, class_2960>();
        if (presetList == null || presetList.isEmpty()) {
            return defaultPresetMap;
        }
        for (Preset preset : presetList) {
            if (preset.getType() != PresetType.IDENTIFIER) continue;
            defaultPresetMap.put(preset.getDisplayName(), preset.getIdentifier());
        }
        return defaultPresetMap;
    }

    public static Map<String, File> getCustomPresets() {
        HashMap<String, File> customPresetMap = new HashMap<String, File>();
        if (presetList == null || presetList.isEmpty()) {
            return customPresetMap;
        }
        for (Preset preset : presetList) {
            if (preset.getType() != PresetType.FILE) continue;
            customPresetMap.put(preset.getDisplayName(), preset.getPresetFile());
        }
        return customPresetMap;
    }

    public static void onResourcesReload(class_3300 resourceManager) {
        RESOURCE_PRESETS_MAP = resourceManager.method_14488(PRESET_ASSETS_DIRECTORY, identifier -> identifier.method_12832().endsWith(PRESET_EXTENSION));
    }

    public static List<Preset> getPresetFiles() {
        ArrayList<Preset> presets = new ArrayList<Preset>();
        for (class_2960 presetId : RESOURCE_PRESETS_MAP.keySet()) {
            presets.add(new Preset(PresetManager.getPresetFormattedName(presetId.method_12832()), presetId));
        }
        try {
            Path presetDirPath = FabricLoader.getInstance().getConfigDir().resolve(PRESET_CONFIG_DIRECTORY);
            if (Files.exists(presetDirPath, new LinkOption[0])) {
                Files.list(presetDirPath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(PRESET_EXTENSION)).forEach(path -> presets.add(new Preset(PresetManager.getPresetFormattedName(path.getFileName().toString()), path.toFile())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        presetList = presets;
        return presets;
    }

    public static void loadPreset(File presetFile) {
        LootBeams.configManager.load(presetFile);
    }

    public static void loadPreset(class_2960 id) {
        class_3298 presetResource = RESOURCE_PRESETS_MAP.get(id);
        if (presetResource != null) {
            try {
                LootBeams.configManager.load(presetResource.method_14482());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void savePreset(String presetName) {
        Path newPresetPath = FabricLoader.getInstance().getConfigDir().resolve("lootbeams/presets/" + presetName + PRESET_EXTENSION);
        File newPresetFile = FileHelper.createPathIfNotExists(newPresetPath.toString());
        LootBeams.configManager.save(newPresetFile);
        class_310 client = class_310.method_1551();
        client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_371)class_370.class_371.field_2219, (class_2561)class_2561.method_30163((String)"LootBeams"), (class_2561)class_2561.method_43469((String)"lootbeams.notification.savePreset.text", (Object[])new Object[]{PresetManager.getPresetFormattedName(presetName)})));
    }

    public static boolean tryApplyPreset(String presetName) {
        if (LootBeams.config.selectedPreset.equals(presetName)) {
            return false;
        }
        Map<String, class_2960> defaultPresets = PresetManager.getDefaultPresets();
        Map<String, File> customPresets = PresetManager.getCustomPresets();
        if (defaultPresets.containsKey(presetName)) {
            class_2960 presetId = defaultPresets.get(presetName);
            PresetManager.loadPreset(presetId);
            LootBeams.config.selectedPreset = presetName;
            return true;
        }
        if (customPresets.containsKey(presetName)) {
            File presetFile = customPresets.get(presetName);
            PresetManager.loadPreset(presetFile);
            LootBeams.config.selectedPreset = presetName;
            return true;
        }
        return false;
    }

    public static void loadAndApplyPreset(String presetName) {
        if (PresetManager.tryApplyPreset(presetName)) {
            class_310 client = class_310.method_1551();
            client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_371)class_370.class_371.field_2219, (class_2561)class_2561.method_30163((String)"LootBeams"), (class_2561)class_2561.method_43469((String)"lootbeams.notification.loadPreset.text", (Object[])new Object[]{presetName})));
            LootBeams.configManager.save();
            ((PresetEvents.ApplyPreset)PresetEvents.APPLY_PRESET.invoker()).onApplyPreset(presetName);
        }
    }

    public static class Preset {
        private final PresetType type;
        private final String displayName;
        private final class_2960 identifier;
        private final File presetFile;

        public Preset(String displayName, class_2960 identifier) {
            this.type = PresetType.IDENTIFIER;
            this.displayName = displayName;
            this.identifier = identifier;
            this.presetFile = null;
        }

        public Preset(String displayName, File presetFile) {
            this.type = PresetType.FILE;
            this.displayName = displayName;
            this.identifier = null;
            this.presetFile = presetFile;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public class_2960 getIdentifier() {
            return this.identifier;
        }

        public File getPresetFile() {
            return this.presetFile;
        }

        public PresetType getType() {
            return this.type;
        }

        public String toString() {
            return this.displayName;
        }
    }

    public static enum PresetType {
        IDENTIFIER,
        FILE;

    }
}

