/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.helpers;

import com.google.common.collect.Lists;
import com.lootbeams.LootBeams;
import com.lootbeams.compat.prism.PrismCompat;
import com.lootbeams.config.Configuration;
import com.lootbeams.features.CustomLootBeamsConfig;
import com.lootbeams.features.CustomRarity;
import com.lootbeams.managers.CrashManager;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5223;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

public class TextColorHelper {
    private static Map<class_1799, class_5251> DC_MAP = new HashMap<class_1799, class_5251>();
    private static String NBT_COLOR_KEY = "lootbeams.color";
    private static String NBT_ANIMATED_COLOR_KEY = "lootbeams.animated_color";

    public static class_5251 getItemColor(class_1799 itemStack) {
        if (CrashManager.CRASH_BLACKLIST.contains(itemStack)) {
            return class_5251.method_27718((class_124)class_124.field_1068);
        }
        Configuration itemConfig = CustomLootBeamsConfig.fromItemStack(itemStack);
        try {
            class_5251 nameColor;
            class_5251 override = TextColorHelper.getColorFromItemOverrides(itemStack.method_7909());
            if (override != null) {
                return override;
            }
            if (itemStack.method_7985()) {
                class_2487 value = itemStack.method_7969();
                if (value.method_10545(NBT_ANIMATED_COLOR_KEY) && PrismCompat.isPrismLoaded()) {
                    if (DC_MAP.containsKey(itemStack)) {
                        return class_5251.method_27717((int)DC_MAP.get(itemStack).method_27716());
                    }
                    class_5251 dColor = PrismCompat.parseColor(value.method_10558(NBT_ANIMATED_COLOR_KEY));
                    DC_MAP.put(itemStack, dColor);
                    return class_5251.method_27717((int)dColor.method_27716());
                }
                if (value.method_10545(NBT_COLOR_KEY)) {
                    return class_5251.method_27719((String)value.method_10558(NBT_COLOR_KEY));
                }
            }
            if (itemConfig.renderNameColor && !(nameColor = TextColorHelper.getRawColor(itemStack.method_7964())).equals((Object)class_5251.method_27718((class_124)class_124.field_1068))) {
                return nameColor;
            }
            if (itemConfig.renderRarityColor) {
                CustomRarity customRarity = CustomRarity.fromItemStack(itemStack);
                if (customRarity != null) {
                    return class_5251.method_27717((int)customRarity.getColor());
                }
                if (itemStack.method_7932().field_8908 != null) {
                    return class_5251.method_27718((class_124)itemStack.method_7932().field_8908);
                }
            }
            return class_5251.method_27718((class_124)class_124.field_1068);
        }
        catch (Exception e) {
            CrashManager.LOGGER.error("Failed to get color for ({}), added to temporary blacklist", (Object)itemStack.method_7954());
            CrashManager.CRASH_BLACKLIST.add(itemStack);
            CrashManager.LOGGER.info("Temporary blacklist is now : ");
            for (class_1799 s : CrashManager.CRASH_BLACKLIST) {
                CrashManager.LOGGER.info((Object)s.method_7954());
            }
            return class_5251.method_27718((class_124)class_124.field_1068);
        }
    }

    public static class_5251 getColorFromItemOverrides(class_1792 i) {
        List<String> overrides = LootBeams.config.colorOverrides;
        if (overrides.isEmpty()) {
            return null;
        }
        for (String unparsed : overrides.stream().filter(s -> !s.isEmpty()).collect(Collectors.toList())) {
            Optional<class_6885.class_6888> tag;
            String[] configValue = unparsed.split("=");
            if (configValue.length != 2) continue;
            String nameIn = configValue[0];
            class_2960 registry = class_2960.method_12829((String)nameIn.replace("#", ""));
            class_5251 colorIn = null;
            try {
                if (PrismCompat.isPrismLoaded()) {
                    if (DC_MAP.containsKey(i.method_7854())) {
                        colorIn = class_5251.method_27717((int)DC_MAP.get(i.method_7854()).method_27716());
                    } else {
                        class_5251 dColor = PrismCompat.parseColor(configValue[1]);
                        DC_MAP.put(i.method_7854(), dColor);
                        colorIn = class_5251.method_27717((int)dColor.method_27716());
                    }
                } else {
                    colorIn = class_5251.method_27719((String)configValue[1]);
                }
            }
            catch (Exception e) {
                CrashManager.LOGGER.error(String.format("Color overrides error! \"%s\" is not a valid hex color for \"%s\"", configValue[1], nameIn));
                return null;
            }
            if (!nameIn.contains(":") && class_7923.field_41178.method_10221((Object)i).method_12836().equals(nameIn)) {
                return colorIn;
            }
            if (registry == null) continue;
            if (nameIn.startsWith("#") && (tag = class_7923.field_41178.method_40272().filter(pair -> ((class_6862)pair.getFirst()).comp_327().equals((Object)registry)).findFirst().map(Pair::getSecond)).isPresent() && tag.get().method_40241((class_6880)class_7923.field_41178.method_40264((class_5321)class_7923.field_41178.method_29113((Object)i).get()).get())) {
                return colorIn;
            }
            Optional registryItem = class_7923.field_41178.method_17966(registry);
            if (!registryItem.isPresent() || ((class_1792)registryItem.get()).method_8389() != i.method_8389()) continue;
            return colorIn;
        }
        return null;
    }

    public static class_5251 getRawColor(class_2561 text) {
        ArrayList list = Lists.newArrayList();
        text.method_27658((acceptor, styleIn) -> {
            class_5223.method_27479((String)styleIn, (class_2583)acceptor, (string, style, consumer) -> {
                list.add(style);
                return true;
            });
            return Optional.empty();
        }, class_2583.field_24360);
        if (!list.isEmpty() && ((class_2583)list.get(0)).method_10973() != null) {
            return ((class_2583)list.get(0)).method_10973();
        }
        return class_5251.method_27718((class_124)class_124.field_1068);
    }

    private static String compensateHex(String hex) {
        StringBuilder compensatedHex = new StringBuilder();
        for (char c : hex.toCharArray()) {
            compensatedHex.append(c).append(c);
        }
        return compensatedHex.toString();
    }

    public static int getColorFromHEX(String hex) {
        int defaultColor = Integer.parseInt("FFFFFF", 16);
        if (hex == null || hex.isEmpty()) {
            return defaultColor;
        }
        if (hex.contains("#")) {
            hex = hex.replace("#", "");
        }
        if (!hex.isEmpty()) {
            switch (hex.length()) {
                case 3: {
                    return Integer.parseInt(TextColorHelper.compensateHex(hex), 16);
                }
                case 4: {
                    return Integer.parseInt(TextColorHelper.compensateHex(hex).substring(0, 6), 16);
                }
                case 6: {
                    return Integer.parseInt(hex, 16);
                }
                case 8: {
                    return Integer.parseInt(hex.substring(0, 6), 16);
                }
            }
        }
        return defaultColor;
    }
}

