/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams.features;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lootbeams.LootBeams;
import com.lootbeams.compat.prism.PrismCompat;
import com.lootbeams.helpers.TextColorHelper;
import com.lootbeams.utils.Selectors;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_5251;

public class CustomRarity {
    private static final String CUSTOM_RARITIES_FILE = "custom_rarities.json";
    private static final String CUSTOM_RARITIES_JSON_KEY = "custom_rarities";
    private static final Map<String, CustomRarity> RARITY_CACHE = new HashMap<String, CustomRarity>();
    private static final String CUSTOM_RARITY_KEY = "custom_rarity";
    private static final String CUSTOM_RARITY_ID_KEY = "id";
    private static final String CUSTOM_RARITY_NAME_KEY = "name";
    private static final String CUSTOM_RARITY_COLOR_KEY = "color";
    private static final String CUSTOM_RARITY_ANIMATED_COLOR_KEY = "animated_color";
    private static final String CUSTOM_RARITY_CONFIG_KEY = "config";
    private static final String CUSTOM_RARITY_SELECTORS_KEY = "selectors";
    public static final String ITEM_CUSTOM_RARITY_ID_KEY = "custom_rarity_id";
    private String name = "";
    private int color = 0xFFFFFF;
    private class_5251 animatedColor = null;
    private JsonObject rarityConfig = null;
    private List<String> selectors = new ArrayList<String>();

    public CustomRarity(String rarityName) {
        this.name = rarityName;
    }

    public CustomRarity setColor(int rarityColor) {
        this.color = rarityColor;
        return this;
    }

    public CustomRarity setAnimatedColor(class_5251 prismColor) {
        this.animatedColor = prismColor;
        return this;
    }

    public CustomRarity setConfig(JsonObject rarityConfig) {
        this.rarityConfig = rarityConfig;
        return this;
    }

    public CustomRarity setSelectors(List<String> selectors) {
        this.selectors = selectors;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        if (this.animatedColor != null) {
            return this.animatedColor.method_27716();
        }
        return this.color;
    }

    public boolean hasRarityConfig() {
        return this.rarityConfig != null;
    }

    public List<String> getSelectors() {
        return this.selectors;
    }

    public JsonObject getRarityConfig() {
        return this.rarityConfig;
    }

    public static CustomRarity fromSelectors(class_1799 itemStack) {
        for (CustomRarity rarity : RARITY_CACHE.values()) {
            if (rarity.getSelectors().isEmpty() || class_310.method_1551().field_1687 == null) continue;
            for (String selector : rarity.getSelectors()) {
                if (!Selectors.validateSelector(selector) || !Selectors.itemMatches(itemStack, selector)) continue;
                return rarity;
            }
        }
        return null;
    }

    public static CustomRarity fromItemStack(class_1799 itemStack) {
        CustomRarity rarity;
        class_2487 customDataNbt;
        if (itemStack.method_7985() && !(customDataNbt = itemStack.method_7969()).method_33133()) {
            String customRarityId = customDataNbt.method_10558(ITEM_CUSTOM_RARITY_ID_KEY);
            class_2487 customRarity = customDataNbt.method_10562(CUSTOM_RARITY_KEY);
            if (!customRarity.method_33133()) {
                String rarityName = customRarity.method_10558(CUSTOM_RARITY_NAME_KEY);
                String hexColor = customRarity.method_10558(CUSTOM_RARITY_COLOR_KEY);
                String animatedHexColor = customRarity.method_10558(CUSTOM_RARITY_ANIMATED_COLOR_KEY);
                if (!rarityName.isEmpty()) {
                    CustomRarity newRarity = new CustomRarity(class_2561.method_43471((String)rarityName).getString());
                    if (!hexColor.isEmpty()) {
                        newRarity.setColor(TextColorHelper.getColorFromHEX(hexColor));
                    }
                    if (!animatedHexColor.isEmpty() && PrismCompat.isPrismLoaded()) {
                        class_5251 prismColor = PrismCompat.parseColor(animatedHexColor);
                        newRarity.setAnimatedColor(prismColor);
                        newRarity.setColor(prismColor.method_27716());
                    }
                    return newRarity;
                }
            } else if (!customRarityId.isEmpty() && RARITY_CACHE.containsKey(customRarityId)) {
                return RARITY_CACHE.get(customRarityId);
            }
        }
        if ((rarity = CustomRarity.fromSelectors(itemStack)) != null) {
            return rarity;
        }
        return null;
    }

    public static class_2561 toText(CustomRarity customRarity) {
        class_2583 newStyle = class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_36139(customRarity.getColor());
        return class_2561.method_43470((String)customRarity.getName()).method_10862(newStyle);
    }

    public static void onResourcesReload(class_3300 resourceManager) {
        RARITY_CACHE.clear();
        class_3298 customRaritiesFile = resourceManager.method_14486(LootBeams.id(CUSTOM_RARITIES_FILE)).orElse(null);
        if (customRaritiesFile != null) {
            try {
                JsonArray customRarities;
                JsonObject customRaritiesJSON = class_3518.method_15255((Reader)customRaritiesFile.method_43039());
                if (customRaritiesJSON.has(CUSTOM_RARITIES_JSON_KEY) && !(customRarities = class_3518.method_15261((JsonObject)customRaritiesJSON, (String)CUSTOM_RARITIES_JSON_KEY)).isEmpty()) {
                    for (JsonElement jsonElement : customRarities) {
                        JsonObject jsonObject;
                        if (!jsonElement.isJsonObject() || !(jsonObject = jsonElement.getAsJsonObject()).has(CUSTOM_RARITY_ID_KEY)) continue;
                        String rarityId = class_3518.method_15265((JsonObject)jsonObject, (String)CUSTOM_RARITY_ID_KEY);
                        String rarityName = class_3518.method_15265((JsonObject)jsonObject, (String)CUSTOM_RARITY_NAME_KEY);
                        String rarityColor = class_3518.method_15265((JsonObject)jsonObject, (String)CUSTOM_RARITY_COLOR_KEY);
                        String rarityAnimatedColor = class_3518.method_15253((JsonObject)jsonObject, (String)CUSTOM_RARITY_ANIMATED_COLOR_KEY, (String)"");
                        JsonArray raritySelectors = class_3518.method_15292((JsonObject)jsonObject, (String)CUSTOM_RARITY_SELECTORS_KEY, (JsonArray)new JsonArray());
                        JsonObject rarityConfig = class_3518.method_15296((JsonObject)jsonObject, (String)CUSTOM_RARITY_CONFIG_KEY);
                        if (rarityId.isEmpty() || rarityName.isEmpty()) continue;
                        CustomRarity newRarity = new CustomRarity(class_2561.method_43471((String)rarityName).getString());
                        if (!rarityColor.isEmpty()) {
                            newRarity.setColor(TextColorHelper.getColorFromHEX(rarityColor));
                        }
                        if (!rarityAnimatedColor.isEmpty() && PrismCompat.isPrismLoaded()) {
                            class_5251 prismColor = PrismCompat.parseColor(rarityAnimatedColor);
                            newRarity.setAnimatedColor(prismColor);
                            newRarity.setColor(prismColor.method_27716());
                        }
                        if (!raritySelectors.isEmpty()) {
                            ArrayList<String> selectors = new ArrayList<String>();
                            for (JsonElement selectorElement : raritySelectors) {
                                selectors.add(class_3518.method_15287((JsonElement)selectorElement, (String)"selector"));
                            }
                            if (!selectors.isEmpty()) {
                                newRarity.setSelectors(selectors);
                            }
                        }
                        if (!rarityConfig.isJsonNull()) {
                            newRarity.setConfig(rarityConfig);
                        }
                        RARITY_CACHE.put(rarityId, newRarity);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.name + ", color=" + this.color + ", rarityConfig=" + String.valueOf(this.rarityConfig) + "]";
    }
}

