/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams;

import com.lootbeams.LootBeams;
import com.lootbeams.dconfig.DynamicConfig;
import com.lootbeams.dconfig.events.ConfigEvents;
import com.lootbeams.events.PresetEvents;
import com.lootbeams.events.RenderEvents;
import com.lootbeams.events.ResourceEvents;
import com.lootbeams.features.BeamOpacityOnApproach;
import com.lootbeams.features.BeamSizeOnApproach;
import com.lootbeams.features.CustomLootBeamsConfig;
import com.lootbeams.features.CustomRarity;
import com.lootbeams.listeners.ResourceReloadListener;
import com.lootbeams.managers.GlowEffectManager;
import com.lootbeams.managers.ParticleManager;
import com.lootbeams.managers.PresetManager;
import com.lootbeams.managers.RenderManager;
import com.lootbeams.managers.TooltipManager;
import com.lootbeams.renderers.HudRenderer;
import com.lootbeams.renderers.LootBeamRenderer;
import com.lootbeams.screens.LootBeamsPresetManagerScreen;
import com.lootbeams.shaders.LootBeamShaders;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public class ClientSetup {
    public static class_304 keyBinding;

    public static void registerKeyBindings() {
        keyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("lootbeams.keybindings.savePreset", class_3675.class_307.field_1668, 325, "lootbeams.title"));
    }

    public static void registerCoreShaderRegistrationEvents() {
        CoreShaderRegistrationCallback.EVENT.register(shaderRegistry -> {
            LootBeamShaders.registerCoreShaders(shaderRegistry);
            LootBeamShaders.registerDroplightCoreShaders(shaderRegistry);
            LootBeamShaders.registerCustomCoreShaders(shaderRegistry);
        });
    }

    public static void registerHudRenderEvents() {
        RenderEvents.HUD.register((context, tickDelta) -> HudRenderer.onHudRender(context, tickDelta));
    }

    public static void registerWorldRenderEvents() {
        RenderEvents.BEFORE_PARTICLES.register(worldRendererContext -> RenderManager.onWorldRenderBeforeParticles(worldRendererContext));
        RenderEvents.AFTER_TRANSLUCENT.register(worldRendererContext -> RenderManager.onWorldRenderAfterTranslucent(worldRendererContext));
        RenderEvents.AFTER_WEATHER.register(worldRendererContext -> RenderManager.onWorldRenderAfterWeather(worldRendererContext));
        RenderEvents.BEFORE_END.register(worldRendererContext -> RenderManager.onWorldRenderBeforeEnd(worldRendererContext));
        RenderEvents.END.register(worldRendererContext -> RenderManager.onWorldRenderEnd(worldRendererContext));
    }

    public static void registerEntityEvents() {
        ClientEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                TooltipManager.onEntityLoad(itemEntity, world);
                RenderManager.onEntityLoad(itemEntity, world);
            }
        });
        ClientEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            if (entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                TooltipManager.onEntityUnload(itemEntity, world);
                RenderManager.onEntityUnload(itemEntity, world);
            }
        });
    }

    public static void registerClientEvents() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new ResourceReloadListener());
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (keyBinding.method_1436()) {
                class_310.method_1551().method_1507((class_437)new LootBeamsPresetManagerScreen(class_310.method_1551().field_1755));
            }
        });
    }

    public static void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"lootbeams").then(ClientCommandManager.literal((String)"save-preset").then(ClientCommandManager.argument((String)"presetName", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String presetName = StringArgumentType.getString((CommandContext)context, (String)"presetName");
            PresetManager.savePreset(presetName);
            return 1;
        })))).then(ClientCommandManager.literal((String)"item-custom-config").then(ClientCommandManager.literal((String)"available").executes(context -> {
            for (DynamicConfig.Control.Field field : LootBeams.configManager.getFieldsByGroup("visual")) {
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) continue;
                class_5250 fieldText = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)field.saveKey).method_27694(style -> style.method_10977(class_124.field_1078))).method_10852((class_2561)class_2561.method_43470((String)" "));
                class_5250 fieldDescriptionText = class_2561.method_43470((String)"[ ").method_27694(style -> style.method_10977(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"type=").method_27694(style -> style.method_10977(class_124.field_1080)));
                fieldDescriptionText = field.type == List.class ? fieldDescriptionText.method_10852((class_2561)class_2561.method_43470((String)"List([\"val1\", \"val2\", \"...\"])").method_27694(style -> style.method_10977(class_124.field_1068))) : (field.type == ParticleManager.ParticleTexture.class ? fieldDescriptionText.method_10852((class_2561)class_2561.method_43470((String)"String(lootbeams:particle_id)").method_27694(style -> style.method_10977(class_124.field_1068))) : (field.type == GlowEffectManager.GlowEffectTexture.class ? fieldDescriptionText.method_10852((class_2561)class_2561.method_43470((String)"String(lootbeams:glow_effect_id)").method_27694(style -> style.method_10977(class_124.field_1068))) : (field.type == LootBeamShaders.Shader.class ? fieldDescriptionText.method_10852((class_2561)class_2561.method_43470((String)("String(" + String.join((CharSequence)", ", Arrays.stream(LootBeamShaders.Shader.values()).map(shader -> shader.name().toLowerCase()).toList()) + ")")).method_27694(style -> style.method_10977(class_124.field_1068))) : (field.type == LootBeamShaders.CustomShader.class ? fieldDescriptionText.method_10852((class_2561)class_2561.method_43470((String)("String(" + String.join((CharSequence)", ", LootBeamShaders.CustomShader.values().stream().map(shader -> shader.name().toLowerCase()).toList()) + ")")).method_27694(style -> style.method_10977(class_124.field_1068))) : (field.type == BeamSizeOnApproach.class ? fieldDescriptionText.method_10852((class_2561)class_2561.method_43470((String)("String(" + String.join((CharSequence)", ", Arrays.stream(BeamOpacityOnApproach.values()).map(option -> option.name().toLowerCase()).toList()) + ")")).method_27694(style -> style.method_10977(class_124.field_1068))) : (field.type == BeamSizeOnApproach.class ? fieldDescriptionText.method_10852((class_2561)class_2561.method_43470((String)("String(" + String.join((CharSequence)", ", Arrays.stream(BeamSizeOnApproach.values()).map(option -> option.name().toLowerCase()).toList()) + ")")).method_27694(style -> style.method_10977(class_124.field_1068))) : fieldDescriptionText.method_10852((class_2561)class_2561.method_43470((String)field.type.toString()).method_27694(style -> style.method_10977(class_124.field_1068)))))))));
                if (field.type == Integer.TYPE || field.type == Float.TYPE || field.type == Double.TYPE || field.type == Long.TYPE) {
                    DecimalFormat format = new DecimalFormat("0.#####");
                    fieldDescriptionText = fieldDescriptionText.method_10852((class_2561)class_2561.method_43470((String)", min=").method_27694(style -> style.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_43470((String)format.format(field.minValue)).method_27694(style -> style.method_10977(class_124.field_1061))).method_10852((class_2561)class_2561.method_43470((String)", max=").method_27694(style -> style.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_43470((String)format.format(field.maxValue)).method_27694(style -> style.method_10977(class_124.field_1060)));
                }
                fieldDescriptionText = fieldDescriptionText.method_10852((class_2561)class_2561.method_43470((String)" ]").method_27694(style -> style.method_10977(class_124.field_1068)));
                player.method_43496((class_2561)fieldText.method_10852((class_2561)fieldDescriptionText));
            }
            return 1;
        })))));
    }

    public static void registerCustomEvents() {
        ConfigEvents.SAVE.register(() -> {
            CustomLootBeamsConfig.onConfigurationChange();
            LootBeamRenderer.onConfigurationChange();
        });
        PresetEvents.APPLY_PRESET.register(presetName -> {
            CustomLootBeamsConfig.onConfigurationChange();
            LootBeamRenderer.onConfigurationChange();
        });
        ResourceEvents.RESOURCE_RELOAD.register((synchronizer, resourceManager, prepareExecutor, applyExecutor) -> {
            TooltipManager.onResourcesReload();
            CustomLootBeamsConfig.onResourcesReload();
            CustomRarity.onResourcesReload(resourceManager);
            PresetManager.onResourcesReload(resourceManager);
            GlowEffectManager.onResourceManagerReload(resourceManager, prepareExecutor);
        });
    }
}

