/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.integration.AmendmentsCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2665;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_5172;
import net.minecraft.class_5556;
import org.jetbrains.annotations.Nullable;

public class RopeHelper {
    public static boolean addRopeDown(class_2338 pos, class_1937 level, @Nullable class_1657 player, class_1268 hand, class_2248 ropeBlock) {
        return RopeHelper.addRope(pos, level, player, hand, ropeBlock, class_2350.field_11033, Integer.MAX_VALUE);
    }

    public static boolean addRope(class_2338 pos, class_1937 level, @Nullable class_1657 player, class_1268 hand, class_2248 ropeBlock, class_2350 moveDir, int maxDist) {
        class_2586 class_25862;
        class_2680 state = level.method_8320(pos);
        if (maxDist <= 0) {
            return false;
        }
        --maxDist;
        if (RopeHelper.isCorrectRope(ropeBlock, state, moveDir)) {
            return RopeHelper.addRope(pos.method_10093(moveDir), level, player, hand, ropeBlock, moveDir, maxDist);
        }
        if (state.method_26204() instanceof PulleyBlock && (class_25862 = level.method_8321(pos)) instanceof PulleyBlockTile) {
            PulleyBlockTile te = (PulleyBlockTile)class_25862;
            return te.rotateIndirect(player, hand, ropeBlock, moveDir, false);
        }
        return RopeHelper.placeAndMove(player, hand, level, pos, moveDir, ropeBlock);
    }

    public static boolean isCorrectRope(class_2248 ropeBlock, class_2680 state, class_2350 direction) {
        if (state.method_26204() instanceof class_5172 && state.method_11654((class_2769)class_5172.field_11459) != direction.method_10166()) {
            return false;
        }
        return ropeBlock == state.method_26204();
    }

    public static boolean placeAndMove(@Nullable class_1657 player, class_1268 hand, class_1937 level, class_2338 originPos, class_2350 moveDir, @Nullable class_2248 placeWhereItWas) {
        class_2586 te;
        boolean needsToPush;
        class_2680 originalState = level.method_8320(originPos);
        class_2338 targetPos = originPos.method_10093(moveDir);
        class_2680 targetState = level.method_8320(targetPos);
        class_2487 tileTag = null;
        boolean bl = needsToPush = !originalState.method_45474();
        if (needsToPush) {
            if (!targetState.method_45474() && placeWhereItWas != null) {
                return false;
            }
            if (!RopeHelper.isPushableByRopes(originalState, level, originPos, moveDir)) {
                return false;
            }
            class_2586 tile = level.method_8321(originPos);
            if (tile != null) {
                if (CompatHandler.QUARK && !QuarkCompat.canMoveBlockEntity(originalState)) {
                    return false;
                }
                tile.method_11012();
                tileTag = tile.method_38244();
            }
        }
        class_3610 originalFluid = level.method_8316(originPos);
        if (placeWhereItWas != null) {
            level.method_8652(originPos, originalFluid.method_15759(), 18);
            class_1799 stack = new class_1799((class_1935)placeWhereItWas);
            class_1750 context = new class_1750(level, player, hand, stack, new class_3965(class_243.method_24953((class_2382)originPos), moveDir.method_10153(), originPos, false));
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1747) {
                class_1747 bi = (class_1747)class_17922;
                class_1269 placeResult = bi.method_7712(context);
                if (placeResult == class_1269.field_5811 || placeResult == class_1269.field_5814) {
                    level.method_8652(originPos, originalState, 4);
                    return false;
                }
                if (!needsToPush) {
                    return true;
                }
            }
        } else {
            level.method_8501(originPos, originalFluid.method_15759());
        }
        class_3610 targetFluid = level.method_8316(targetPos);
        boolean waterFluid = targetFluid.method_39360((class_3611)class_3612.field_15910);
        if (originalState.method_28498((class_2769)class_2741.field_12508)) {
            boolean canHoldWater = originalState.method_26164(ModTags.WATER_HOLDER);
            if (!canHoldWater) {
                originalState = (class_2680)originalState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(waterFluid));
            }
        } else if (originalState.method_26204() instanceof class_2275) {
            if (waterFluid && originalState.method_27852(class_2246.field_10593) || originalState.method_27852(class_2246.field_27097)) {
                originalState = (class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(3));
            } else if (targetFluid.method_39360((class_3611)class_3612.field_15908) && originalState.method_27852(class_2246.field_10593) || originalState.method_27852(class_2246.field_27098)) {
                originalState = class_2246.field_27098.method_9564();
            } else if (CompatHandler.AMENDMENTS) {
                originalState = AmendmentsCompat.fillCauldronWithFluid(level, targetPos, originalState, targetFluid);
            }
        }
        originalState = class_2248.method_9510((class_2680)originalState, (class_1936)level, (class_2338)targetPos);
        level.method_8501(targetPos, originalState);
        if (tileTag != null && (te = level.method_8321(targetPos)) != null) {
            te.method_11014(tileTag);
        }
        return true;
    }

    public static boolean removeRopeDown(class_2338 pos, class_1937 level, class_2248 ropeBlock) {
        return RopeHelper.removeRope(pos, level, ropeBlock, class_2350.field_11033, Integer.MAX_VALUE);
    }

    public static boolean removeRope(class_2338 pos, class_1937 level, class_2248 ropeBlock, class_2350 moveUpDir, int maxDist) {
        PulleyBlockTile te;
        class_2586 class_25862;
        if (maxDist <= 0) {
            return false;
        }
        --maxDist;
        class_2680 state = level.method_8320(pos);
        if (RopeHelper.isCorrectRope(ropeBlock, state, moveUpDir)) {
            return RopeHelper.removeRope(pos.method_10093(moveUpDir), level, ropeBlock, moveUpDir, maxDist);
        }
        if (state.method_26204() instanceof PulleyBlock && (class_25862 = level.method_8321(pos)) instanceof PulleyBlockTile && !(te = (PulleyBlockTile)class_25862).method_5442()) {
            return te.rotateIndirect(null, class_1268.field_5808, ropeBlock, moveUpDir, true);
        }
        class_2338 up = pos.method_10093(moveUpDir.method_10153());
        if (level.method_8320(up).method_26204() != ropeBlock) {
            return false;
        }
        if (!RopeHelper.placeAndMove(null, class_1268.field_5808, level, pos, moveUpDir.method_10153(), null)) {
            level.method_8501(up, level.method_8316(up).method_15759());
        }
        return true;
    }

    public static boolean isPushableByRopes(class_2680 state, class_1937 level, class_2338 pos, class_2350 moveDir) {
        if (state.method_26204() instanceof PulleyBlock) {
            return false;
        }
        if (state.method_26164(ModTags.ROPE_PUSH_BLACKLIST)) {
            return false;
        }
        if (!state.method_51367()) {
            return false;
        }
        if (moveDir.method_10166().method_10178() && state.method_26164(ModTags.ROPE_HANG_TAG)) {
            return true;
        }
        boolean couldBreak = !state.method_51367();
        return RopeHelper.isPushable(state, level, pos, moveDir, couldBreak, moveDir);
    }

    private static boolean isPushable(class_2680 state, class_1937 level, class_2338 pos, class_2350 movementDirection, boolean allowDestroy, class_2350 pistonFacing) {
        if (pos.method_10264() >= level.method_31607() && pos.method_10264() <= level.method_31600() - 1 && level.method_8621().method_11952(pos)) {
            if (state.method_26215()) {
                return true;
            }
            if (!(state.method_27852(class_2246.field_10540) || state.method_27852(class_2246.field_22423) || state.method_27852(class_2246.field_23152) || state.method_27852(class_2246.field_38420))) {
                if (movementDirection == class_2350.field_11033 && pos.method_10264() == level.method_31607()) {
                    return false;
                }
                if (movementDirection == class_2350.field_11036 && pos.method_10264() == level.method_31600() - 1) {
                    return false;
                }
                if (!state.method_27852(class_2246.field_10560) && !state.method_27852(class_2246.field_10615)) {
                    if (state.method_26214((class_1922)level, pos) == -1.0f) {
                        return false;
                    }
                    switch (state.method_26223()) {
                        case field_15972: {
                            return false;
                        }
                        case field_15971: {
                            return allowDestroy;
                        }
                        case field_15970: {
                            return movementDirection == pistonFacing;
                        }
                    }
                } else if (((Boolean)state.method_11654((class_2769)class_2665.field_12191)).booleanValue()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

