/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.supplementaries.client.screens.BlackBoardScreen;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.BlackboardButton;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_332;
import net.minecraft.class_5253;

public class DrawableBlackBoardButton
extends BlackboardButton {
    public static final int SIZE = 6;
    private final int u;
    private final int v;

    public DrawableBlackBoardButton(BlackBoardScreen screen, int centerX, int centerY, int u, int v, byte color) {
        super(screen, centerX - (8 - u) * 6, centerY - -v * 6, color, 6);
        this.u = u;
        this.v = v;
    }

    public void setColor(byte color) {
        this.parent.addHistory(this.u, this.v, this.color);
        this.color = color;
        this.parent.updateBlackboard(this.u, this.v, color);
    }

    @Override
    protected void onClick() {
        byte selectedColor = this.parent.getSelectedColor();
        this.setColor(selectedColor == this.color ? (byte)0 : selectedColor);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isValidClickButton(button)) {
            this.parent.onButtonDragged(mouseX, mouseY, this.color);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.parent.saveHistoryStep();
            return true;
        }
        return false;
    }

    @Override
    protected void renderButton(class_332 graphics) {
        int rgb = BlackboardBlock.colorFromByte(this.color);
        float b = (float)class_5253.class_5254.method_27767((int)rgb) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)rgb) / 255.0f;
        float r = (float)class_5253.class_5254.method_27765((int)rgb) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        int offset = this.color > 0 ? 16 : 0;
        graphics.method_25290(ModTextures.BLACKBOARD_GUI_TEXTURE, this.x, this.y, (float)(this.u + offset) * (float)this.size, (float)this.v * (float)this.size, this.size, this.size, 32 * this.size, 16 * this.size);
    }
}

