/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.customsplashscreen;

import eu.midnightdust.customsplashscreen.config.CustomSplashScreenConfig;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;

public class CustomSplashScreenClient
implements ClientModInitializer {
    public static File CONFIG_PATH = new File(FabricLoader.getInstance().getConfigDir() + "/customsplashscreen");
    public static final Path BackgroundTexture = Paths.get(CONFIG_PATH + "/background.png", new String[0]);
    public static final Path WideLogoTexture = Paths.get(CONFIG_PATH + "/wide_logo.png", new String[0]);
    public static final Path SquareLogoTexture = Paths.get(CONFIG_PATH + "/square_logo.png", new String[0]);
    public static final Path ProgressBarTexture = Paths.get(CONFIG_PATH + "/progressbar.png", new String[0]);
    public static final Path ProgressBarBackgroundTexture = Paths.get(CONFIG_PATH + "/progressbar_background.png", new String[0]);

    public void onInitializeClient() {
        CustomSplashScreenConfig.init((String)"customsplashscreen", CustomSplashScreenConfig.class);
        if (!CONFIG_PATH.exists()) {
            CONFIG_PATH.mkdir();
        }
        InputStream background = Thread.currentThread().getContextClassLoader().getResourceAsStream("background.png");
        InputStream wide = Thread.currentThread().getContextClassLoader().getResourceAsStream("wide_logo.png");
        InputStream square = Thread.currentThread().getContextClassLoader().getResourceAsStream("square_logo.png");
        InputStream progressbar = Thread.currentThread().getContextClassLoader().getResourceAsStream("progressbar.png");
        InputStream progressbarBG = Thread.currentThread().getContextClassLoader().getResourceAsStream("progressbar_background.png");
        try {
            if (!BackgroundTexture.toFile().exists()) {
                Files.copy(background, BackgroundTexture, StandardCopyOption.REPLACE_EXISTING);
            }
            if (!WideLogoTexture.toFile().exists()) {
                Files.copy(wide, WideLogoTexture, StandardCopyOption.REPLACE_EXISTING);
            }
            if (!SquareLogoTexture.toFile().exists()) {
                Files.copy(square, SquareLogoTexture, StandardCopyOption.REPLACE_EXISTING);
            }
            if (!ProgressBarTexture.toFile().exists()) {
                Files.copy(progressbar, ProgressBarTexture, StandardCopyOption.REPLACE_EXISTING);
            }
            if (!ProgressBarBackgroundTexture.toFile().exists()) {
                Files.copy(progressbarBG, ProgressBarBackgroundTexture, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

