/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.compat.jei;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.satisfy.bakery.client.gui.handler.StoveGuiHandler;
import net.satisfy.bakery.compat.jei.category.BakerStationCategory;
import net.satisfy.bakery.compat.jei.category.CookingPotCategory;
import net.satisfy.bakery.compat.jei.category.CraftingBowlCategory;
import net.satisfy.bakery.compat.jei.category.StoveCategory;
import net.satisfy.bakery.compat.jei.transfer.CookingTransferInfo;
import net.satisfy.bakery.registry.ObjectRegistry;
import net.satisfy.bakery.registry.RecipeTypeRegistry;
import net.satisfy.bakery.registry.ScreenHandlerTypeRegistry;
import net.satisfy.bakery.util.BakeryIdentifier;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class BakeryJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CookingPotCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new StoveCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CraftingBowlCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BakerStationCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        class_1863 rm = Objects.requireNonNull(class_310.method_1551().field_1687).method_8433();
        List fridgeRecipes = rm.method_30027((class_3956)RecipeTypeRegistry.COOKING_POT_RECIPE_TYPE.get());
        registration.addRecipes(CookingPotCategory.COOKING_POT, fridgeRecipes);
        List stoveRecipes = rm.method_30027((class_3956)RecipeTypeRegistry.STOVE_RECIPE_TYPE.get());
        registration.addRecipes(StoveCategory.STOVE, stoveRecipes);
        List cakingRecipes = rm.method_30027((class_3956)RecipeTypeRegistry.BAKING_STATION_RECIPE_TYPE.get());
        registration.addRecipes(BakerStationCategory.CAKING, cakingRecipes);
        List doughingRecipes = rm.method_30027((class_3956)RecipeTypeRegistry.CRAFTING_BOWL_RECIPE_TYPE.get());
        registration.addRecipes(CraftingBowlCategory.DOUGHING, doughingRecipes);
    }

    @NotNull
    public class_2960 getPluginUid() {
        return new BakeryIdentifier("jei_plugin");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new CookingTransferInfo());
        registration.addRecipeTransferHandler(StoveGuiHandler.class, (class_3917)ScreenHandlerTypeRegistry.STOVE_SCREEN_HANDLER.get(), StoveCategory.STOVE, 1, 3, 5, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.SMALL_COOKING_POT.get()).method_8389().method_7854(), new RecipeType[]{CookingPotCategory.COOKING_POT});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.BAKER_STATION.get()).method_8389().method_7854(), new RecipeType[]{BakerStationCategory.CAKING});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.CRAFTING_BOWL.get()).method_8389().method_7854(), new RecipeType[]{CraftingBowlCategory.DOUGHING});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.BRICK_STOVE.get()).method_8389().method_7854(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.STONE_BRICKS_STOVE.get()).method_8389().method_7854(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.COBBLESTONE_STOVE.get()).method_8389().method_7854(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.DEEPSLATE_STOVE.get()).method_8389().method_7854(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.GRANITE_STOVE.get()).method_8389().method_7854(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.MUD_STOVE.get()).method_8389().method_7854(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.SANDSTONE_STOVE.get()).method_8389().method_7854(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.END_STOVE.get()).method_8389().method_7854(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.RED_NETHER_BRICKS_STOVE.get()).method_8389().method_7854(), new RecipeType[]{StoveCategory.STOVE});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.QUARTZ_STOVE.get()).method_8389().method_7854(), new RecipeType[]{StoveCategory.STOVE});
    }

    public static void addSlot(IRecipeLayoutBuilder builder, int x, int y, class_1856 ingredient) {
        builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(ingredient);
    }
}

