/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.client.gui.handler;

import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import de.cristelknight.doapi.client.recipebook.handler.AbstractRecipeBookGUIScreenHandler;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2609;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import net.minecraft.class_3956;
import net.satisfy.bakery.client.gui.handler.slot.ExtendedSlot;
import net.satisfy.bakery.client.gui.handler.slot.StoveOutputSlot;
import net.satisfy.bakery.client.recipebook.group.StoveRecipeBookGroup;
import net.satisfy.bakery.recipe.StoveRecipe;
import net.satisfy.bakery.registry.RecipeTypeRegistry;
import net.satisfy.bakery.registry.ScreenHandlerTypeRegistry;

public class StoveGuiHandler
extends AbstractRecipeBookGUIScreenHandler {
    public static final int INPUTS = 4;
    public static final int FUEL_SLOT = 4;
    public static final int OUTPUT_SLOT = 0;

    public StoveGuiHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, (class_1263)new class_1277(5), (class_3913)new class_3919(4));
    }

    public StoveGuiHandler(int syncId, class_1661 playerInventory, class_1263 inventory, class_3913 delegate) {
        super((class_3917)ScreenHandlerTypeRegistry.STOVE_SCREEN_HANDLER.get(), syncId, 4, playerInventory, inventory, delegate);
        this.buildBlockEntityContainer(playerInventory, inventory);
        this.buildPlayerContainer(playerInventory);
    }

    private void buildBlockEntityContainer(class_1661 playerInventory, class_1263 inventory) {
        this.method_7621(new StoveOutputSlot(playerInventory.field_7546, inventory, 0, 126, 42));
        this.method_7621(new ExtendedSlot(inventory, 1, 29, 18, this::isIngredient));
        this.method_7621(new ExtendedSlot(inventory, 2, 47, 18, this::isIngredient));
        this.method_7621(new ExtendedSlot(inventory, 3, 65, 18, this::isIngredient));
        this.method_7621(new ExtendedSlot(inventory, 4, 42, 48, StoveGuiHandler::isFuel));
    }

    private void buildPlayerContainer(class_1661 playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 142));
        }
    }

    private boolean isIngredient(class_1799 stack) {
        return this.world.method_8433().method_30027((class_3956)RecipeTypeRegistry.STOVE_RECIPE_TYPE.get()).stream().anyMatch(recipe -> recipe.method_8117().stream().anyMatch(x -> x.method_8093(stack)));
    }

    private static boolean isFuel(class_1799 stack) {
        return class_2609.method_11195((class_1799)stack);
    }

    public int getScaledProgress(int arrowWidth) {
        int progress = this.propertyDelegate.method_17390(2);
        int totalProgress = this.propertyDelegate.method_17390(3);
        if (progress == 0) {
            return 0;
        }
        return progress * arrowWidth / totalProgress + 1;
    }

    public boolean isBeingBurned() {
        return this.propertyDelegate.method_17390(1) != 0;
    }

    public List<IRecipeBookGroup> getGroups() {
        return StoveRecipeBookGroup.STOVE_GROUPS;
    }

    public boolean hasIngredient(class_1860<?> recipe) {
        if (recipe instanceof StoveRecipe) {
            StoveRecipe StoveRecipe2 = (StoveRecipe)recipe;
            for (class_1856 ingredient : StoveRecipe2.method_8117()) {
                boolean found = false;
                for (class_1735 slot : this.field_7761) {
                    if (!ingredient.method_8093(slot.method_7677())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getCraftingSlotCount() {
        return 4;
    }
}

