/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.Constants;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.api.resources.ITipSerializer;
import net.darkhax.tipsmod.impl.TipsModCommon;
import net.darkhax.tipsmod.impl.resources.SimpleTip;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_7417;

public class TipsAPI {
    public static final class_2960 DEFAULT_SERIALIZER = new class_2960("tips", "simple_tip");
    public static final class_2561 DEFAULT_TITLE = class_2561.method_43471((String)"tipsmod.title.default").method_27695(new class_124[]{class_124.field_1067, class_124.field_1073, class_124.field_1054});
    private static final Map<class_2960, ITipSerializer<?>> SERIALIZERS = new HashMap();
    private static final Set<Class<? extends class_437>> SCREENS = new HashSet<Class<? extends class_437>>();
    private static int currentTipIndex = 0;
    @Deprecated
    public static final ITip EMPTY = new SimpleTip(new class_2960("bookshelf", "empty"), DEFAULT_TITLE, (class_2561)class_2561.method_43470((String)"This is deprecated and should no longer be used."), Optional.of(0));

    public static void registerTipSerializer(class_2960 id, ITipSerializer<?> serializer) {
        SERIALIZERS.put(id, serializer);
    }

    public static void registerTipScreen(Class<? extends class_437> screenClass) {
        SCREENS.add(screenClass);
    }

    public static boolean canRenderOnScreen(class_437 screen) {
        return SCREENS.stream().anyMatch(clazz -> clazz.isInstance(screen));
    }

    @Nullable
    @Deprecated
    public static ITip getRandomTip() {
        return TipsAPI.getRandomTip(class_310.method_1551().field_1755);
    }

    @Nullable
    public static ITip getRandomTip(class_437 screen) {
        List<ITip> filteredTips = TipsAPI.getLoadedTips().stream().filter(tip -> TipsAPI.canDisplayTip(tip) && tip.canDisplayOnScreen(screen)).toList();
        if (currentTipIndex + 1 > filteredTips.size()) {
            currentTipIndex = 0;
        }
        if (!filteredTips.isEmpty()) {
            return filteredTips.get(currentTipIndex++);
        }
        return null;
    }

    public static ITipSerializer<?> getTipSerializer(class_2960 id) {
        return SERIALIZERS.get(id);
    }

    public static List<ITip> getLoadedTips() {
        return TipsModCommon.TIP_MANAGER.getTips();
    }

    public static boolean canDisplayTip(ITip tip) {
        class_2588 translatable;
        class_7417 class_74172;
        if (tip == null) {
            return false;
        }
        if (tip.getId() == null) {
            Constants.LOG.error("Found invalid tip without an ID. Object: {}, Class: {}", (Object)tip, tip.getClass());
            return false;
        }
        if (tip.getTitle() == null) {
            Constants.LOG.error("Found invalid tip. Title is null. Object: {}, Class: {}, ID: {}", new Object[]{tip, tip.getClass(), tip.getId()});
            return false;
        }
        if (tip.getText() == null) {
            Constants.LOG.error("Found invalid tip. Text is null. Object: {}, Class: {}, ID: {}", new Object[]{tip, tip.getClass(), tip.getId()});
            return false;
        }
        class_2960 id = tip.getId();
        if (TipsModCommon.CONFIG.ignoredNamespaces.contains(id.method_12836())) {
            return false;
        }
        if (TipsModCommon.CONFIG.ignoredTips.contains(id.toString())) {
            return false;
        }
        return !TipsModCommon.CONFIG.hideUnlocalizedTips || !((class_74172 = tip.getText().method_10851()) instanceof class_2588) || class_1074.method_4663((String)(translatable = (class_2588)class_74172).method_11022());
    }
}

