/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2248;
import net.minecraft.class_2397;
import net.minecraft.class_2465;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class NBTParser {
    public static final int TRUNK_PIECE_SIZE = 3;
    public static final int LEAF_PIECE_SIZE = 4;

    public static void parseNBTFiles() throws IOException {
        File dataDirectory = FabricLoader.getInstance().getGameDir().resolve("data").toFile();
        File targetFolder = new File(dataDirectory, "graveyard/nbt");
        File outputFile = new File(dataDirectory, "graveyard/nbt/out.txt");
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
        if (targetFolder.exists() && targetFolder.isDirectory()) {
            File[] filesInDir;
            for (File nbtFile : filesInDir = targetFolder.listFiles()) {
                if (nbtFile.getName().equals("out.txt")) continue;
                ArrayList<Integer> trunkStates = new ArrayList<Integer>();
                ArrayList<Integer> leavesStates = new ArrayList<Integer>();
                writer.write(nbtFile.getName());
                writer.newLine();
                if (nbtFile.exists()) {
                    try {
                        class_2487 nbt = class_2507.method_30613((File)nbtFile);
                        class_2499 sizeList = nbt.method_10554("size", 3);
                        int sizeX = sizeList.method_10600(0);
                        int sizeZ = sizeList.method_10600(2);
                        int centerX = sizeX / 2;
                        int centerZ = sizeZ / 2;
                        class_2499 blocks = nbt.method_10554("blocks", 10);
                        class_2499 palette = nbt.method_10554("palette", 10);
                        for (int i = 0; i < blocks.size(); ++i) {
                            class_2960 blockId;
                            class_2248 block;
                            class_2487 blockTag = blocks.method_10602(i);
                            class_2499 posList = blockTag.method_10554("pos", 3);
                            int posX = posList.method_10600(0);
                            int posY = posList.method_10600(1);
                            int posZ = posList.method_10600(2);
                            int state = blockTag.method_10550("state");
                            class_2487 paletteEntry = palette.method_10602(state);
                            String blockName = paletteEntry.method_10558("Name");
                            if (blockName.equals("minecraft:air") || !((block = (class_2248)class_7923.field_41175.method_10223(blockId = new class_2960(blockName))) instanceof class_2397) && !(block instanceof class_2465)) continue;
                            class_2487 propertiesNbt = paletteEntry.method_10562("Properties");
                            if (block instanceof class_2465) {
                                trunkStates.add(posX - centerX);
                                trunkStates.add(posY);
                                trunkStates.add(posZ - centerZ);
                                continue;
                            }
                            leavesStates.add(posX - centerX);
                            leavesStates.add(posY);
                            leavesStates.add(posZ - centerZ);
                            leavesStates.add(Integer.parseInt(propertiesNbt.method_10558("distance")));
                        }
                        int n = nbt.method_10550("DataVersion");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                Iterator iterator = trunkStates.iterator();
                while (iterator.hasNext()) {
                    int item = (Integer)iterator.next();
                    writer.write(Integer.toString(item));
                    writer.write(", ");
                }
                writer.newLine();
                iterator = leavesStates.iterator();
                while (iterator.hasNext()) {
                    int item = (Integer)iterator.next();
                    writer.write(Integer.toString(item));
                    writer.write(", ");
                }
                writer.newLine();
                writer.newLine();
            }
        }
        writer.close();
    }
}

