/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.trades;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lion.graveyard.Graveyard;
import com.lion.graveyard.trades.trades.JsonBuyItemTradeOffer;
import com.lion.graveyard.trades.trades.JsonProcessItemTradeOffer;
import com.lion.graveyard.trades.trades.JsonSellEnchantedBookTradeOffer;
import com.lion.graveyard.trades.trades.JsonSellEnchantedToolTradeOffer;
import com.lion.graveyard.trades.trades.JsonSellItemTradeOffer;
import com.lion.graveyard.trades.trades.JsonSellPotionTradeOffer;
import com.lion.graveyard.trades.trades.JsonSellStructureMapTradeOffer;
import com.lion.graveyard.trades.trades.JsonTradeOffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_3853;
import org.jetbrains.annotations.NotNull;

public class TradeOfferManager {
    public static final Map<class_2960, JsonTradeOffer> tradeOfferRegistry = new HashMap<class_2960, JsonTradeOffer>();
    public static final List<class_3853.class_1652> TRADES_REGISTRY = new ArrayList<class_3853.class_1652>();

    public static void registerTradeOffers() {
        Graveyard.getLogger().info("Registered JSON trade offer adapter.");
        tradeOfferRegistry.put(new class_2960("graveyard", "sell_item"), new JsonSellItemTradeOffer());
        tradeOfferRegistry.put(new class_2960("graveyard", "buy_item"), new JsonBuyItemTradeOffer());
        tradeOfferRegistry.put(new class_2960("graveyard", "process_item"), new JsonProcessItemTradeOffer());
        tradeOfferRegistry.put(new class_2960("graveyard", "sell_potion"), new JsonSellPotionTradeOffer());
        tradeOfferRegistry.put(new class_2960("graveyard", "sell_enchanted_tool"), new JsonSellEnchantedToolTradeOffer());
        tradeOfferRegistry.put(new class_2960("graveyard", "sell_enchanted_book"), new JsonSellEnchantedBookTradeOffer());
        tradeOfferRegistry.put(new class_2960("graveyard", "sell_map"), new JsonSellStructureMapTradeOffer());
    }

    public static void deserializeJson(JsonObject jsonRoot) {
        String professionId = jsonRoot.get("profession").getAsString();
        if (professionId.equals("graveyard:nameless_hanged")) {
            TradeOfferManager.deserializeTrades(jsonRoot, TradeOfferManager::registerVillagerTrade);
        }
    }

    private static void deserializeTrades(@NotNull JsonObject jsonRoot, Consumer<class_3853.class_1652> tradeConsumer) {
        for (Map.Entry entry : jsonRoot.get("trades").getAsJsonObject().entrySet()) {
            JsonArray tradesArray = ((JsonElement)entry.getValue()).getAsJsonArray();
            for (JsonElement tradeElement : tradesArray) {
                JsonObject trade = tradeElement.getAsJsonObject();
                JsonTradeOffer adapter = tradeOfferRegistry.get(class_2960.method_12829((String)trade.get("type").getAsString()));
                if (adapter == null) {
                    Graveyard.getLogger().error("Trade type: " + trade.get("type").getAsString() + " is broken.");
                    Graveyard.getLogger().error("Error in deserializing trades.Trade element: " + tradeElement + " and Trade: " + trade + " in " + tradesArray + " is broken. \nSending faulty JSON: " + jsonRoot);
                    continue;
                }
                tradeConsumer.accept(adapter.deserialize(trade));
            }
        }
    }

    public static void registerVillagerTrade(class_3853.class_1652 trade) {
        TRADES_REGISTRY.add(trade);
    }
}

