/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.init;

import com.lion.graveyard.Graveyard;
import com.lion.graveyard.config.GraveyardConfig;
import com.lion.graveyard.entities.AcolyteEntity;
import com.lion.graveyard.entities.CorruptedIllager;
import com.lion.graveyard.entities.CorruptedPillager;
import com.lion.graveyard.entities.CorruptedVindicator;
import com.lion.graveyard.entities.FallingCorpse;
import com.lion.graveyard.entities.GhoulEntity;
import com.lion.graveyard.entities.GhoulingEntity;
import com.lion.graveyard.entities.LichEntity;
import com.lion.graveyard.entities.NamelessHangedEntity;
import com.lion.graveyard.entities.NightmareEntity;
import com.lion.graveyard.entities.ReaperEntity;
import com.lion.graveyard.entities.RevenantEntity;
import com.lion.graveyard.entities.SkeletonCreeper;
import com.lion.graveyard.entities.WraithEntity;
import com.lion.graveyard.entities.projectiles.SkullEntity;
import com.lion.graveyard.init.TGTags;
import com.lion.graveyard.mixin.SpawnRestrictionAccessor;
import com.lion.graveyard.platform.BiomeModifications;
import com.lion.graveyard.platform.RegistryHelper;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1588;
import net.minecraft.class_2902;

public class TGEntities {
    public static final Supplier<class_1299<ReaperEntity>> REAPER = RegistryHelper.registerEntityType("reaper", () -> class_1299.class_1300.method_5903(ReaperEntity::new, (class_1311)class_1311.field_6302).method_17687(0.5f, 1.4f).method_5905(Graveyard.createStringID("reaper")));
    public static final Supplier<class_1299<AcolyteEntity>> ACOLYTE = RegistryHelper.registerEntityType("acolyte", () -> class_1299.class_1300.method_5903(AcolyteEntity::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 1.9f).method_5905(Graveyard.createStringID("acolyte")));
    public static final Supplier<class_1299<CorruptedVindicator>> CORRUPTED_VINDICATOR = RegistryHelper.registerEntityType("corrupted_vindicator", () -> class_1299.class_1300.method_5903(CorruptedVindicator::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 1.9f).method_5905(Graveyard.createStringID("corrupted_vindicator")));
    public static final Supplier<class_1299<CorruptedPillager>> CORRUPTED_PILLAGER = RegistryHelper.registerEntityType("corrupted_pillager", () -> class_1299.class_1300.method_5903(CorruptedPillager::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 1.9f).method_5905(Graveyard.createStringID("corrupted_pillager")));
    public static final Supplier<class_1299<SkeletonCreeper>> SKELETON_CREEPER = RegistryHelper.registerEntityType("skeleton_creeper", () -> class_1299.class_1300.method_5903(SkeletonCreeper::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 1.7f).method_5905(Graveyard.createStringID("skeleton_creeper")));
    public static final Supplier<class_1299<FallingCorpse>> FALLING_CORPSE = RegistryHelper.registerEntityType("falling_corpse", () -> class_1299.class_1300.method_5903(FallingCorpse::new, (class_1311)class_1311.field_17715).method_17687(0.4f, 0.5f).method_5905(Graveyard.createStringID("falling_corpse")));
    public static final Supplier<class_1299<GhoulEntity>> GHOUL = RegistryHelper.registerEntityType("ghoul", () -> class_1299.class_1300.method_5903(GhoulEntity::new, (class_1311)class_1311.field_6302).method_17687(0.8f, 2.1f).method_5905(Graveyard.createStringID("ghoul")));
    public static final Supplier<class_1299<RevenantEntity>> REVENANT = RegistryHelper.registerEntityType("revenant", () -> class_1299.class_1300.method_5903(RevenantEntity::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 1.9f).method_5905(Graveyard.createStringID("revenant")));
    public static final Supplier<class_1299<WraithEntity>> WRAITH = RegistryHelper.registerEntityType("wraith", () -> class_1299.class_1300.method_5903(WraithEntity::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 1.8f).method_5905(Graveyard.createStringID("wraith")));
    public static final Supplier<class_1299<NightmareEntity>> NIGHTMARE = RegistryHelper.registerEntityType("nightmare", () -> class_1299.class_1300.method_5903(NightmareEntity::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 2.6f).method_5905(Graveyard.createStringID("nightmare")));
    public static final Supplier<class_1299<GhoulingEntity>> GHOULING = RegistryHelper.registerEntityType("ghouling", () -> class_1299.class_1300.method_5903(GhoulingEntity::new, (class_1311)class_1311.field_6294).method_17687(0.7f, 2.0f).method_5905(Graveyard.createStringID("ghouling")));
    public static final Supplier<class_1299<LichEntity>> LICH = RegistryHelper.registerEntityType("lich", () -> class_1299.class_1300.method_5903(LichEntity::new, (class_1311)class_1311.field_6302).method_17687(0.9f, 4.0f).method_5905(Graveyard.createStringID("lich")));
    public static final Supplier<class_1299<SkullEntity>> SKULL = RegistryHelper.registerEntityType("skull", () -> class_1299.class_1300.method_5903(SkullEntity::new, (class_1311)class_1311.field_17715).method_17687(0.25f, 0.25f).method_27299(4).method_27300(10).method_5905(Graveyard.createStringID("skull")));
    public static final Supplier<class_1299<NamelessHangedEntity>> NAMELESS_HANGED = RegistryHelper.registerEntityType("nameless_hanged", () -> class_1299.class_1300.method_5903(NamelessHangedEntity::new, (class_1311)class_1311.field_6302).method_17687(0.8f, 2.5f).method_5905(Graveyard.createStringID("nameless_hanged")));

    private TGEntities() {
    }

    public static void init() {
        TGEntities.createMobAttributes();
    }

    public static void postInit() {
        TGEntities.addSpawnRestrictions();
        TGEntities.addSpawns();
    }

    private static void addSpawns() {
        GraveyardConfig config = Graveyard.getConfig();
        BiomeModifications.addMobSpawn(TGTags.GHOUL_SPAWNS, class_1311.field_6302, GHOUL.get(), config.mobConfigEntries.get((Object)"ghoul").weight, config.mobConfigEntries.get((Object)"ghoul").minGroup, config.mobConfigEntries.get((Object)"ghoul").maxGroup);
        BiomeModifications.addMobSpawn(TGTags.REVENANT_SPAWNS, class_1311.field_6302, REVENANT.get(), config.mobConfigEntries.get((Object)"revenant").weight, config.mobConfigEntries.get((Object)"revenant").minGroup, config.mobConfigEntries.get((Object)"revenant").maxGroup);
        BiomeModifications.addMobSpawn(TGTags.REAPER_SPAWNS, class_1311.field_6302, REAPER.get(), config.mobConfigEntries.get((Object)"reaper").weight, config.mobConfigEntries.get((Object)"reaper").minGroup, config.mobConfigEntries.get((Object)"reaper").maxGroup);
        BiomeModifications.addMobSpawn(TGTags.NIGHTMARE_SPAWNS, class_1311.field_6302, NIGHTMARE.get(), config.mobConfigEntries.get((Object)"nightmare").weight, config.mobConfigEntries.get((Object)"nightmare").minGroup, config.mobConfigEntries.get((Object)"nightmare").maxGroup);
        BiomeModifications.addMobSpawn(TGTags.SKELETON_CREEPER_SPAWNS, class_1311.field_6302, SKELETON_CREEPER.get(), config.mobConfigEntries.get((Object)"skeleton_creeper").weight, config.mobConfigEntries.get((Object)"skeleton_creeper").minGroup, config.mobConfigEntries.get((Object)"skeleton_creeper").maxGroup);
    }

    private static void addSpawnRestrictions() {
        SpawnRestrictionAccessor.callRegister(REAPER.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
        SpawnRestrictionAccessor.callRegister(ACOLYTE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20681);
        SpawnRestrictionAccessor.callRegister(CORRUPTED_VINDICATOR.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20681);
        SpawnRestrictionAccessor.callRegister(CORRUPTED_PILLAGER.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20681);
        SpawnRestrictionAccessor.callRegister(SKELETON_CREEPER.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
        SpawnRestrictionAccessor.callRegister(FALLING_CORPSE.get(), class_1317.class_1319.field_19350, class_2902.class_2903.field_13203, class_1588::method_20681);
        SpawnRestrictionAccessor.callRegister(GHOUL.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
        SpawnRestrictionAccessor.callRegister(REVENANT.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
        SpawnRestrictionAccessor.callRegister(WRAITH.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
        SpawnRestrictionAccessor.callRegister(NIGHTMARE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
        SpawnRestrictionAccessor.callRegister(LICH.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1588::method_20680);
    }

    private static void createMobAttributes() {
        RegistryHelper.registerEntityAttribute(REAPER, ReaperEntity::createReaperAttributes);
        RegistryHelper.registerEntityAttribute(ACOLYTE, CorruptedIllager::createCorruptedIllagerAttributes);
        RegistryHelper.registerEntityAttribute(CORRUPTED_VINDICATOR, CorruptedIllager::createCorruptedIllagerAttributes);
        RegistryHelper.registerEntityAttribute(CORRUPTED_PILLAGER, CorruptedPillager::createCorruptedPillagerAttributes);
        RegistryHelper.registerEntityAttribute(SKELETON_CREEPER, SkeletonCreeper::createSkeletonCreeperAttributes);
        RegistryHelper.registerEntityAttribute(FALLING_CORPSE, FallingCorpse::createFallingCorpseAttributes);
        RegistryHelper.registerEntityAttribute(GHOUL, GhoulEntity::createGhoulAttributes);
        RegistryHelper.registerEntityAttribute(REVENANT, RevenantEntity::createRevenantAttributes);
        RegistryHelper.registerEntityAttribute(WRAITH, WraithEntity::createWraithAttributes);
        RegistryHelper.registerEntityAttribute(NIGHTMARE, NightmareEntity::createNightmareAttributes);
        RegistryHelper.registerEntityAttribute(GHOULING, GhoulingEntity::createGhoulingAttributes);
        RegistryHelper.registerEntityAttribute(NAMELESS_HANGED, NamelessHangedEntity::createNamelessHangedAttributes);
        RegistryHelper.registerEntityAttribute(LICH, LichEntity::createLichAttributes);
    }
}

