/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities.ai.goals;

import com.lion.graveyard.entities.LichEntity;
import com.lion.graveyard.init.TGParticles;
import java.util.EnumSet;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class LichMeleeGoal
extends class_1352 {
    protected final LichEntity mob;
    private final double speed;
    private final boolean pauseWhenMobIdle;
    private class_11 path;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int updateCountdownTicks;
    private int cooldown;
    private final int attackIntervalTicks = 20;
    private long lastUpdateTime;
    private final int DAMAGE_START_IN_ANIM = 16;
    private int animationTicker = 40;
    private int scareSoundAge = 40;
    boolean canFinishAttack = false;

    public LichMeleeGoal(LichEntity mob, double speed, boolean pauseWhenMobIdle) {
        this.mob = mob;
        this.speed = speed;
        this.pauseWhenMobIdle = pauseWhenMobIdle;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        long l = this.mob.method_5770().method_8510();
        if (l - this.lastUpdateTime < 20L) {
            this.lastUpdateTime -= 20L;
            return this.method_6264();
        }
        this.lastUpdateTime = l;
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.method_5805()) {
            return false;
        }
        this.path = this.mob.method_5942().method_6349((class_1297)livingEntity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getSquaredMaxAttackDistance(livingEntity) >= this.mob.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
    }

    public boolean method_6266() {
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.method_5805()) {
            return false;
        }
        if (!this.pauseWhenMobIdle) {
            return !this.mob.method_5942().method_6357();
        }
        if (!this.mob.method_18407(livingEntity.method_24515())) {
            return false;
        }
        return !(livingEntity instanceof class_1657) || !livingEntity.method_7325() && !((class_1657)livingEntity).method_7337();
    }

    public void method_6269() {
        this.mob.method_5942().method_6334(this.path, this.speed);
        this.mob.method_19540(true);
        this.updateCountdownTicks = 0;
        this.cooldown = 0;
    }

    public void method_6270() {
        class_1309 livingEntity = this.mob.method_5968();
        if (!class_1301.field_6156.test(livingEntity)) {
            this.mob.method_5980(null);
        }
        this.mob.method_19540(false);
        this.mob.method_5942().method_6340();
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity != null) {
            this.mob.method_5988().method_6226((class_1297)livingEntity, 30.0f, 30.0f);
            double d = this.mob.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
            this.updateCountdownTicks = Math.max(this.updateCountdownTicks - 1, 0);
            if ((this.pauseWhenMobIdle || this.mob.method_5985().method_6369((class_1297)livingEntity)) && this.updateCountdownTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingEntity.method_5649(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.mob.method_6051().method_43057() < 0.05f)) {
                this.targetX = livingEntity.method_23317();
                this.targetY = livingEntity.method_23318();
                this.targetZ = livingEntity.method_23321();
                this.updateCountdownTicks = 4 + this.mob.method_6051().method_43048(7);
                if (d > 1024.0) {
                    this.updateCountdownTicks += 10;
                } else if (d > 256.0) {
                    this.updateCountdownTicks += 5;
                }
                if (!this.mob.method_5942().method_6335((class_1297)livingEntity, this.speed)) {
                    this.updateCountdownTicks += 15;
                }
                this.updateCountdownTicks = this.method_38847(this.updateCountdownTicks);
            }
            this.cooldown = Math.max(this.cooldown - 1, 0);
            --this.animationTicker;
            --this.scareSoundAge;
            this.attack(livingEntity, d);
        }
    }

    protected void attack(class_1309 target, double squaredDistance) {
        double d = this.getSquaredMaxAttackDistance(target);
        int phase = this.mob.getPhase();
        if (phase == 1) {
            if (this.mob.canMeeleAttack()) {
                if (squaredDistance <= d && this.cooldown <= 0) {
                    this.resetCooldown(20);
                    if (this.mob.getAttackAnimTimer() == 0) {
                        this.mob.setAttackAnimTimer(this.mob.ATTACK_ANIMATION_DURATION);
                        this.animationTicker = this.mob.ATTACK_ANIMATION_DURATION;
                    }
                    if (this.mob.getAttackAnimTimer() == this.mob.ATTACK_ANIMATION_DURATION) {
                        this.mob.playAttackSound();
                    }
                    this.canFinishAttack = true;
                }
                if (this.canFinishAttack && this.animationTicker == 16 && this.mob.method_6121((class_1297)target)) {
                    class_243 vec3d = this.mob.method_19538().method_1031(0.0, (double)1.6f, 0.0);
                    class_243 vec3d2 = target.method_33571().method_1020(vec3d);
                    class_243 vec3d3 = vec3d2.method_1029();
                    for (int i = 1; i < class_3532.method_15357((double)vec3d2.method_1033()) + 7; ++i) {
                        class_243 vec3d4 = vec3d.method_1019(vec3d3.method_1021((double)i));
                        ((class_3218)this.mob.method_37908()).method_14199((class_2394)TGParticles.GRAVEYARD_SOUL_BEAM_PARTICLE, vec3d4.field_1352, vec3d4.field_1351 + 1.0, vec3d4.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    double e = 2.5 * (1.0 - target.method_26825(class_5134.field_23718));
                    double f = 1.5 * (1.0 - target.method_26825(class_5134.field_23718));
                    target.method_5762(vec3d3.method_10216() * e, vec3d3.method_10214() * f, vec3d3.method_10215() * e);
                    this.canFinishAttack = false;
                }
            }
        } else if (phase == 3 && this.mob.canHuntStart() || phase == 5) {
            if (phase == 3 && squaredDistance <= d + 11.0 && this.scareSoundAge <= 0) {
                this.mob.playScareSound();
                this.scareSoundAge = 80;
            }
            if (squaredDistance <= d && this.cooldown <= 0) {
                this.resetCooldown(20);
                this.mob.method_6121((class_1297)target);
            }
        }
    }

    protected double getSquaredMaxAttackDistance(class_1309 entity) {
        if (this.mob.getPhase() == 1) {
            return 16.0;
        }
        if (this.mob.getPhase() == 3) {
            return this.mob.method_17681() * 3.0f * this.mob.method_17681() * 3.0f + entity.method_17681();
        }
        return this.mob.method_17681() * 2.0f * this.mob.method_17681() * 2.0f + entity.method_17681();
    }

    protected void resetCooldown(int ticks) {
        this.cooldown = this.method_38847(ticks);
    }
}

