/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities;

import com.lion.graveyard.entities.CorruptedIllager;
import com.lion.graveyard.entities.HostileGraveyardEntity;
import com.lion.graveyard.init.TGAdvancements;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2902;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public abstract class HordeGraveyardEntity
extends HostileGraveyardEntity {
    private class_2338 patrolTarget;
    private boolean patrolling;
    private boolean patrolLeader;

    protected HordeGraveyardEntity(class_1299<? extends class_1588> entityType, class_1937 world, String name) {
        super(entityType, world, name);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(2, (class_1352)new PatrolApproachGoal(this, 10.0f));
        this.field_6201.method_6277(4, new PatrolGoal<HordeGraveyardEntity>(this, 1.0, 0.9));
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.patrolTarget != null) {
            nbt.method_10566("PatrolTarget", (class_2520)class_2512.method_10692((class_2338)this.patrolTarget));
        }
        nbt.method_10556("PatrolLeader", this.patrolLeader);
        nbt.method_10556("Patrolling", this.patrolling);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("PatrolTarget")) {
            this.patrolTarget = class_2512.method_10691((class_2487)nbt.method_10562("PatrolTarget"));
        }
        this.patrolLeader = nbt.method_10577("PatrolLeader");
        this.patrolling = nbt.method_10577("Patrolling");
    }

    public double method_5678() {
        return -0.45;
    }

    public boolean canLead() {
        return true;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        if (spawnReason != class_3730.field_16527 && spawnReason != class_3730.field_16467 && spawnReason != class_3730.field_16474 && this.field_5974.method_43057() < 0.06f && this.canLead()) {
            this.patrolLeader = true;
        }
        if (spawnReason == class_3730.field_16527) {
            this.patrolling = true;
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public boolean method_5974(double distanceSquared) {
        return !this.patrolling || distanceSquared > 16384.0;
    }

    public void setPatrolTarget(class_2338 targetPos) {
        this.patrolTarget = targetPos;
        this.patrolling = true;
    }

    public void setPatrolLeader(boolean patrolLeader) {
        this.patrolLeader = patrolLeader;
        this.patrolling = true;
    }

    public boolean isPatrolLeader() {
        return this.patrolLeader;
    }

    public class_2338 getPatrolTarget() {
        return this.patrolTarget;
    }

    public boolean hasPatrolTarget() {
        return this.patrolTarget != null;
    }

    public void setRandomPatrolTarget() {
        this.patrolTarget = this.method_24515().method_10069(-500 + this.field_5974.method_43048(1000), 0, -500 + this.field_5974.method_43048(1000));
        this.patrolling = true;
    }

    protected void setPatrolling(boolean patrolling) {
        this.patrolling = patrolling;
    }

    public boolean hasNoRaid() {
        return true;
    }

    protected boolean isRaidCenterSet() {
        return this.patrolling;
    }

    protected void method_23733(@Nullable class_1309 adversary) {
        if (adversary instanceof class_3222) {
            class_3222 player = (class_3222)adversary;
            if (this.patrolLeader) {
                TGAdvancements.KILL_HORDE.trigger(player);
            }
        }
        super.method_23733(adversary);
    }

    protected class PatrolApproachGoal
    extends class_1352 {
        private final HordeGraveyardEntity hordeEntity;
        private final float squaredDistance;
        public final class_4051 closeRaiderPredicate = class_4051.method_36626().method_18418(8.0).method_36627().method_18424();

        public PatrolApproachGoal(HordeGraveyardEntity hordeEntity, float distance) {
            this.hordeEntity = hordeEntity;
            this.squaredDistance = distance * distance;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.hordeEntity.method_6065();
            return this.hordeEntity.isRaidCenterSet() && this.hordeEntity.method_5968() != null && !this.hordeEntity.method_6510() && (livingEntity == null || livingEntity.method_5864() != class_1299.field_6097);
        }

        public void method_6269() {
            super.method_6269();
            this.hordeEntity.method_5942().method_6340();
            List list = this.hordeEntity.method_5770().method_18466(HordeGraveyardEntity.class, this.closeRaiderPredicate, (class_1309)this.hordeEntity, this.hordeEntity.method_5829().method_1009(8.0, 8.0, 8.0));
            for (HordeGraveyardEntity hordeEntityEntity : list) {
                hordeEntityEntity.method_5980(this.hordeEntity.method_5968());
            }
        }

        public void method_6270() {
            super.method_6270();
            class_1309 livingEntity = this.hordeEntity.method_5968();
            if (livingEntity != null) {
                List list = this.hordeEntity.method_5770().method_18466(HordeGraveyardEntity.class, this.closeRaiderPredicate, (class_1309)this.hordeEntity, this.hordeEntity.method_5829().method_1009(8.0, 8.0, 8.0));
                for (HordeGraveyardEntity hordeEntityEntity : list) {
                    hordeEntityEntity.method_5980(livingEntity);
                    hordeEntityEntity.method_19540(true);
                }
                this.hordeEntity.method_19540(true);
            }
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            class_1309 livingEntity = this.hordeEntity.method_5968();
            if (livingEntity != null) {
                if (this.hordeEntity.method_5858((class_1297)livingEntity) > (double)this.squaredDistance) {
                    this.hordeEntity.method_5988().method_6226((class_1297)livingEntity, 30.0f, 30.0f);
                    if (this.hordeEntity.field_5974.method_43048(50) == 0) {
                        this.hordeEntity.method_5966();
                    }
                } else {
                    this.hordeEntity.method_19540(true);
                }
                super.method_6268();
            }
        }
    }

    public static class PatrolGoal<T extends HordeGraveyardEntity>
    extends class_1352 {
        private final T entity;
        private final double leaderSpeed;
        private final double followSpeed;
        private long nextPatrolSearchTime;

        public PatrolGoal(T entity, double leaderSpeed, double followSpeed) {
            this.entity = entity;
            if (entity instanceof CorruptedIllager) {
                this.leaderSpeed = leaderSpeed - 0.5;
                this.followSpeed = followSpeed - 0.5;
            } else {
                this.leaderSpeed = leaderSpeed;
                this.followSpeed = followSpeed;
            }
            this.nextPatrolSearchTime = -1L;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            boolean bl = this.entity.method_5770().method_8510() < this.nextPatrolSearchTime;
            return ((HordeGraveyardEntity)((Object)this.entity)).isRaidCenterSet() && this.entity.method_5968() == null && !this.entity.method_5782() && ((HordeGraveyardEntity)((Object)this.entity)).hasPatrolTarget() && !bl;
        }

        public void method_6269() {
        }

        public void method_6270() {
        }

        public void method_6268() {
            boolean bl = ((HordeGraveyardEntity)((Object)this.entity)).isPatrolLeader();
            class_1408 entityNavigation = this.entity.method_5942();
            if (entityNavigation.method_6357()) {
                List<HordeGraveyardEntity> list = this.findPatrolTargets();
                if (((HordeGraveyardEntity)((Object)this.entity)).isRaidCenterSet() && list.isEmpty()) {
                    ((HordeGraveyardEntity)((Object)this.entity)).setPatrolling(false);
                } else if (bl && ((HordeGraveyardEntity)((Object)this.entity)).getPatrolTarget().method_19769((class_2374)this.entity.method_19538(), 10.0)) {
                    ((HordeGraveyardEntity)((Object)this.entity)).setRandomPatrolTarget();
                } else {
                    class_243 vec3d = class_243.method_24955((class_2382)((HordeGraveyardEntity)((Object)this.entity)).getPatrolTarget());
                    class_243 vec3d2 = this.entity.method_19538();
                    class_243 vec3d3 = vec3d2.method_1020(vec3d);
                    vec3d = vec3d3.method_1024(90.0f).method_1021(0.4).method_1019(vec3d);
                    class_243 vec3d4 = vec3d.method_1020(vec3d2).method_1029().method_1021(10.0).method_1019(vec3d2);
                    class_2338 blockPos = class_2338.method_49638((class_2374)vec3d4);
                    blockPos = this.entity.method_5770().method_8598(class_2902.class_2903.field_13203, blockPos);
                    if (!entityNavigation.method_6337((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), bl ? this.followSpeed : this.leaderSpeed)) {
                        this.wander();
                        this.nextPatrolSearchTime = this.entity.method_5770().method_8510() + 200L;
                    } else if (bl) {
                        for (HordeGraveyardEntity patrolEntity : list) {
                            patrolEntity.setPatrolTarget(blockPos);
                        }
                    }
                }
            }
        }

        private List<HordeGraveyardEntity> findPatrolTargets() {
            return this.entity.method_5770().method_8390(HordeGraveyardEntity.class, this.entity.method_5829().method_1014(16.0), patrolEntity -> patrolEntity.hasNoRaid() && !patrolEntity.method_5779((class_1297)this.entity));
        }

        private boolean wander() {
            Random random = new Random();
            class_2338 blockPos = this.entity.method_5770().method_8598(class_2902.class_2903.field_13203, this.entity.method_24515().method_10069(-8 + random.nextInt(16), 0, -8 + random.nextInt(16)));
            return this.entity.method_5942().method_6337((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), this.leaderSpeed);
        }
    }
}

