/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.blockentities;

import com.lion.graveyard.init.TGBlockEntities;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5837;
import net.minecraft.class_8242;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class GravestoneBlockEntity
extends class_2586 {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private UUID editor;
    private class_8242 text = this.createText();
    private boolean waxed;

    public GravestoneBlockEntity(class_2338 pos, class_2680 state) {
        this(TGBlockEntities.GRAVESTONE_BLOCK_ENTITY.get(), pos, state);
    }

    public GravestoneBlockEntity(class_2591 blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected class_8242 createText() {
        return new class_8242();
    }

    public class_8242 getText() {
        return this.text;
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextWidth() {
        return 90;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        DataResult var10000 = class_8242.field_43298.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.text);
        Logger var10001 = LOGGER;
        Objects.requireNonNull(var10001);
        var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(frontText -> nbt.method_10566("front_text", frontText));
        nbt.method_10556("is_waxed", this.waxed);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("front_text")) {
            DataResult var10000 = class_8242.field_43298.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("front_text"));
            Logger var10001 = LOGGER;
            Objects.requireNonNull(var10001);
            var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(signText -> {
                this.text = this.parseLines((class_8242)signText);
            });
        }
        this.waxed = nbt.method_10577("is_waxed");
    }

    private class_8242 parseLines(class_8242 signText) {
        for (int i = 0; i < 4; ++i) {
            class_2561 text = this.parseLine(signText.method_49859(i, false));
            class_2561 text2 = this.parseLine(signText.method_49859(i, true));
            signText = signText.method_49858(i, text, text2);
        }
        return signText;
    }

    private class_2561 parseLine(class_2561 text) {
        class_1937 var3 = this.field_11863;
        if (var3 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)var3;
            try {
                return class_2564.method_10881((class_2168)GravestoneBlockEntity.createCommandSource(null, (class_1937)serverWorld, this.field_11867), (class_2561)text, (class_1297)null, (int)0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return text;
    }

    public void tryChangeText(class_1657 player, List<class_5837> messages) {
        if (!this.isWaxed() && player.method_5667().equals(this.getEditor()) && this.field_11863 != null) {
            this.changeText(text -> this.getTextWithMessages(player, messages, (class_8242)text));
            this.setEditor(null);
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        } else {
            LOGGER.warn("Player {} just tried to change non-editable sign", (Object)player.method_5477().getString());
        }
    }

    public boolean changeText(UnaryOperator<class_8242> textChanger) {
        class_8242 signText = this.getText();
        return this.setText((class_8242)textChanger.apply(signText));
    }

    private class_8242 getTextWithMessages(class_1657 player, List<class_5837> messages, class_8242 text) {
        for (int i = 0; i < messages.size(); ++i) {
            class_5837 filteredMessage = messages.get(i);
            class_2583 style = text.method_49859(i, player.method_33793()).method_10866();
            text = player.method_33793() ? text.method_49857(i, (class_2561)class_2561.method_43470((String)filteredMessage.method_45061()).method_10862(style)) : text.method_49858(i, (class_2561)class_2561.method_43470((String)filteredMessage.comp_841()).method_10862(style), (class_2561)class_2561.method_43470((String)filteredMessage.method_45061()).method_10862(style));
        }
        return text;
    }

    public boolean setText(class_8242 text) {
        return this.setFrontText(text);
    }

    private boolean setFrontText(class_8242 frontText) {
        if (frontText != this.text) {
            this.text = frontText;
            this.updateListeners();
            return true;
        }
        return false;
    }

    public boolean runCommandClickEvent(class_1657 player, class_1937 world, class_2338 pos) {
        class_2561[] var6;
        boolean bl = false;
        for (class_2561 text : var6 = this.getText().method_49877(player.method_33793())) {
            class_2583 style = text.method_10866();
            class_2558 clickEvent = style.method_10970();
            if (clickEvent == null || clickEvent.method_10845() != class_2558.class_2559.field_11750) continue;
            player.method_5682().method_3734().method_44252(GravestoneBlockEntity.createCommandSource(player, world, pos), clickEvent.method_10844());
            bl = true;
        }
        return bl;
    }

    private static class_2168 createCommandSource(@Nullable class_1657 player, class_1937 world, class_2338 pos) {
        String string = player == null ? "Sign" : player.method_5477().getString();
        class_5250 text = player == null ? class_2561.method_43470((String)"Sign") : player.method_5476();
        return new class_2168(class_2165.field_17395, class_243.method_24953((class_2382)pos), class_241.field_1340, (class_3218)world, 2, string, (class_2561)text, world.method_8503(), (class_1297)player);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public boolean method_11011() {
        return true;
    }

    public void setEditor(@Nullable UUID editor) {
        this.editor = editor;
    }

    @Nullable
    public UUID getEditor() {
        return this.editor;
    }

    private void updateListeners() {
        this.method_5431();
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public boolean setWaxed(boolean waxed) {
        if (this.waxed != waxed) {
            this.waxed = waxed;
            this.updateListeners();
            return true;
        }
        return false;
    }

    public boolean isPlayerTooFarToEdit(UUID uuid) {
        class_1657 playerEntity = this.field_11863.method_18470(uuid);
        return playerEntity == null || playerEntity.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) > 64.0;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, GravestoneBlockEntity blockEntity) {
        UUID uUID = blockEntity.getEditor();
        if (uUID != null) {
            blockEntity.tryClearInvalidEditor(blockEntity, world, uUID);
        }
    }

    private void tryClearInvalidEditor(GravestoneBlockEntity blockEntity, class_1937 world, UUID uuid) {
        if (blockEntity.isPlayerTooFarToEdit(uuid)) {
            blockEntity.setEditor(null);
        }
    }
}

