/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.menu;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.AttachmentType;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.menu.FilteredSlot;
import io.github.mortuusars.exposure.util.ItemAndStack;
import io.github.mortuusars.exposure.util.supporter.Supporters;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;

public class CameraAttachmentsMenu
extends class_1703 {
    public static final int SKIN_REGULAR_BUTTON_ID = 100;
    public static final int SKIN_GOLD_BUTTON_ID = 101;
    private final int attachmentSlotsCount;
    private final int cameraSlotIndex;
    private final class_1657 player;
    private final ItemAndStack<CameraItem> camera;
    private boolean clientContentsInitialized;

    public CameraAttachmentsMenu(int containerId, class_1661 playerInventory, final int cameraSlotIndex) {
        super(Exposure.MenuTypes.CAMERA.get(), containerId);
        class_1799 cameraStack = (class_1799)playerInventory.field_7547.get(cameraSlotIndex);
        Preconditions.checkState((boolean)(cameraStack.method_7909() instanceof CameraItem), (Object)("Failed to open Camera Attachments. " + String.valueOf(cameraStack) + " is not a CameraItem."));
        this.player = playerInventory.field_7546;
        this.cameraSlotIndex = cameraSlotIndex;
        this.camera = new ItemAndStack(cameraStack);
        class_1277 container = new class_1277((class_1799[])CameraAttachmentsMenu.getCameraAttachments(this.camera).toArray(class_1799[]::new)){

            public int method_5444() {
                return 1;
            }
        };
        container.method_5489(new class_1265(){

            public void method_5453(class_1263 container) {
                for (int slotId = 0; slotId < container.method_5439(); ++slotId) {
                    AttachmentType attachmentType = CameraAttachmentsMenu.this.camera.getItem().getAttachmentTypeForSlot(CameraAttachmentsMenu.this.camera.getStack(), slotId).orElseThrow();
                    CameraAttachmentsMenu.this.camera.getItem().setAttachment(CameraAttachmentsMenu.this.camera.getStack(), attachmentType, container.method_5438(slotId));
                    if (CameraAttachmentsMenu.this.player.method_37908().method_8608() || !CameraAttachmentsMenu.this.player.method_7337()) continue;
                    CameraAttachmentsMenu.this.player.method_31548().method_5447(cameraSlotIndex, CameraAttachmentsMenu.this.camera.getStack());
                }
            }
        });
        this.attachmentSlotsCount = this.addAttachmentSlots((class_1263)container);
        this.addPlayerSlots(playerInventory);
    }

    public ItemAndStack<CameraItem> getCamera() {
        return this.camera;
    }

    public void method_7610(int stateId, List<class_1799> items, class_1799 carried) {
        this.clientContentsInitialized = false;
        super.method_7610(stateId, items, carried);
        this.clientContentsInitialized = true;
    }

    protected int addAttachmentSlots(class_1263 container) {
        int[][] slots;
        int attachmentSlots = 0;
        for (int[] slot : slots = new int[][]{{CameraItem.FILM_ATTACHMENT.slot(), 13, 42, 1}, {CameraItem.FLASH_ATTACHMENT.slot(), 147, 15, 1}, {CameraItem.LENS_ATTACHMENT.slot(), 147, 43, 1}, {CameraItem.FILTER_ATTACHMENT.slot(), 147, 71, 1}}) {
            Optional<AttachmentType> attachment = this.camera.getItem().getAttachmentTypeForSlot(this.camera.getStack(), slot[0]);
            if (!attachment.isPresent()) continue;
            this.method_7621(new FilteredSlot(container, slot[0], slot[1], slot[2], slot[3], this::onItemInSlotChanged, attachment.get().itemPredicate()));
            ++attachmentSlots;
        }
        return attachmentSlots;
    }

    protected void addPlayerSlots(class_1661 playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new class_1735((class_1263)playerInventory, column + row * 9 + 9, column * 18 + 8, 103 + row * 18){

                    public boolean method_7674(@NotNull class_1657 player) {
                        return super.method_7674(player) && this.method_34266() != CameraAttachmentsMenu.this.cameraSlotIndex;
                    }

                    public boolean method_7682() {
                        return this.method_34266() != CameraAttachmentsMenu.this.cameraSlotIndex;
                    }

                    public boolean method_51306() {
                        return this.method_34266() != CameraAttachmentsMenu.this.cameraSlotIndex;
                    }
                });
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            int finalSlot = slot;
            this.method_7621(new class_1735((class_1263)playerInventory, finalSlot, slot * 18 + 8, 161){

                public boolean method_7674(@NotNull class_1657 player) {
                    return super.method_7674(player) && this.method_34266() != CameraAttachmentsMenu.this.cameraSlotIndex;
                }

                public boolean method_7682() {
                    return this.method_34266() != CameraAttachmentsMenu.this.cameraSlotIndex;
                }

                public boolean method_51306() {
                    return this.method_34266() != CameraAttachmentsMenu.this.cameraSlotIndex;
                }
            });
        }
    }

    protected void onItemInSlotChanged(FilteredSlot.SlotChangedArgs args) {
        int slotId = args.slot().getSlotId();
        class_1799 newStack = args.newStack();
        this.camera.getItem().getAttachmentTypeForSlot(this.camera.getStack(), slotId).ifPresent(type -> {
            this.camera.getItem().setAttachment(this.camera.getStack(), (AttachmentType)type, newStack);
            if (this.player.method_37908().method_8608() && this.clientContentsInitialized) {
                type.sound().playOnePerPlayer(this.player, newStack.method_7960());
            }
            if (!this.player.method_37908().method_8608() && this.player.method_7337()) {
                this.player.method_31548().method_5447(this.cameraSlotIndex, this.camera.getStack());
            }
        });
    }

    private static class_2371<class_1799> getCameraAttachments(ItemAndStack<CameraItem> camera) {
        class_2371 items = class_2371.method_10211();
        List<AttachmentType> attachmentTypes = camera.getItem().getAttachmentTypes(camera.getStack());
        for (AttachmentType attachmentType : attachmentTypes) {
            items.add((Object)camera.getItem().getAttachment(camera.getStack(), attachmentType).orElse(class_1799.field_8037));
        }
        return items;
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int slotIndex) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 clickedSlot = (class_1735)this.field_7761.get(slotIndex);
        if (clickedSlot.method_7681()) {
            class_1799 slotStack = clickedSlot.method_7677();
            itemstack = slotStack.method_7972();
            if (slotIndex < this.attachmentSlotsCount ? !this.method_7616(slotStack, this.attachmentSlotsCount, this.field_7761.size(), true) : !this.method_7616(slotStack, 0, this.attachmentSlotsCount, false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                clickedSlot.method_7673(class_1799.field_8037);
            } else {
                clickedSlot.method_7668();
            }
        }
        return itemstack;
    }

    protected boolean method_7616(class_1799 movedStack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean hasRemainder = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (movedStack.method_7946()) {
            while (!movedStack.method_7960() && !(reverseDirection ? i < startIndex : i >= endIndex)) {
                class_1735 slot = (class_1735)this.field_7761.get(i);
                class_1799 slotStack = slot.method_7677();
                if (!slotStack.method_7960() && class_1799.method_31577((class_1799)movedStack, (class_1799)slotStack)) {
                    int maxSize;
                    int j = slotStack.method_7947() + movedStack.method_7947();
                    if (j <= (maxSize = Math.min(slot.method_7675(), movedStack.method_7914()))) {
                        movedStack.method_7939(0);
                        slotStack.method_7939(j);
                        slot.method_7668();
                        hasRemainder = true;
                    } else if (slotStack.method_7947() < maxSize) {
                        movedStack.method_7934(maxSize - slotStack.method_7947());
                        slotStack.method_7939(maxSize);
                        slot.method_7668();
                        hasRemainder = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!movedStack.method_7960()) {
            int n = i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(reverseDirection ? i < startIndex : i >= endIndex)) {
                class_1735 slot1 = (class_1735)this.field_7761.get(i);
                class_1799 movedStack1 = slot1.method_7677();
                if (movedStack1.method_7960() && slot1.method_7680(movedStack)) {
                    if (movedStack.method_7947() > slot1.method_7675()) {
                        slot1.method_48931(movedStack.method_7971(slot1.method_7675()));
                    } else {
                        slot1.method_48931(movedStack.method_7971(movedStack.method_7947()));
                    }
                    slot1.method_7668();
                    hasRemainder = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return hasRemainder;
    }

    public boolean method_7604(class_1657 player, int id) {
        if (Supporters.hasAccessToGoldenSkin(player.method_5667())) {
            if (id == 100) {
                this.getCamera().apply((i, s) -> s.method_7948().method_10551("GoldenCamera"));
                this.method_7623();
                return true;
            }
            if (id == 101) {
                this.getCamera().apply((i, s) -> s.method_7948().method_10556("GoldenCamera", true));
                this.method_7623();
                return true;
            }
        }
        return false;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        player.field_7498.method_34257();
    }

    public boolean method_7597(@NotNull class_1657 player) {
        return class_1799.method_31577((class_1799)player.method_31548().method_5438(this.cameraSlotIndex), (class_1799)this.camera.getStack());
    }

    public static CameraAttachmentsMenu fromBuffer(int containerId, class_1661 playerInventory, class_2540 buffer) {
        return new CameraAttachmentsMenu(containerId, playerInventory, buffer.readInt());
    }
}

