/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.camera.button;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.camera.CameraClient;
import io.github.mortuusars.exposure.camera.infrastructure.FlashMode;
import io.github.mortuusars.exposure.gui.screen.camera.button.CycleButton;
import io.github.mortuusars.exposure.item.CameraItem;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class FlashModeButton
extends CycleButton {
    private final List<FlashMode> flashModes = Arrays.stream(FlashMode.values()).toList();

    public FlashModeButton(class_437 screen, int x, int y, int width, int height, int u, int v, class_2960 texture) {
        super(screen, x, y, width, height, u, v, height, texture);
        Camera<?> camera = CameraClient.getCamera().orElseThrow();
        FlashMode guide = ((CameraItem)((Object)camera.get().getItem())).getFlashMode(camera.get().getStack());
        int currentGuideIndex = 0;
        for (int i = 0; i < this.flashModes.size(); ++i) {
            if (!this.flashModes.get(i).getId().equals(guide.getId())) continue;
            currentGuideIndex = i;
            break;
        }
        this.setupButtonElements(this.flashModes.size(), currentGuideIndex);
    }

    public void method_25354(class_1144 handler) {
        handler.method_4873((class_1113)class_1109.method_4757((class_3414)Exposure.SoundEvents.CAMERA_BUTTON_CLICK.get(), (float)(Objects.requireNonNull(class_310.method_1551().field_1687).field_9229.method_43057() * 0.15f + 0.93f), (float)0.7f));
    }

    @Override
    public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_25291(Exposure.resource("textures/gui/viewfinder/icon/flash_mode/" + this.flashModes.get(this.currentIndex).getId() + ".png"), this.method_46426(), this.method_46427() + 4, 0, 0.0f, 0.0f, 15, 14, 15, 14);
    }

    @Override
    public void renderToolTip(@NotNull class_332 pGuiGraphics, int mouseX, int mouseY) {
        pGuiGraphics.method_51437(class_310.method_1551().field_1772, List.of(class_2561.method_43471((String)"gui.exposure.viewfinder.flash_mode.tooltip"), ((class_5250)this.method_25369()).method_27692(class_124.field_1080)), Optional.empty(), mouseX, mouseY);
    }

    @NotNull
    public class_2561 method_25369() {
        return this.flashModes.get(this.currentIndex).translate();
    }

    @Override
    protected void onCycle() {
        CameraClient.setFlashMode(this.flashModes.get(this.currentIndex));
    }
}

