/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data.filter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.data.filter.Filter;
import io.github.mortuusars.exposure.util.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class Filters {
    private static final Map<class_2960, Filter> filters = new HashMap<class_2960, Filter>();

    public static Map<class_2960, Filter> getFilters() {
        return filters;
    }

    public static Optional<Filter> of(class_1799 stack) {
        for (Filter filter : filters.values()) {
            if (!filter.matches(stack)) continue;
            return Optional.of(filter);
        }
        return Optional.empty();
    }

    public static Optional<class_2960> getShaderOf(class_1799 stack) {
        return Filters.of(stack).map(Filter::getShader);
    }

    public static class Loader
    extends class_4309 {
        public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        public static final String DIRECTORY = "filters";

        public Loader() {
            super(GSON, DIRECTORY);
        }

        protected void apply(Map<class_2960, JsonElement> content, class_3300 resourceManager, class_3695 profiler) {
            filters.clear();
            Exposure.LOGGER.info("Loading exposure filters:");
            for (Map.Entry<class_2960, JsonElement> entry : content.entrySet()) {
                class_2960 key = entry.getKey();
                if (!key.method_12836().equals("exposure")) continue;
                JsonObject jsonObject = entry.getValue().getAsJsonObject();
                this.deserializeFilter(key, jsonObject).ifPresent(filter -> {
                    filters.put(key, (Filter)filter);
                    Exposure.LOGGER.info("Filter [" + String.valueOf(key) + ", " + String.valueOf(filter.getShader()) + "] added.");
                });
            }
            if (filters.isEmpty()) {
                Exposure.LOGGER.info("No filters have been loaded.");
            }
        }

        private Optional<Filter> deserializeFilter(class_2960 key, JsonObject jsonObject) {
            try {
                class_1856 ingredient = class_1856.method_52177((JsonElement)jsonObject.get("item"));
                if (ingredient.method_8103()) {
                    Exposure.LOGGER.error("Filter '{}' was not loaded: ingredient cannot be empty.", (Object)key);
                    return Optional.empty();
                }
                class_2960 shader = new class_2960(jsonObject.get("shader").getAsString());
                class_2960 attachmentTexture = Filter.DEFAULT_GLASS_TEXTURE;
                if (jsonObject.has("attachment_texture")) {
                    attachmentTexture = new class_2960(jsonObject.get("attachment_texture").getAsString());
                }
                int tintColor = 0xFFFFFF;
                if (jsonObject.has("tint_color")) {
                    String hexString = jsonObject.get("tint_color").getAsString();
                    tintColor = Color.getRGBFromHex(hexString);
                }
                return Optional.of(new Filter(ingredient, shader, attachmentTexture, tintColor));
            }
            catch (Exception e) {
                Exposure.LOGGER.error("Filter '{}' was not loaded: {}", (Object)key, (Object)e);
                return Optional.empty();
            }
        }
    }
}

