/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.command.exposure;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.command.argument.ExposureLookArgument;
import io.github.mortuusars.exposure.command.argument.ExposureSizeArgument;
import io.github.mortuusars.exposure.command.suggestion.ExposureIdSuggestionProvider;
import io.github.mortuusars.exposure.data.ExposureLook;
import io.github.mortuusars.exposure.data.ExposureSize;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.data.storage.ServersideExposureExporter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ExportCommand {
    public static LiteralArgumentBuilder<class_2168> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"export").requires(stack -> stack.method_9259(3))).then(ExportCommand.id())).then(ExportCommand.all());
    }

    private static ArgumentBuilder<class_2168, ?> id() {
        return class_2170.method_9247((String)"id").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ExposureIdSuggestionProvider()).executes(context -> ExportCommand.exportExposures((class_2168)context.getSource(), List.of(StringArgumentType.getString((CommandContext)context, (String)"id")), ExposureSize.X1, ExposureLook.REGULAR))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"size", (ArgumentType)new ExposureSizeArgument()).executes(context -> ExportCommand.exportExposures((class_2168)context.getSource(), List.of(StringArgumentType.getString((CommandContext)context, (String)"id")), ExposureSizeArgument.getSize(context, "size"), ExposureLook.REGULAR))).then(class_2170.method_9244((String)"look", (ArgumentType)new ExposureLookArgument()).executes(context -> ExportCommand.exportExposures((class_2168)context.getSource(), List.of(StringArgumentType.getString((CommandContext)context, (String)"id")), ExposureSizeArgument.getSize(context, "size"), ExposureLookArgument.getLook(context, "look"))))));
    }

    private static ArgumentBuilder<class_2168, ?> all() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"all").executes(context -> ExportCommand.exportAll((class_2168)context.getSource(), ExposureSize.X1, ExposureLook.REGULAR))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"size", (ArgumentType)new ExposureSizeArgument()).executes(context -> ExportCommand.exportAll((class_2168)context.getSource(), ExposureSizeArgument.getSize(context, "size"), ExposureLook.REGULAR))).then(class_2170.method_9244((String)"look", (ArgumentType)new ExposureLookArgument()).executes(context -> ExportCommand.exportAll((class_2168)context.getSource(), ExposureSizeArgument.getSize(context, "size"), ExposureLookArgument.getLook(context, "look")))));
    }

    private static int exportAll(class_2168 source, ExposureSize size, ExposureLook look) {
        List<String> ids = ExposureServer.getExposureStorage().getAllIds();
        return ExportCommand.exportExposures(source, ids, size, look);
    }

    private static int exportExposures(class_2168 stack, List<String> exposureIds, ExposureSize size, ExposureLook look) {
        int savedCount = 0;
        File folder = stack.method_9211().method_27050(class_5218.field_24188).resolve("exposures").toFile();
        boolean ignored = folder.mkdirs();
        for (String id : exposureIds) {
            Optional<ExposureSavedData> data = ExposureServer.getExposureStorage().getOrQuery(id);
            if (data.isEmpty()) {
                stack.method_9213((class_2561)class_2561.method_43469((String)"command.exposure.export.failure.not_found", (Object[])new Object[]{id}));
                continue;
            }
            ExposureSavedData exposureSavedData = data.get();
            String name = id + look.getIdSuffix();
            boolean saved = ((ServersideExposureExporter)((ServersideExposureExporter)((ServersideExposureExporter)new ServersideExposureExporter(name).withFolder(folder.getAbsolutePath().replace("\\.\\", "\\").replace("/./", "/"))).withModifier(look.getModifier())).withSize(size)).save(exposureSavedData);
            if (saved) {
                stack.method_9226(() -> class_2561.method_43469((String)"command.exposure.export.success.saved_exposure_id", (Object[])new Object[]{id}), true);
            }
            ++savedCount;
        }
        if (savedCount > 0) {
            String folderPath = ExportCommand.getFolderPath(folder);
            class_5250 folderComponent = class_2561.method_43470((String)folderPath).method_27692(class_124.field_1073).method_27694(arg -> arg.method_10958(new class_2558(class_2558.class_2559.field_11746, folderPath)));
            class_5250 component = class_2561.method_43469((String)"command.exposure.export.success.result", (Object[])new Object[]{savedCount, folderComponent});
            stack.method_9226(() -> ExportCommand.lambda$exportExposures$9((class_2561)component), true);
        } else {
            stack.method_9213((class_2561)class_2561.method_43471((String)"command.exposure.export.failure.none_saved"));
        }
        return 0;
    }

    @NotNull
    private static String getFolderPath(File folder) {
        String folderPath;
        try {
            folderPath = folder.getCanonicalPath();
        }
        catch (IOException e) {
            Exposure.LOGGER.error(e.toString());
            folderPath = folder.getAbsolutePath();
        }
        return folderPath;
    }

    private static /* synthetic */ class_2561 lambda$exportExposures$9(class_2561 component) {
        return component;
    }
}

