/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.glowingtorchflower.config;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.text.StringSubstitutor;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import xyz.nikitacartes.glowingtorchflower.config.ConfigTemplate;

@ConfigSerializable
public class MainConfigV1
extends ConfigTemplate {
    public int torchflowerBrightness = 12;
    public int torchflowerPotBrightness = 14;
    public int torchflowerStage1Brightness = 3;
    public int torchflowerStage2Brightness = 7;
    public String configVersion = "1";

    public MainConfigV1() {
        super("main.conf");
    }

    public static MainConfigV1 load() {
        MainConfigV1 config = MainConfigV1.loadConfig(MainConfigV1.class, "main.conf");
        if (config == null) {
            config = new MainConfigV1();
            config.save();
        }
        return config;
    }

    @Override
    protected String handleTemplate() throws IOException {
        HashMap<String, String> configValues = new HashMap<String, String>();
        configValues.put("torchflowerBrightness", this.wrapIfNecessary(this.torchflowerBrightness));
        configValues.put("torchflowerPotBrightness", this.wrapIfNecessary(this.torchflowerPotBrightness));
        configValues.put("torchflowerStage1Brightness", this.wrapIfNecessary(this.torchflowerStage1Brightness));
        configValues.put("torchflowerStage2Brightness", this.wrapIfNecessary(this.torchflowerStage2Brightness));
        configValues.put("configVersion", this.wrapIfNecessary(this.configVersion));
        String configTemplate = Resources.toString((URL)Resources.getResource((String)("xyz/nikitacartes/glowingtorchflower/config/" + this.configFilePath)), (Charset)StandardCharsets.UTF_8);
        return new StringSubstitutor(configValues).replace(configTemplate);
    }
}

