/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.pets;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_14;
import net.minecraft.class_1405;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1548;
import net.minecraft.class_1571;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3321;
import net.minecraft.class_3417;
import net.minecraft.class_4051;
import net.minecraft.class_4215;
import net.minecraft.class_4538;
import net.minecraft.class_6025;
import net.minecraft.class_7;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModItems;
import tech.alexnijjar.endermanoverhaul.common.registry.ModParticleTypes;

public abstract class BasePetEnderman
extends BaseEnderman
implements GeoEntity,
class_6025 {
    protected static final class_2940<Optional<UUID>> DATA_OWNERUUID_ID = class_2945.method_12791(BasePetEnderman.class, (class_2941)class_2943.field_13313);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private EndermanHurtByTargetGoal hurtByTargetGoal;

    public BasePetEnderman(class_1299<? extends BaseEnderman> entityType, class_1937 level) {
        super(entityType, level);
    }

    public BasePetEnderman(class_1299<? extends BaseEnderman> entityType, class_1937 level, class_1657 owner) {
        super(entityType, level);
        this.setOwnerUUID(owner.method_5667());
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_OWNERUUID_ID, Optional.empty());
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 5, state -> {
            if (state.isMoving()) {
                state.getController().setAnimation(this.method_7028() ? ConstantAnimations.RUN : ConstantAnimations.WALK);
            } else {
                state.getController().setAnimation(ConstantAnimations.IDLE);
            }
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attack_controller", 5, state -> {
            if (!this.playArmSwingAnimWhenAttacking()) {
                return PlayState.STOP;
            }
            if (this.method_6055(state.getPartialTick()) == 0.0f) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ATTACK);
            return PlayState.CONTINUE;
        })});
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(6, (class_1352)new EndermanFollowOwnerGoal(1.0, 10.0f, 2.0f, false));
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new EndermanOwnerHurtByTargetGoal());
        this.field_6185.method_6277(2, (class_1352)new EndermanOwnerHurtTargetGoal());
        this.hurtByTargetGoal = new EndermanHurtByTargetGoal(new Class[0]);
        this.field_6185.method_6277(3, (class_1352)this.hurtByTargetGoal);
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        if (this.method_6139() != null) {
            compound.method_25927("Owner", this.method_6139());
        }
    }

    public void method_5749(@NotNull class_2487 compound) {
        UUID uuid;
        super.method_5749(compound);
        if (compound.method_25928("Owner")) {
            uuid = compound.method_25926("Owner");
        } else {
            String string = compound.method_10558("Owner");
            uuid = class_3321.method_14546((MinecraftServer)Objects.requireNonNull(this.method_5682()), (String)string);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
    }

    @Nullable
    public UUID method_6139() {
        return ((Optional)this.field_6011.method_12789(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.field_6011.method_12778(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    public boolean method_5931(@NotNull class_1657 player) {
        return !this.method_5934();
    }

    @Override
    public void method_5773() {
        class_1657 p;
        BasePetEnderman e;
        class_1309 class_13092;
        super.method_5773();
        if (!this.method_37908().method_8608() && (class_13092 = this.method_5968()) instanceof BasePetEnderman && Objects.equals((e = (BasePetEnderman)class_13092).method_6139(), this.method_6139())) {
            this.method_5980(null);
            this.method_6015(null);
        }
        if (!this.method_37908().method_8608() && (class_13092 = this.method_5968()) instanceof class_1657 && (p = (class_1657)class_13092).method_5667().equals(this.method_6139())) {
            this.method_5980(null);
            this.method_6015(null);
        }
    }

    @Override
    @Nullable
    public class_2394 getCustomParticles() {
        return (class_2394)ModParticleTypes.FRIENDERMAN.get();
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().method_8608() && this.method_5805() && this.field_6012 % 2000 == 0) {
            this.method_6025(1.0f);
        }
    }

    public boolean wantsToAttack(class_1309 target) {
        if (target instanceof class_1548) {
            return false;
        }
        if (target instanceof class_1571) {
            return false;
        }
        if (target instanceof BasePetEnderman) {
            BasePetEnderman otherPet = (BasePetEnderman)target;
            return !Objects.equals(otherPet.method_6139(), this.method_6139());
        }
        if (target instanceof class_1657) {
            class_1657 player = (class_1657)target;
            return !player.method_5667().equals(this.method_6139());
        }
        return true;
    }

    public void method_6078(@NotNull class_1282 damageSource) {
        if (!this.method_37908().field_9236 && this.method_37908().method_8450().method_8355(class_1928.field_19398) && this.method_35057() instanceof class_3222) {
            this.method_35057().method_43496(this.method_6066().method_5548());
        }
        super.method_6078(damageSource);
    }

    @Override
    public boolean isProvokedByEyeContact() {
        return false;
    }

    @Override
    public boolean canOpenMouth() {
        return false;
    }

    @NotNull
    protected class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (!player.method_5667().equals(this.method_6139())) {
            return class_1269.field_5811;
        }
        if (!this.method_37908().method_8608()) {
            class_2487 entityTag = new class_2487();
            class_2487 petTag = new class_2487();
            this.method_5647(petTag);
            class_1799 pearl = ((class_1792)ModItems.ANCIENT_PEARL.get()).method_7854();
            entityTag.method_10566("PetEntity", (class_2520)petTag);
            entityTag.method_10582("PetType", class_7923.field_41177.method_10221((Object)this.method_5864()).method_12832());
            pearl.method_7980(entityTag);
            class_4215.method_19949((class_1309)this, (class_1799)pearl, (class_243)this.method_19538());
            this.method_43077(class_3417.field_14879);
            this.method_31472();
            return class_1269.field_5812;
        }
        for (int i = 0; i < this.getParticleCount(); ++i) {
            this.method_37908().method_8406((class_2394)class_2398.field_11214, this.method_23322(0.5), this.method_23319() - 0.25, this.method_23325(0.5), (this.field_5974.method_43058() - 0.5) * 2.0, -this.field_5974.method_43058(), (this.field_5974.method_43058() - 0.5) * 2.0);
        }
        return class_1269.field_5812;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    protected boolean method_23734() {
        return false;
    }

    public class EndermanFollowOwnerGoal
    extends class_1352 {
        private class_1309 owner;
        private final class_4538 level;
        private final double speedModifier;
        private final class_1408 navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private final float startDistance;
        private float oldWaterCost;
        private final boolean canFly;

        public EndermanFollowOwnerGoal(double d, float f, float g, boolean bl) {
            this.level = BasePetEnderman.this.method_37908();
            this.speedModifier = d;
            this.navigation = BasePetEnderman.this.method_5942();
            this.startDistance = f;
            this.stopDistance = g;
            this.canFly = bl;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
            if (!(BasePetEnderman.this.method_5942() instanceof class_1409) && !(BasePetEnderman.this.method_5942() instanceof class_1407)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean method_6264() {
            class_1309 livingEntity = BasePetEnderman.this.method_35057();
            if (livingEntity == null) {
                return false;
            }
            if (livingEntity.method_7325()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            if (BasePetEnderman.this.method_5858((class_1297)livingEntity) < (double)(this.startDistance * this.startDistance)) {
                return false;
            }
            this.owner = livingEntity;
            return true;
        }

        public boolean method_6266() {
            if (this.navigation.method_6357()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            return !(BasePetEnderman.this.method_5858((class_1297)this.owner) <= (double)(this.stopDistance * this.stopDistance));
        }

        private boolean unableToMove() {
            return BasePetEnderman.this.method_5765() || BasePetEnderman.this.method_5934();
        }

        public void method_6269() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = BasePetEnderman.this.method_5944(class_7.field_18);
            BasePetEnderman.this.method_5941(class_7.field_18, 0.0f);
        }

        public void method_6270() {
            this.owner = null;
            this.navigation.method_6340();
            BasePetEnderman.this.method_5941(class_7.field_18, this.oldWaterCost);
        }

        public void method_6268() {
            BasePetEnderman.this.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)BasePetEnderman.this.method_5978());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.method_38847(10);
                if (BasePetEnderman.this.method_5858((class_1297)this.owner) >= Math.pow(20.0, 2.0)) {
                    this.teleportToOwner();
                } else {
                    this.navigation.method_6335((class_1297)this.owner, this.speedModifier);
                }
            }
        }

        private void teleportToOwner() {
            class_2338 blockPos = this.owner.method_24515();
            for (int i = 0; i < 10; ++i) {
                int j = this.randomIntInclusive(-3, 3);
                int k = this.randomIntInclusive(-1, 1);
                int l = this.randomIntInclusive(-3, 3);
                boolean teleported = this.maybeTeleportTo(blockPos.method_10263() + j, blockPos.method_10264() + k, blockPos.method_10260() + l);
                if (!teleported) continue;
                return;
            }
        }

        private boolean maybeTeleportTo(int x, int y, int z) {
            if (Math.abs((double)x - this.owner.method_23317()) < 2.0 && Math.abs((double)z - this.owner.method_23321()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new class_2338(x, y, z))) {
                return false;
            }
            BasePetEnderman.this.method_5808((double)x + 0.5, y, (double)z + 0.5, BasePetEnderman.this.method_36454(), BasePetEnderman.this.method_36455());
            this.navigation.method_6340();
            return true;
        }

        private boolean canTeleportTo(class_2338 pos) {
            class_7 blockPathTypes = class_14.method_23476((class_1922)this.level, (class_2338.class_2339)pos.method_25503());
            if (blockPathTypes != class_7.field_12) {
                return false;
            }
            class_2680 blockState = this.level.method_8320(pos.method_10074());
            if (!this.canFly && blockState.method_26204() instanceof class_2397) {
                return false;
            }
            class_2338 blockPos = pos.method_10059((class_2382)BasePetEnderman.this.method_24515());
            return this.level.method_8587((class_1297)BasePetEnderman.this, BasePetEnderman.this.method_5829().method_996(blockPos));
        }

        private int randomIntInclusive(int min, int max) {
            return BasePetEnderman.this.method_6051().method_43048(max - min + 1) + min;
        }
    }

    public class EndermanOwnerHurtByTargetGoal
    extends class_1405 {
        private class_1309 ownerLastHurtBy;
        private int timestamp;

        public EndermanOwnerHurtByTargetGoal() {
            super((class_1308)BasePetEnderman.this, false);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            class_1309 livingEntity = BasePetEnderman.this.method_35057();
            if (livingEntity == null) {
                return false;
            }
            this.ownerLastHurtBy = livingEntity.method_6065();
            int i = livingEntity.method_6117();
            return i != this.timestamp && this.method_6328(this.ownerLastHurtBy, class_4051.field_18092) && BasePetEnderman.this.wantsToAttack(this.ownerLastHurtBy);
        }

        public void method_6269() {
            this.field_6660.method_5980(this.ownerLastHurtBy);
            class_1309 livingEntity = BasePetEnderman.this.method_35057();
            if (livingEntity != null) {
                this.timestamp = livingEntity.method_6117();
            }
            super.method_6269();
        }
    }

    public class EndermanOwnerHurtTargetGoal
    extends class_1405 {
        private class_1309 ownerLastHurt;
        private int timestamp;

        public EndermanOwnerHurtTargetGoal() {
            super((class_1308)BasePetEnderman.this, false);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            class_1309 livingEntity = BasePetEnderman.this.method_35057();
            if (livingEntity == null) {
                return false;
            }
            this.ownerLastHurt = livingEntity.method_6052();
            int i = livingEntity.method_6083();
            return i != this.timestamp && this.method_6328(this.ownerLastHurt, class_4051.field_18092) && BasePetEnderman.this.wantsToAttack(this.ownerLastHurt);
        }

        public void method_6269() {
            this.field_6660.method_5980(this.ownerLastHurt);
            class_1309 livingEntity = BasePetEnderman.this.method_35057();
            if (livingEntity != null) {
                this.timestamp = livingEntity.method_6083();
            }
            super.method_6269();
        }
    }

    public class EndermanHurtByTargetGoal
    extends class_1405 {
        private static final class_4051 HURT_BY_TARGETING = class_4051.method_36625().method_36627().method_18424();
        private int timestamp;
        private final Class<?>[] toIgnoreDamage;

        public EndermanHurtByTargetGoal(Class<?> ... classes) {
            super((class_1308)BasePetEnderman.this, true);
            this.toIgnoreDamage = classes;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            int i = BasePetEnderman.this.method_6117();
            class_1309 livingEntity = BasePetEnderman.this.method_6065();
            if (i != this.timestamp && livingEntity != null) {
                if (livingEntity.method_5864() == class_1299.field_6097 && BasePetEnderman.this.method_37908().method_8450().method_8355(class_1928.field_25402)) {
                    return false;
                }
                if (!BasePetEnderman.this.wantsToAttack(livingEntity)) {
                    return false;
                }
                for (Class<?> clazz : this.toIgnoreDamage) {
                    if (!clazz.isAssignableFrom(livingEntity.getClass())) continue;
                    return false;
                }
                return this.method_6328(livingEntity, HURT_BY_TARGETING);
            }
            return false;
        }

        public void method_6269() {
            BasePetEnderman.this.method_5980(BasePetEnderman.this.method_6065());
            this.field_6664 = BasePetEnderman.this.method_5968();
            this.timestamp = BasePetEnderman.this.method_6117();
            this.field_6657 = 300;
            this.alertOthers();
            super.method_6269();
        }

        public void notifyStart() {
            BasePetEnderman.this.method_5980(BasePetEnderman.this.method_6065());
            this.field_6664 = BasePetEnderman.this.method_5968();
            this.timestamp = BasePetEnderman.this.method_6117();
            this.field_6657 = 300;
            super.method_6269();
        }

        public void alertOthers() {
            class_1657 p;
            UUID owner = BasePetEnderman.this.method_6139();
            if (owner == null) {
                return;
            }
            class_1309 targetMob = BasePetEnderman.this.method_5968();
            if (targetMob instanceof class_1657 && (p = (class_1657)targetMob).method_5667().equals(owner)) {
                return;
            }
            if (targetMob == null) {
                return;
            }
            class_238 aabb = class_238.method_29968((class_243)BasePetEnderman.this.method_19538()).method_1014(30.0);
            List pets = BasePetEnderman.this.method_37908().method_8390(BasePetEnderman.class, aabb, class_1301.field_6155);
            pets.remove((Object)BasePetEnderman.this);
            List<BasePetEnderman> ownedPets = pets.stream().filter(pet -> owner.equals(pet.method_6139())).toList();
            if (ownedPets.size() <= 1) {
                return;
            }
            ArrayList<BasePetEnderman> targets = new ArrayList<BasePetEnderman>();
            if (targetMob instanceof BasePetEnderman) {
                BasePetEnderman target = (BasePetEnderman)targetMob;
                UUID targetOwner = target.method_6139();
                if (targetOwner == null) {
                    return;
                }
                targets.addAll(pets.stream().filter(pet -> targetOwner.equals(pet.method_6139())).toList());
                class_1657 player = BasePetEnderman.this.method_37908().method_18470(targetOwner);
                if (player != null && player.method_5739((class_1297)BasePetEnderman.this) < 30.0f) {
                    targets.add((BasePetEnderman)player);
                }
                if (targets.isEmpty()) {
                    return;
                }
            } else if (targetMob instanceof class_1657) {
                class_1657 player = (class_1657)targetMob;
                targets.add((BasePetEnderman)player);
                targets.addAll(pets.stream().filter(pet -> player.method_5667().equals(pet.method_6139())).toList());
            } else {
                class_238 aabb2 = class_238.method_29968((class_243)BasePetEnderman.this.method_19538()).method_1014(20.0);
                targets.addAll(BasePetEnderman.this.method_37908().method_8390(targetMob.getClass(), aabb2, class_1301.field_6155));
            }
            for (BasePetEnderman pet2 : ownedPets) {
                class_1309 closestTarget = targets.stream().min(Comparator.comparingDouble(arg_0 -> ((BasePetEnderman)pet2).method_5858(arg_0))).orElse(null);
                pet2.method_6015(closestTarget);
                pet2.hurtByTargetGoal.notifyStart();
            }
        }
    }
}

