/*
 * Decompiled with CFR 0.152.
 */
package com.soradgaming.simplehudenhanced.hud;

import com.soradgaming.simplehudenhanced.cache.EquipmentCache;
import com.soradgaming.simplehudenhanced.cache.MovementCache;
import com.soradgaming.simplehudenhanced.cache.StatusCache;
import com.soradgaming.simplehudenhanced.config.SimpleHudEnhancedConfig;
import com.soradgaming.simplehudenhanced.config.TextAlignment;
import com.soradgaming.simplehudenhanced.hud.Equipment;
import com.soradgaming.simplehudenhanced.hud.GameInfo;
import com.soradgaming.simplehudenhanced.hud.Movement;
import com.soradgaming.simplehudenhanced.hud.ScreenManager;
import com.soradgaming.simplehudenhanced.utli.Utilities;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Logger;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class HUD {
    private static HUD instance;
    private final class_310 client;
    private final class_327 renderer;
    private final SimpleHudEnhancedConfig config;
    private EquipmentCache equipmentCache;
    private MovementCache movementCache;
    private StatusCache statusCache;
    public boolean sprintTimerRunning = false;
    public long sprintTimer = 3000L;

    private HUD(class_310 client, SimpleHudEnhancedConfig config) {
        this.client = client;
        this.renderer = client.field_1772;
        this.config = config;
    }

    public static void initialize(class_310 client, SimpleHudEnhancedConfig config) {
        if (instance == null) {
            Logger.getLogger(Utilities.getModName()).warning("New HUD instance created.");
        } else {
            Logger.getLogger(Utilities.getModName()).warning("HUD has already been initialized.");
            Logger.getLogger(Utilities.getModName()).warning("New HUD instance created. (Override)");
        }
        instance = new HUD(client, config);
        HUD.instance.equipmentCache = EquipmentCache.getInstance(config);
        HUD.instance.movementCache = MovementCache.getInstance();
        HUD.instance.statusCache = StatusCache.getInstance(config);
        HUD.instance.sprintTimer = config.paperDoll.paperDollTimeOut;
    }

    public static HUD getInstance() {
        if (instance == null) {
            Logger.getLogger(Utilities.getModName()).warning("HUD has not been initialized yet.");
            return null;
        }
        return instance;
    }

    public void drawHud(class_332 context) {
        if (!this.config.uiConfig.toggleSimpleHUDEnhanced) {
            return;
        }
        GameInfo GameInformation = new GameInfo(this.client, this.config);
        this.drawStatusElements(context, GameInformation);
        if (this.config.toggleEquipmentStatus) {
            Equipment equipment = new Equipment(context, this.config, this.equipmentCache);
            equipment.init();
        }
        if (this.config.toggleMovementStatus) {
            Movement movement = new Movement(context, this.config, this.movementCache);
            if (this.config.movementStatus.toggleMovementStatus) {
                movement.init(GameInformation);
            }
            if (this.sprintTimerRunning || !this.config.paperDoll.togglePaperDollTimer) {
                movement.drawPaperDoll(context);
            }
        }
        this.drawTime(context, this.statusCache.getSystemTime());
        context.method_51452();
    }

    public int getColor(String line, GameInfo GameInformation) {
        int colour = this.config.uiConfig.textColor;
        if (Objects.equals(line, GameInformation.getFPS())) {
            String[] fps = line.split(" ");
            int fpsInt = Integer.parseInt(fps[0]);
            if (fpsInt < 15) {
                return 0xFF0000;
            }
            if (fpsInt < 30) {
                return -43691;
            }
            if (fpsInt < 45) {
                return -21931;
            }
            if (fpsInt < 60) {
                return -171;
            }
            return 65280;
        }
        return colour;
    }

    private void drawStatusElements(class_332 context, GameInfo gameInformation) {
        ArrayList<String> hudInfo = this.getStatusCache().getHudInfo();
        int Xcords = this.config.statusElements.Xcords;
        int Ycords = this.config.statusElements.Ycords;
        float Scale = (float)this.config.uiConfig.textScale / 100.0f;
        int longestString = 0;
        int BoxWidth = 0;
        for (String s : hudInfo) {
            if (s.length() <= longestString) continue;
            longestString = s.length();
            BoxWidth = this.renderer.method_1727(s);
        }
        Objects.requireNonNull(this.renderer);
        int lineHeight = 9;
        ScreenManager screenManager = new ScreenManager(this.client.method_22683().method_4486(), this.client.method_22683().method_4502());
        screenManager.setPadding(4);
        int xAxis = screenManager.calculateXAxis(Xcords, Scale, BoxWidth);
        int yAxis = screenManager.calculateYAxis(lineHeight, hudInfo.size(), Ycords, Scale);
        screenManager.setScale(context, Scale);
        for (String line : hudInfo) {
            int offset = 0;
            if (this.config.uiConfig.textAlignment == TextAlignment.Right) {
                lineLength = this.renderer.method_1727(line);
                offset = BoxWidth - lineLength;
            } else if (this.config.uiConfig.textAlignment == TextAlignment.Center) {
                lineLength = this.renderer.method_1727(line);
                offset = (BoxWidth - lineLength) / 2;
            }
            int colour = this.config.uiConfig.textColor;
            if (this.config.statusElements.fps.toggleColourFPS) {
                colour = this.getColor(line, gameInformation);
            }
            if (this.config.uiConfig.textBackground) {
                context.method_25294(xAxis + offset - 1, yAxis - 1, xAxis + offset + this.renderer.method_1727(line), yAxis + lineHeight - 1, Integer.MIN_VALUE);
            }
            context.method_25303(this.renderer, line, xAxis + offset, yAxis, colour);
            yAxis += lineHeight;
        }
        screenManager.resetScale(context);
    }

    private void drawTime(class_332 context, String systemTime) {
        ScreenManager timeScreenManager = new ScreenManager(this.client.method_22683().method_4486(), this.client.method_22683().method_4502());
        timeScreenManager.setPadding(2);
        float timeScale = (float)this.config.statusElements.systemTime.textScale / 100.0f;
        int xAxisTime = timeScreenManager.calculateXAxis(100, timeScale, this.renderer.method_1727(systemTime));
        Objects.requireNonNull(this.renderer);
        int yAxisTime = timeScreenManager.calculateYAxis(9, 1, 100, timeScale);
        timeScreenManager.setScale(context, timeScale);
        if (this.config.statusElements.systemTime.textBackground) {
            int n = xAxisTime + this.renderer.method_1727(systemTime);
            Objects.requireNonNull(this.renderer);
            context.method_25294(xAxisTime - 1, yAxisTime - 1, n, yAxisTime + 9 - 1, Integer.MIN_VALUE);
        }
        context.method_25303(this.renderer, systemTime, xAxisTime, yAxisTime, this.config.uiConfig.textColor);
        timeScreenManager.resetScale(context);
    }

    public EquipmentCache getEquipmentCache() {
        return this.equipmentCache;
    }

    public MovementCache getMovementCache() {
        return this.movementCache;
    }

    public StatusCache getStatusCache() {
        return this.statusCache;
    }
}

