/*
 * Decompiled with CFR 0.152.
 */
package com.soradgaming.simplehudenhanced.hud;

import com.soradgaming.simplehudenhanced.config.SimpleHudEnhancedConfig;
import com.soradgaming.simplehudenhanced.utli.TpsTracker;
import com.soradgaming.simplehudenhanced.utli.Utilities;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;

public class GameInfo {
    private final class_310 client;
    private class_746 player;
    private final SimpleHudEnhancedConfig config;

    public GameInfo(class_310 client, SimpleHudEnhancedConfig config) {
        this.client = client;
        this.config = config;
        if (this.client.field_1724 != null) {
            this.player = this.client.field_1724;
        } else {
            Exception e = new Exception("Player is null");
            e.printStackTrace();
        }
    }

    public String getCords() {
        if (!this.config.statusElements.coordinates.toggleCoordinates) {
            return "";
        }
        return String.format("%d, %d, %d", this.player.method_24515().method_10263(), this.player.method_24515().method_10264(), this.player.method_24515().method_10260());
    }

    public String getBiome() {
        if (!this.config.statusElements.Biome.toggleBiome) {
            return "";
        }
        if (this.client.field_1687 == null) {
            return "";
        }
        return Utilities.getBiome(this.client.field_1687, this.player, this.config.statusElements.Biome.toggleBiomeLabel);
    }

    public String getDirection() {
        if (!this.config.statusElements.coordinates.toggleCoordinates || !this.config.statusElements.coordinates.toggleDirection) {
            return "";
        }
        if (this.config.statusElements.coordinates.toggleOffset) {
            return String.format(" (%s", Utilities.translatable("text.direction.simplehudenhanced." + this.player.method_5735().method_15434()).getString());
        }
        return String.format(" (%s)", Utilities.translatable("text.direction.simplehudenhanced." + this.player.method_5735().method_15434()).getString());
    }

    public String getNether() {
        if (!this.config.statusElements.coordinates.toggleCoordinates || !this.config.statusElements.coordinates.toggleNetherCoordinateConversion) {
            return "";
        }
        String coordsFormat = "X: %.0f, Z: %.0f";
        if (this.player.method_37908().method_27983().method_29177().toString().equals("minecraft:overworld")) {
            return Utilities.translatable("text.hud.simplehudenhanced.nether").getString() + ": " + String.format(coordsFormat, this.player.method_23317() / 8.0, this.player.method_23321() / 8.0);
        }
        if (this.player.method_37908().method_27983().method_29177().toString().equals("minecraft:the_nether")) {
            return Utilities.translatable("text.hud.simplehudenhanced.overworld").getString() + ": " + String.format(coordsFormat, this.player.method_23317() * 8.0, this.player.method_23321() * 8.0);
        }
        return "";
    }

    public String getChunkCords() {
        if (!this.config.statusElements.coordinates.toggleCoordinates || !this.config.statusElements.coordinates.toggleChunkCoordinates) {
            return "";
        }
        return Utilities.translatable("text.hud.simplehudenhanced.chunk").getString() + ": " + String.format("%d, %d, %d", this.player.method_24515().method_10263() >> 4, this.player.method_24515().method_10264() >> 4, this.player.method_24515().method_10260() >> 4);
    }

    public String getSubChunkCords() {
        if (!this.config.statusElements.coordinates.toggleCoordinates || !this.config.statusElements.coordinates.toggleSubChunkCoordinates) {
            return "";
        }
        return Utilities.translatable("text.hud.simplehudenhanced.subchunk").getString() + ": " + String.format("%d, %d, %d", this.player.method_24515().method_10263() & 0xF, this.player.method_24515().method_10264() & 0xF, this.player.method_24515().method_10260() & 0xF);
    }

    public String getOffset() {
        if (!this.config.statusElements.coordinates.toggleCoordinates || !this.config.statusElements.coordinates.toggleOffset) {
            return "";
        }
        class_2350 facing = this.player.method_5735();
        Object offset = "";
        if (facing.method_10148() > 0) {
            offset = (String)offset + "+X";
        } else if (facing.method_10148() < 0) {
            offset = (String)offset + "-X";
        }
        if (facing.method_10165() > 0) {
            offset = (String)offset + "+Z";
        } else if (facing.method_10165() < 0) {
            offset = (String)offset + "-Z";
        }
        offset = this.config.statusElements.coordinates.toggleDirection ? " " + (String)offset + ")" : " (" + (String)offset + ")";
        return offset;
    }

    public String getFPS() {
        if (!this.config.statusElements.fps.toggleFPS) {
            return "";
        }
        return Utilities.getFPS(this.client);
    }

    public String getChunkCount() {
        if (!this.config.statusElements.counters.chunkCount.toggleChunkCount) {
            return "";
        }
        if (this.client.field_1687 == null) {
            return "";
        }
        if (this.config.statusElements.counters.chunkCount.toggleTotal && this.config.statusElements.counters.chunkCount.toggleLoaded) {
            return String.format("C: %s", this.client.field_1687.method_2935().method_12122());
        }
        if (this.config.statusElements.counters.chunkCount.toggleLoaded) {
            return String.format("C: %s", this.client.field_1687.method_2935().method_14151());
        }
        if (this.config.statusElements.counters.chunkCount.toggleTotal) {
            return String.format("C: %s", this.client.field_1687.method_2935().method_12122().split(",")[0]);
        }
        return "";
    }

    public String getEntityCount() {
        if (!this.config.statusElements.counters.toggleEntityCount) {
            return "";
        }
        if (this.client.field_1687 != null) {
            return String.format("E: %d", this.client.field_1687.method_18120());
        }
        return "";
    }

    public String getParticleCount() {
        if (!this.config.statusElements.counters.toggleParticleCount) {
            return "";
        }
        return String.format("P: %s", this.client.field_1713.method_3052());
    }

    public String getSpeed() {
        if (!this.config.statusElements.playerSpeed.togglePlayerSpeed) {
            return "";
        }
        class_243 playerPosVec = this.player.method_19538();
        double travelledX = playerPosVec.field_1352 - this.player.field_6014;
        double travelledZ = playerPosVec.field_1350 - this.player.field_5969;
        double currentSpeed = class_3532.method_15355((float)((float)(travelledX * travelledX + travelledZ * travelledZ)));
        if (this.config.statusElements.playerSpeed.togglePlayerVerticalSpeed) {
            double currentVertSpeed = playerPosVec.field_1351 - this.player.field_6036;
            currentSpeed = class_3532.method_15355((float)((float)(currentSpeed * currentSpeed + currentVertSpeed * currentVertSpeed)));
        }
        return String.format("%.2f m/s", currentSpeed / (double)0.05f);
    }

    public String getLightLevel() {
        if (!this.config.statusElements.toggleLightLevel) {
            return "";
        }
        return String.format(Utilities.translatable("text.hud.simplehudenhanced.lightlevel").getString() + ": %d", this.player.method_37908().method_22339(this.player.method_24515()));
    }

    public String getTime() {
        if (!this.config.statusElements.gameTime.toggleGameTime) {
            return "";
        }
        long time = this.player.method_37908().method_8532();
        if (this.config.statusElements.gameTime.toggleGameTime24Hour) {
            long hour = (time / 1000L + 6L) % 24L;
            int minute = (int)((double)(time % 1000L) / 1000.0 * 60.0);
            return String.format("%d:%02d", hour, minute);
        }
        long hour = (time / 1000L + 6L) % 24L;
        int minute = (int)((double)(time % 1000L) / 1000.0 * 60.0);
        String ampm = "AM";
        if (hour >= 12L) {
            ampm = "PM";
        }
        if (hour > 12L) {
            hour -= 12L;
        }
        if (hour == 0L) {
            hour = 12L;
        }
        return String.format("%d:%02d %s", hour, minute, ampm);
    }

    public String getSystemTime() {
        if (!this.config.statusElements.systemTime.toggleSystemTime) {
            return "";
        }
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("h:mm a");
        if (this.config.statusElements.systemTime.toggleSystemTime24Hour) {
            formatter = DateTimeFormatter.ofPattern("H:mm");
        }
        return time.format(formatter).toUpperCase();
    }

    public String getDay() {
        if (!this.config.statusElements.gameTime.toggleGameDayCounter) {
            return "";
        }
        long time = this.player.method_37908().method_8532();
        long day = time / 24000L;
        return String.format(Utilities.translatable("text.hud.simplehudenhanced.day").getString() + ": %d", day);
    }

    public String getPlayerName() {
        if (!this.config.statusElements.togglePlayerName) {
            return "";
        }
        return String.format(Utilities.translatable("text.hud.simplehudenhanced.player").getString() + ": %s", this.player.method_5477().getString());
    }

    public String getPing() {
        if (!this.config.statusElements.togglePing) {
            return "";
        }
        try {
            return String.format("%s " + Utilities.translatable("text.hud.simplehudenhanced.ping").getString(), this.client.method_1562().method_2871(this.player.method_5667()).method_2959());
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public String getTPS() {
        if (!this.config.statusElements.toggleTPS) {
            return "";
        }
        return String.format(Utilities.translatable("text.hud.simplehudenhanced.tps").getString() + ": %.2f", Float.valueOf(TpsTracker.INSTANCE.getTickRate()));
    }

    public String getServer() {
        if (!this.config.statusElements.toggleServerName) {
            return "";
        }
        try {
            return String.format(Utilities.translatable("text.hud.simplehudenhanced.server").getString() + ": %s", this.client.method_1558().field_3752);
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public String getServerAddress() {
        if (!this.config.statusElements.toggleServerAddress) {
            return "";
        }
        try {
            return String.format(Utilities.translatable("text.hud.simplehudenhanced.serveraddress").getString() + ": %s", this.client.method_1558().field_3761);
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public boolean isPlayerSprinting() {
        return this.player.method_5624();
    }

    public boolean isPlayerFlying() {
        return this.player.method_6128();
    }

    public boolean isPlayerSwimming() {
        return this.player.method_5681();
    }

    public boolean isPlayerSneaking() {
        return this.player.method_5715();
    }
}

