/*
 * Decompiled with CFR 0.152.
 */
package com.soradgaming.simplehudenhanced.hud;

import com.soradgaming.simplehudenhanced.cache.EquipmentCache;
import com.soradgaming.simplehudenhanced.config.EquipmentAlignment;
import com.soradgaming.simplehudenhanced.config.EquipmentOrientation;
import com.soradgaming.simplehudenhanced.config.SimpleHudEnhancedConfig;
import com.soradgaming.simplehudenhanced.hud.EquipmentInfoStack;
import com.soradgaming.simplehudenhanced.hud.ScreenManager;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class Equipment {
    private final class_327 renderer;
    private final SimpleHudEnhancedConfig config;
    private final class_332 context;
    private final EquipmentCache cache;

    public Equipment(class_332 context, SimpleHudEnhancedConfig config, EquipmentCache equipmentCache) {
        this.renderer = class_310.method_1551().field_1772;
        this.config = config;
        this.context = context;
        this.cache = equipmentCache;
    }

    public void init() {
        this.draw(this.cache.getEquipmentInfo());
    }

    private void draw(List<EquipmentInfoStack> equipmentInfo) {
        int BoxWidth = this.cache.getLongestString();
        ScreenManager screenManager = this.cache.getScreenManager();
        int xAxis = screenManager.getXAxis();
        int yAxis = screenManager.getYAxis();
        float Scale = screenManager.getScale();
        int lineHeight = 16;
        int configX = this.config.equipmentStatus.equipmentStatusLocationX;
        screenManager.setScale(this.context, Scale);
        boolean isHorizontal = this.config.equipmentStatus.equipmentOrientation == EquipmentOrientation.Horizontal;
        boolean isOnRight = configX >= 50;
        boolean isRightAligned = this.config.equipmentStatus.equipmentAlignment == EquipmentAlignment.Right || this.config.equipmentStatus.equipmentAlignment == EquipmentAlignment.Auto && isOnRight;
        for (EquipmentInfoStack index : equipmentInfo) {
            int lineLength;
            class_1799 item = index.getItem();
            if (isRightAligned) {
                lineLength = this.renderer.method_1727(index.getText());
                int offset = BoxWidth - lineLength;
                this.context.method_25303(this.renderer, index.getText(), xAxis + offset + (isHorizontal ? -offset : (isOnRight ? -4 : 0)), yAxis + 4, index.getColor());
                int x = xAxis + BoxWidth + 4 + (isHorizontal ? -BoxWidth + lineLength : (isOnRight ? -4 : 0));
                this.context.method_51427(item, x, yAxis);
                this.drawDurabilityBar(x, yAxis, item);
            } else {
                this.context.method_25303(this.renderer, index.getText(), xAxis + 16 + 4 + (isOnRight ? (isHorizontal ? 0 : -4) : 0), yAxis + 4, index.getColor());
                int x = xAxis + (isOnRight ? (isHorizontal ? 0 : -4) : 0);
                this.context.method_51427(item, x, yAxis);
                this.drawDurabilityBar(x, yAxis, item);
            }
            if (isHorizontal) {
                lineLength = this.renderer.method_1727(index.getText());
                xAxis += lineLength + 4 + 16 + 4;
                continue;
            }
            yAxis += lineHeight;
        }
        screenManager.resetScale(this.context);
    }

    private void drawDurabilityBar(int xAxis, int yAxis, class_1799 item) {
        if (this.config.equipmentStatus.Durability.showDurabilityAsBar && item.method_7936() != 0) {
            if (item.method_7919() == 0) {
                return;
            }
            int i = item.method_31579();
            int j = item.method_31580();
            int k = xAxis + 2;
            int l = yAxis + 13;
            this.context.method_51737(k, l, k + 13, l + 2, 200, -16777216);
            this.context.method_51737(k, l, k + i, l + 1, 200, j | 0xFF000000);
        }
    }
}

