/*
 * Decompiled with CFR 0.152.
 */
package com.soradgaming.simplehudenhanced.cache;

import com.soradgaming.simplehudenhanced.config.SimpleHudEnhancedConfig;
import com.soradgaming.simplehudenhanced.hud.GameInfo;
import java.util.ArrayList;
import net.minecraft.class_310;

public class StatusCache {
    private static StatusCache instance;
    private final SimpleHudEnhancedConfig config;
    private boolean hudInfoDeadlock;
    private ArrayList<String> hudInfo;
    private ArrayList<String> hudInfoOLD;
    private boolean systemTimeDeadlock;
    private String systemTime;
    private String systemTimeOLD;

    private StatusCache(SimpleHudEnhancedConfig config) {
        this.config = config;
    }

    public static StatusCache getInstance(SimpleHudEnhancedConfig config) {
        if (instance == null) {
            instance = new StatusCache(config);
        }
        return instance;
    }

    public void updateCache() {
        GameInfo gameInfo = new GameInfo(class_310.method_1551(), this.config);
        this.calculateHudInfo(gameInfo);
        this.calculateSystemTime(gameInfo);
    }

    public synchronized ArrayList<String> getHudInfo() {
        if (this.hudInfoDeadlock) {
            return this.hudInfoOLD;
        }
        return this.hudInfo;
    }

    private void calculateHudInfo(GameInfo GameInformation) {
        this.hudInfoOLD = this.hudInfo;
        this.hudInfoDeadlock = true;
        ArrayList<Object> hudInfo = new ArrayList<Object>();
        hudInfo.add(GameInformation.getCords() + GameInformation.getDirection() + GameInformation.getOffset());
        hudInfo.add(GameInformation.getNether());
        hudInfo.add(GameInformation.getChunkCords());
        hudInfo.add(GameInformation.getSubChunkCords());
        hudInfo.add(GameInformation.getFPS());
        hudInfo.add(GameInformation.getSpeed());
        hudInfo.add(GameInformation.getLightLevel());
        hudInfo.add(GameInformation.getBiome());
        hudInfo.add(GameInformation.getTime());
        hudInfo.add(GameInformation.getDay());
        hudInfo.add(GameInformation.getPlayerName());
        hudInfo.add(GameInformation.getPing());
        hudInfo.add(GameInformation.getTPS());
        hudInfo.add(GameInformation.getServer());
        hudInfo.add(GameInformation.getServerAddress());
        hudInfo.add(GameInformation.getChunkCount());
        hudInfo.add(GameInformation.getEntityCount());
        hudInfo.add(GameInformation.getParticleCount());
        hudInfo.removeIf(String::isEmpty);
        this.hudInfo = hudInfo;
        this.hudInfoDeadlock = false;
    }

    public String getSystemTime() {
        if (this.systemTimeDeadlock) {
            return this.systemTimeOLD;
        }
        return this.systemTime;
    }

    private void calculateSystemTime(GameInfo GameInformation) {
        this.systemTimeOLD = this.systemTime;
        this.systemTimeDeadlock = true;
        this.systemTime = GameInformation.getSystemTime();
        this.systemTimeDeadlock = false;
    }
}

