/*
 * Decompiled with CFR 0.152.
 */
package net.fyoncle.elysiumdaystweaks.utility.configs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class ConfigReader {
    File configFile;
    BufferedReader bufferedReader;
    int whiteSpaceCount = 0;

    public ConfigReader(String pathToMinecraftFolder, String fileName) {
        this.configFile = new File(pathToMinecraftFolder + fileName);
    }

    public HashMap<String, String> readData() {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String line;
            this.bufferedReader = new BufferedReader(new FileReader(this.configFile));
            while ((line = this.bufferedReader.readLine()) != null) {
                result.put(this.getVarNameBeforeEquals(line), this.getDataAfterEquals(line).trim());
            }
            this.bufferedReader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private String getDataAfterEquals(String line) {
        String data = "null";
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) != '=') continue;
            if (line.charAt(i + 1) == ' ') {
                ++this.whiteSpaceCount;
            }
            data = line.substring(i + this.whiteSpaceCount);
            this.whiteSpaceCount = 0;
        }
        return data;
    }

    private String getVarNameBeforeEquals(String line) {
        Object name = "";
        for (int i = 0; i < line.length() && line.charAt(i) != '='; ++i) {
            name = (String)name + line.charAt(i);
        }
        return ((String)name).trim();
    }
}

