/*
 * Decompiled with CFR 0.152.
 */
package net.fyoncle.elysiumdaystweaks.mixin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fyoncle.elysiumdaystweaks.utility.constants.Constants;
import net.fyoncle.elysiumdaystweaks.utility.other.HolidayChecker;
import net.minecraft.class_7367;
import net.minecraft.class_8518;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_8518.class})
public class CustomIconMixin {
    @Unique
    private final Map<String, byte[]> STORAGE = new HashMap<String, byte[]>();
    @Unique
    private final List<class_7367<InputStream>> icons = new ArrayList<class_7367<InputStream>>();
    @Unique
    private boolean isInitialized = false;

    @Unique
    private void init() {
        if (!this.isInitialized) {
            int i;
            if (HolidayChecker.isChristmas()) {
                for (i = 0; i < Constants.Core.Paths.CHRISTMAS_ED_ICONS_FILE_NAMES.length; ++i) {
                    this.loadResource(Constants.Core.Paths.CHRISTMAS_ED_ICONS_FILE_NAMES[i]);
                }
            } else if (HolidayChecker.isHalloween()) {
                for (i = 0; i < Constants.Core.Paths.HALLOWEEN_ED_ICONS_FILE_NAMES.length; ++i) {
                    this.loadResource(Constants.Core.Paths.HALLOWEEN_ED_ICONS_FILE_NAMES[i]);
                }
            }
            if (!HolidayChecker.isChristmas() && !HolidayChecker.isHalloween()) {
                for (i = 0; i < Constants.Core.Paths.DEFAULT_ED_ICONS_FILE_NAMES.length; ++i) {
                    this.loadResource(Constants.Core.Paths.DEFAULT_ED_ICONS_FILE_NAMES[i]);
                }
            }
            this.isInitialized = true;
        }
    }

    @Unique
    private void loadResource(String path) {
        String fullPath = "assets/elysium-days-tweaks/icons/" + path;
        ClassLoader classLoader = CustomIconMixin.class.getClassLoader();
        try (InputStream stream = classLoader.getResourceAsStream(fullPath);){
            assert (stream != null);
            byte[] data = IOUtils.toByteArray((InputStream)stream);
            this.STORAGE.put(path, data);
            this.icons.add(this.getResource(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Unique
    public class_7367<InputStream> getResource(String path) {
        byte[] data = this.STORAGE.get(path);
        if (data == null) {
            throw new RuntimeException("Unexpected resource path " + path);
        }
        return () -> new ByteArrayInputStream(data);
    }

    @Inject(method={"getIcons"}, at={@At(value="HEAD")}, cancellable=true)
    private void getIcons(@NotNull CallbackInfoReturnable<List<class_7367<InputStream>>> cir) {
        this.init();
        cir.setReturnValue(this.icons);
    }
}

