/*
 * Decompiled with CFR 0.152.
 */
package net.mandalacreations.clean_tooltips.client;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public abstract class TooltipSection {
    private final List<class_2561> tooltip;
    private final ForgeConfigSpec.BooleanValue enabled;

    protected TooltipSection(List<class_2561> tooltip, ForgeConfigSpec.BooleanValue enabled) {
        this.tooltip = tooltip;
        this.enabled = enabled;
    }

    public void create() {
        if (((Boolean)this.enabled.get()).booleanValue() && this.shouldDisplay()) {
            if (!this.isFirstSection()) {
                this.addComponent((class_2561)class_2561.method_43473());
            }
            this.addHeader();
            this.buildSection();
        }
    }

    protected abstract void buildSection();

    protected void addComponent(class_2561 component) {
        this.tooltip.add(component);
    }

    public boolean shouldDisplay() {
        return true;
    }

    private void addHeader() {
        class_2561 header = this.getHeader();
        if (header == null) {
            return;
        }
        this.addComponent(header);
    }

    @Nullable
    protected class_2561 getHeader() {
        return null;
    }

    protected boolean isFirstSection() {
        return this.tooltip.size() <= 1;
    }

    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }
}

