/*
 * Decompiled with CFR 0.152.
 */
package net.mandalacreations.clean_tooltips.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.mandalacreations.clean_tooltips.CleanTooltips;
import net.mandalacreations.clean_tooltips.client.TooltipSection;
import net.mandalacreations.clean_tooltips.client.config.ClientConfig;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class EnchantmentSection
extends TooltipSection {
    private static final class_2561 ENCHANTMENTS = class_2561.method_43471((String)"item.clean_tooltips.enchantments").method_27692(class_124.field_1080);
    private static final class_5250 SPACE = class_2561.method_43470((String)" ");
    private final class_2499 enchantmentTag;
    private final List<class_2561> curses = new ArrayList<class_2561>();
    private final boolean isEnchantedBook;

    public EnchantmentSection(List<class_2561> tooltip, class_2499 enchantmentTag, boolean isEnchantedBook) {
        super(tooltip, ClientConfig.INSTANCE.enchantmentSectionEnabled());
        this.enchantmentTag = enchantmentTag;
        this.isEnchantedBook = isEnchantedBook;
    }

    public static boolean create(List<class_2561> tooltip, class_2499 enchantmentTag, boolean isEnchantedBook) {
        EnchantmentSection section = new EnchantmentSection(tooltip, enchantmentTag, isEnchantedBook);
        section.create();
        return section.isEnabled();
    }

    @Override
    protected void buildSection() {
        for (int i = 0; i < this.enchantmentTag.size(); ++i) {
            class_2487 tag = this.enchantmentTag.method_10602(i);
            class_7923.field_41176.method_17966(class_1890.method_37427((class_2487)tag)).ifPresent(enchantment -> this.handleEnchantment((class_1887)enchantment, tag));
        }
        this.curses.forEach(this::addComponent);
    }

    private void handleEnchantment(class_1887 enchantment, class_2487 tag) {
        int level = class_1890.method_37424((class_2487)tag);
        class_124 color = this.getColor(enchantment, level);
        class_5250 component = SPACE.method_27661().method_10852((class_2561)enchantment.method_8179(level).method_27661().method_27692(color));
        if (enchantment.method_8195()) {
            this.addComponent(enchantment, (class_2561)component, this.curses::add);
            return;
        }
        this.addComponent(enchantment, (class_2561)component, this::addComponent);
    }

    private void addComponent(class_1887 enchantment, class_2561 component, Consumer<class_2561> consumer) {
        consumer.accept(component);
        if (CleanTooltips.ENCHANTMENT_DESCRIPTIONS_LOADED && this.isEnchantedBook) {
            this.getDescriptionKey(enchantment).ifPresent(key -> consumer.accept((class_2561)SPACE.method_27661().method_10852((class_2561)class_2561.method_43471((String)key).method_27692(class_124.field_1063))));
        }
    }

    private Optional<String> getDescriptionKey(class_1887 enchantment) {
        String key = enchantment.method_8184() + ".desc";
        if (!class_1074.method_4663((String)key)) {
            if (!class_1074.method_4663((String)(enchantment.method_8184() + ".description"))) {
                return Optional.empty();
            }
            key = enchantment.method_8184() + ".description";
        }
        return Optional.of(key);
    }

    private class_124 getColor(class_1887 enchantment, int level) {
        if (enchantment.method_8195()) {
            return (class_124)ClientConfig.INSTANCE.curseEnchantmentColor().get();
        }
        return level >= enchantment.method_8183() ? (class_124)ClientConfig.INSTANCE.maxLevelEnchantmentColor().get() : (class_124)ClientConfig.INSTANCE.normalEnchantmentColor().get();
    }

    @Override
    public boolean shouldDisplay() {
        return !this.enchantmentTag.isEmpty();
    }

    @Override
    @Nullable
    protected class_2561 getHeader() {
        return ENCHANTMENTS;
    }
}

