/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.client.renderer.entity.model;

import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jmb19905.niftycarts.client.renderer.entity.model.EasyMeshBuilder;
import net.jmb19905.niftycarts.entity.AbstractDrawnEntity;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5609;
import net.minecraft.class_583;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class CartModel<T extends AbstractDrawnEntity>
extends class_583<T> {
    protected final class_630 body;
    @Nullable
    protected final class_630 rotating;
    protected final Set<class_630> leftWheels = new HashSet<class_630>();
    protected final Set<class_630> rightWheels = new HashSet<class_630>();

    protected CartModel(class_630 root) {
        this(root, 1);
    }

    protected CartModel(class_630 root, int axleCount) {
        this.body = root.method_32086("body");
        this.rotating = root.method_41919("rotating") ? root.method_32086("rotating") : null;
        for (int i = 0; i < axleCount; ++i) {
            this.leftWheels.add(root.method_32086("leftWheel_" + i));
            this.rightWheels.add(root.method_32086("rightWheel_" + i));
        }
    }

    public class_630 getBody() {
        return this.body;
    }

    public class_630 getWheel() {
        return this.rightWheels.stream().findAny().orElse(null);
    }

    public void method_2828(class_4587 stack, class_4588 buf, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.method_22699(stack, buf, packedLight, packedOverlay, red, green, blue, alpha);
        if (this.rotating != null) {
            this.rotating.method_22699(stack, buf, packedLight, packedOverlay, red, green, blue, alpha);
        }
        this.leftWheels.forEach(part -> part.method_22699(stack, buf, packedLight, packedOverlay, red, green, blue, alpha));
        this.rightWheels.forEach(part -> part.method_22699(stack, buf, packedLight, packedOverlay, red, green, blue, alpha));
    }

    public void setupAnim(T entity, float delta, float limbSwingAmount, float ageInTicks, float netHeadYaw, float pitch) {
        float rot;
        if (this.rotating == null) {
            this.body.field_3654 = (float)Math.toRadians(pitch);
        } else {
            this.rotating.field_3654 = (float)Math.toRadians(pitch);
        }
        this.rightWheels.forEach(part -> {
            part.field_3654 = (float)(entity.getWheelRotation(0) + entity.getWheelRotationIncrement(0) * (double)delta);
        });
        this.leftWheels.forEach(part -> {
            part.field_3654 = (float)(entity.getWheelRotation(1) + entity.getWheelRotationIncrement(1) * (double)delta);
        });
        float time = (float)((AbstractDrawnEntity)((Object)entity)).getTimeSinceHit() - delta;
        if (time > 0.0f) {
            float damage = Math.max(((AbstractDrawnEntity)((Object)entity)).getDamageTaken() - delta, 0.0f) * 0.5f;
            rot = (float)Math.toRadians(class_3532.method_15374((float)time) * time * damage / 40.0f * (float)(-((AbstractDrawnEntity)((Object)entity)).getForwardDirection()));
        } else {
            rot = 0.0f;
        }
        this.rightWheels.forEach(part -> {
            part.field_3674 = rot;
        });
        this.leftWheels.forEach(part -> {
            part.field_3674 = rot;
        });
    }

    public static class_5609 createDefinition(float rimLength, float axleLength) {
        return CartModel.createDefinition(rimLength, axleLength, 1, 0.0f);
    }

    public static class_5609 createDefinition(float rimLength, float axleLength, int axleCount, float axleDist) {
        class_5609 def = new class_5609();
        float angle = 0.3926991f;
        float wheelRadius = rimLength / 2.0f / (class_3532.method_15374((float)angle) / class_3532.method_15362((float)angle));
        float f = axleLength / 2.0f + 2.0f;
        for (int k = 0; k < axleCount; ++k) {
            float d = (float)k - (float)(axleCount - 1) / 2.0f;
            EasyMeshBuilder leftWheel = new EasyMeshBuilder("leftWheel_" + k, 46, 60);
            leftWheel.setRotationPoint(f, -wheelRadius, 1.0f + axleDist * d);
            leftWheel.addBox(-2.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f);
            for (int i = 0; i < 8; ++i) {
                EasyMeshBuilder rim = new EasyMeshBuilder("rim_" + i, 58, 64 - ((int)rimLength + 1));
                rim.addBox(-2.0f, -rimLength / 2.0f, wheelRadius - 1.0f, 2.0f, rimLength, 1.0f);
                rim.xRot = (float)i * (float)Math.PI / 4.0f;
                leftWheel.addChild(rim);
                EasyMeshBuilder spoke = new EasyMeshBuilder("spoke_" + i, 54, 64 - class_3532.method_15386((float)(wheelRadius - 1.0f)));
                spoke.addBox(-1.5f, 1.0f, -0.5f, 1.0f, wheelRadius - 2.0f, 1.0f);
                spoke.xRot = (float)i * (float)Math.PI / 4.0f;
                leftWheel.addChild(spoke);
            }
            leftWheel.build(def.method_32111());
            EasyMeshBuilder rightWheel = new EasyMeshBuilder("rightWheel_" + k, 46, 60);
            rightWheel.setRotationPoint(-f, -wheelRadius, 1.0f + axleDist * d);
            rightWheel.addBox(0.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f);
            for (int i = 0; i < 8; ++i) {
                EasyMeshBuilder rim = new EasyMeshBuilder("rim_" + i, 58, 64 - ((int)rimLength + 1));
                rim.addBox(0.0f, -rimLength / 2.0f, wheelRadius - 1.0f, 2.0f, rimLength, 1.0f);
                rim.xRot = (float)i * (float)Math.PI / 4.0f;
                rightWheel.addChild(rim);
                EasyMeshBuilder spoke = new EasyMeshBuilder("spoke_" + i, 54, 64 - class_3532.method_15386((float)(wheelRadius - 1.0f)));
                spoke.addBox(0.5f, 1.0f, -0.5f, 1.0f, wheelRadius - 2.0f, 1.0f);
                spoke.xRot = (float)i * (float)Math.PI / 4.0f;
                rightWheel.addChild(spoke);
            }
            rightWheel.build(def.method_32111());
        }
        return def;
    }

    public static EasyMeshBuilder createBody(int rimLength) {
        EasyMeshBuilder body = new EasyMeshBuilder("body");
        float angle = 0.3926991f;
        float wheelRadius = (float)rimLength / 2.0f / (class_3532.method_15374((float)angle) / class_3532.method_15362((float)angle));
        body.setRotationPoint(0.0f, -wheelRadius, 1.0f);
        return body;
    }
}

