/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.client.renderer.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jmb19905.niftycarts.NiftyCartsConfig;
import net.jmb19905.niftycarts.client.renderer.NiftyCartsModelLayers;
import net.jmb19905.niftycarts.client.renderer.entity.CargoRenderUtil;
import net.jmb19905.niftycarts.client.renderer.entity.DrawnRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.ICargoCartRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.model.CartModel;
import net.jmb19905.niftycarts.client.renderer.entity.model.IFlowerCargoModel;
import net.jmb19905.niftycarts.client.renderer.entity.model.SupplyCartModel;
import net.jmb19905.niftycarts.entity.AbstractCargoCart;
import net.jmb19905.niftycarts.entity.SupplyCartEntity;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1535;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_4057;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class SupplyCartRenderer
extends DrawnRenderer<SupplyCartEntity, SupplyCartModel>
implements ICargoCartRenderer {
    private final class_572<class_1309> leggings;
    private final class_572<class_1309> armor;
    private final class_1059 armorTrimAtlas;

    public SupplyCartRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, new SupplyCartModel(renderManager.method_32167(NiftyCartsModelLayers.SUPPLY_CART)));
        this.leggings = new class_572(renderManager.method_32167(class_5602.field_27579));
        this.armor = new class_572(renderManager.method_32167(class_5602.field_27580));
        this.armorTrimAtlas = renderManager.method_48481().method_24153(class_4722.field_42071);
        this.field_4673 = 1.0f;
    }

    @Override
    protected void renderContents(SupplyCartEntity entity, float delta, class_4587 stack, class_4597 source, int packedLight) {
        CargoRenderUtil.renderContents(entity, (CartModel)this.model, this, delta, stack, source, packedLight);
    }

    @Override
    public void renderFlowers(AbstractCargoCart entity, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        CargoRenderUtil.renderFlowers((IFlowerCargoModel)this.model, this.getTextureLocation((SupplyCartEntity)entity), 3.0, stack, source, packedLight, cargo);
    }

    @Override
    public void renderWheel(AbstractCargoCart entity, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        CargoRenderUtil.renderWheel((CartModel)this.model, this.getTextureLocation((SupplyCartEntity)entity), 1.18, 0.1, -0.15, stack, source, packedLight);
    }

    @Override
    public void renderPaintings(AbstractCargoCart entity, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        class_4588 buf = source.getBuffer(class_1921.method_23572((class_2960)class_310.method_1551().method_18321().method_18342().method_45852()));
        ObjectList types = (ObjectList)StreamSupport.stream(class_7923.field_41182.spliterator(), false).filter(t -> t.method_6945() == 16 && t.method_6943() == 16).collect(Collectors.toCollection(ObjectArrayList::new));
        Random rng = new Random(entity.method_5667().getMostSignificantBits() ^ entity.method_5667().getLeastSignificantBits());
        ObjectLists.shuffle((ObjectList)types, (Random)rng);
        int count = 0;
        for (class_1799 itemStack : cargo) {
            if (itemStack.method_7960()) continue;
            ++count;
        }
        stack.method_22903();
        stack.method_22904(0.0, -0.15625, 0.0);
        stack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
        int n = 0;
        for (int i = 0; i < cargo.size(); ++i) {
            class_1799 itemStack = (class_1799)cargo.get(i);
            if (itemStack.method_7960()) continue;
            class_1535 t2 = (class_1535)types.get(i % types.size());
            stack.method_22903();
            stack.method_22904(0.0, ((double)n++ - (double)(count - 1) * 0.5) / (double)count, -0.0625 * (double)i);
            stack.method_22907(class_7833.field_40718.rotation(rng.nextFloat() * (float)Math.PI));
            CargoRenderUtil.renderPainting(t2, stack, buf, packedLight);
            stack.method_22909();
        }
        stack.method_22909();
    }

    @Override
    public void renderSupplies(AbstractCargoCart entity, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        class_918 renderer = class_310.method_1551().method_1480();
        Random rng = new Random();
        for (int i = 0; i < cargo.size(); ++i) {
            class_1799 itemStack = (class_1799)cargo.get(i);
            if (itemStack.method_7960()) continue;
            int ix = i % 2;
            int iz = i / 2;
            if (i < cargo.size() - 2 && ((class_1799)cargo.get(i + 2)).method_31573(class_3489.field_16444) || i >= 2 && ((class_1799)cargo.get(i - 2)).method_31573(class_3489.field_16444)) continue;
            double x = ((double)ix - 0.5) * 11.0 / 16.0;
            double z = ((double)iz * 11.0 - 9.0) / 16.0;
            class_1087 model = renderer.method_4019(itemStack, entity.method_37908(), null, i);
            stack.method_22903();
            if (model.method_4712() && itemStack.method_7909() != class_1802.field_8547 && ((Boolean)NiftyCartsConfig.getClient().renderSupplyGear.get()).booleanValue()) {
                stack.method_22904(x, -0.46, z);
                stack.method_22905(0.65f, 0.65f, 0.65f);
                stack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
                if (itemStack.method_7909() == class_1802.field_8255) {
                    stack.method_22905(1.2f, 1.2f, 1.2f);
                    stack.method_22907(class_7833.field_40716.rotationDegrees(ix == 0 ? -90.0f : 90.0f));
                    stack.method_22904(0.5, 0.8, -0.05);
                    stack.method_22907(class_7833.field_40714.rotationDegrees(-22.5f));
                } else if (iz < 1 && itemStack.method_31573(class_3489.field_16444)) {
                    stack.method_22904(0.0, 0.0, 1.0);
                } else if (!model.method_4713()) {
                    stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                }
                renderer.method_23179(itemStack, class_811.field_4315, false, stack, source, packedLight, class_4608.field_21444, model);
            } else {
                rng.setSeed(32L * (long)i + (long)Objects.hashCode(class_7923.field_41178.method_10221((Object)itemStack.method_7909())));
                stack.method_22904(x, -0.15 + ((ix + iz) % 2 == 0 ? 0.0 : 1.0E-4), z);
                if ((class_1738.class.equals(itemStack.method_7909().getClass()) || class_4057.class.equals(itemStack.method_7909().getClass())) && ((Boolean)NiftyCartsConfig.getClient().renderSupplyGear.get()).booleanValue()) {
                    CargoRenderUtil.renderArmor(entity, this.leggings, this.armor, this.armorTrimAtlas, stack, source, packedLight, itemStack, ix);
                } else {
                    stack.method_22905(0.7f, 0.7f, 0.7f);
                    stack.method_22907(class_7833.field_40716.rotation(rng.nextFloat() * (float)Math.PI));
                    stack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                    int copies = Math.min(itemStack.method_7947(), (itemStack.method_7947() - 1) / 16 + 2);
                    renderer.method_23179(itemStack, class_811.field_4319, false, stack, source, packedLight, class_4608.field_21444, model);
                    for (int n = 1; n < copies; ++n) {
                        stack.method_22903();
                        stack.method_22907(class_7833.field_40718.rotation(rng.nextFloat() * (float)Math.PI));
                        stack.method_22904((double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), -0.1 * (double)n);
                        renderer.method_23179(itemStack, class_811.field_4319, false, stack, source, packedLight, class_4608.field_21444, model);
                        stack.method_22909();
                    }
                }
            }
            stack.method_22909();
        }
    }

    @NotNull
    public class_2960 getTextureLocation(SupplyCartEntity entity) {
        return new class_2960("niftycarts", "textures/entity/" + entity.getWoodType().getId() + "_supply_cart.png");
    }
}

