/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.client.renderer.entity;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jmb19905.niftycarts.client.mixin.ModelPartMixin;
import net.jmb19905.niftycarts.entity.AbstractDrawnEntity;
import net.minecraft.class_1088;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2582;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import net.minecraft.class_823;
import net.minecraft.class_897;

@Environment(value=EnvType.CLIENT)
public abstract class DrawnRenderer<T extends AbstractDrawnEntity, M extends class_583<T>>
extends class_897<T> {
    protected final M model;
    private final class_630 flag;
    private final class_630 pole;
    private final class_630 bar;

    protected DrawnRenderer(class_5617.class_5618 renderManager, M model) {
        super(renderManager);
        this.model = model;
        class_630 banner = renderManager.method_32167(class_5602.field_27678);
        this.flag = banner.method_32086("flag");
        this.pole = banner.method_32086("pole");
        this.bar = banner.method_32086("bar");
    }

    public void render(T entity, float yaw, float delta, class_4587 stack, class_4597 source, int packedLight) {
        stack.method_22903();
        AbstractDrawnEntity.RenderInfo info = ((AbstractDrawnEntity)((Object)entity)).getInfo(delta);
        this.setupRotation(entity, info.getYaw(), delta, stack);
        this.model.method_2819(entity, delta, 0.0f, 0.0f, 0.0f, info.getPitch());
        class_4588 buf = source.getBuffer(this.model.method_23500(this.method_3931((class_1297)entity)));
        this.model.method_2828(stack, buf, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        this.renderContents(entity, delta, stack, source, packedLight);
        stack.method_22909();
        super.method_3936(entity, info.getYaw(), delta, stack, source, packedLight);
    }

    protected abstract void renderContents(T var1, float var2, class_4587 var3, class_4597 var4, int var5);

    public void setupRotation(T entity, float entityYaw, float delta, class_4587 stack) {
        stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entityYaw));
        float time = (float)((AbstractDrawnEntity)((Object)entity)).getTimeSinceHit() - delta;
        if (time > 0.0f) {
            double center = 1.2;
            stack.method_22904(0.0, 1.2, 0.0);
            float damage = Math.max(((AbstractDrawnEntity)((Object)entity)).getDamageTaken() - delta, 0.0f);
            float angle = class_3532.method_15374((float)time) * time * damage / 60.0f;
            stack.method_22907(class_7833.field_40718.rotationDegrees(angle * (float)((AbstractDrawnEntity)((Object)entity)).getForwardDirection()));
            stack.method_22904(0.0, -1.2, 0.0);
            stack.method_22904(0.0, (double)(angle / 32.0f), 0.0);
        }
        stack.method_22905(-1.0f, -1.0f, 1.0f);
    }

    protected void renderBanner(AbstractDrawnEntity entity, float delta, class_4587 stack, class_4597 source, int packedLight, List<Pair<class_6880<class_2582>, class_1767>> banner) {
        this.renderBanner(entity, delta, stack, source, packedLight, banner, true);
    }

    protected void renderBanner(AbstractDrawnEntity entity, float delta, class_4587 stack, class_4597 source, int packedLight, List<Pair<class_6880<class_2582>, class_1767>> banner, boolean renderPole) {
        stack.method_22903();
        stack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        float scale = 0.6666667f;
        stack.method_22905(0.6666667f, 0.6666667f, 0.6666667f);
        class_4588 consumer = class_1088.field_20847.method_24145(source, class_1921::method_23572);
        if (renderPole) {
            this.pole.field_3674 = -0.3f;
            this.pole.field_3657 = 14.0f;
            this.pole.method_22698(stack, consumer, packedLight, class_4608.field_21444);
        }
        this.bar.field_3657 = -3.912f;
        this.bar.field_3656 = 3.045f;
        this.bar.field_3655 = 0.001f;
        this.bar.method_22698(stack, consumer, packedLight, class_4608.field_21444);
        this.flag.field_3657 = -4.001f;
        this.flag.field_3656 = -27.1f;
        this.flag.field_3655 = 1.5f;
        long gameTime = entity.method_37908().method_8510();
        float animationTime = ((float)Math.floorMod((long)(entity.method_23317() * 7.0 + entity.method_23318() * 9.0 + entity.method_23321() * 13.0) + gameTime, 100L) + delta) / 100.0f;
        this.flag.field_3654 = 0.01f * class_3532.method_15362((float)((float)Math.PI * 2 * animationTime)) * (float)Math.PI;
        class_823.method_29999((class_4587)stack, (class_4597)source, (int)packedLight, (int)class_4608.field_21444, (class_630)this.flag, (class_4730)class_1088.field_20847, (boolean)true, banner);
        stack.method_22909();
    }

    protected void attach(class_630 bone, class_630 attachment, Consumer<class_4587> function, class_4587 stack) {
        stack.method_22903();
        bone.method_22703(stack);
        if (bone == attachment) {
            function.accept(stack);
        } else {
            Map<String, class_630> childModels = ((ModelPartMixin)bone).getChildren();
            for (class_630 child : childModels.values()) {
                this.attach(child, attachment, function, stack);
            }
        }
        stack.method_22909();
    }
}

