/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.client.renderer.entity;

import com.mojang.datafixers.util.Pair;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jmb19905.niftycarts.client.renderer.entity.Contents;
import net.jmb19905.niftycarts.client.renderer.entity.DrawnRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.ICargoCartRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.model.CartModel;
import net.jmb19905.niftycarts.client.renderer.entity.model.IFlowerCargoModel;
import net.jmb19905.niftycarts.entity.AbstractCargoCart;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1535;
import net.minecraft.class_1738;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2371;
import net.minecraft.class_2582;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4044;
import net.minecraft.class_4057;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5455;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import net.minecraft.class_8053;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class CargoRenderUtil {
    public static void renderContents(AbstractCargoCart entity, CartModel<?> model, DrawnRenderer<?, ?> renderer, float delta, class_4587 stack, class_4597 source, int packedLight) {
        List<Pair<class_6880<class_2582>, class_1767>> list;
        class_1799 s;
        class_2371<class_1799> cargo = entity.getCargo();
        Contents contents = Contents.SUPPLIES;
        Iterator it = cargo.iterator();
        block0: while (it.hasNext()) {
            s = (class_1799)it.next();
            if (s.method_7960()) continue;
            for (Contents c : Contents.values()) {
                if (!c.getPredicate().test((class_1799)s)) continue;
                contents = c;
                break block0;
            }
        }
        while (contents != Contents.SUPPLIES && it.hasNext()) {
            s = (class_1799)it.next();
            if (s.method_7960() || contents.getPredicate().test((class_1799)s) || (contents = Contents.SUPPLIES).getPredicate().test((class_1799)s)) continue;
            contents = Contents.NONE;
        }
        stack.method_22903();
        model.getBody().method_22703(stack);
        if (contents.getRenderer() != null && renderer instanceof ICargoCartRenderer) {
            ICargoCartRenderer cargoCartRenderer = (ICargoCartRenderer)((Object)renderer);
            contents.getRenderer().render(cargoCartRenderer, entity, stack, source, packedLight, cargo);
        }
        if (!(list = entity.getBannerPattern()).isEmpty()) {
            stack.method_22904(0.0, -0.6, 1.5);
            renderer.renderBanner(entity, delta, stack, source, packedLight, list);
        }
        stack.method_22909();
    }

    public static void renderFlowers(IFlowerCargoModel model, class_2960 textureLocation, double offset, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        model.getFlowerBasket().method_22698(stack, source.getBuffer(class_1921.method_23578((class_2960)textureLocation)), packedLight, class_4608.field_21444);
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_778 renderer = dispatcher.method_3350();
        for (int i = 0; i < cargo.size(); ++i) {
            class_1799 itemStack = (class_1799)cargo.get(i);
            if (!(itemStack.method_7909() instanceof class_1747)) continue;
            int ix = i % 2;
            int iz = i / 2;
            class_2680 defaultState = ((class_1747)itemStack.method_7909()).method_7711().method_9564();
            class_2680 state = defaultState.method_28498((class_2769)class_2741.field_12533) ? (class_2680)defaultState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609) : defaultState;
            class_1087 bakedModel = dispatcher.method_3349(state);
            int rgb = class_310.method_1551().method_1505().method_1697(state, null, null, 0);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            stack.method_22903();
            stack.method_22904(0.0, -0.7, -offset / 16.0);
            stack.method_22905(0.65f, 0.65f, 0.65f);
            stack.method_22904((double)ix, 0.5, (double)iz - 1.0);
            stack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            renderer.method_3367(stack.method_23760(), source.getBuffer(class_1921.method_23581()), state, bakedModel, r, g, b, packedLight, class_4608.field_21444);
            stack.method_22909();
        }
    }

    public static void renderWheel(CartModel<?> model, class_2960 textureLocation, double xOffset, double yOffset, double zOffset, class_4587 stack, class_4597 source, int packedLight) {
        stack.method_22903();
        stack.method_22904(xOffset, yOffset, zOffset);
        class_630 wheel = model.getWheel();
        wheel.field_3654 = 0.9f;
        wheel.field_3674 = 0.9424779f;
        wheel.method_22698(stack, source.getBuffer(model.method_23500(textureLocation)), packedLight, class_4608.field_21444);
        stack.method_22909();
    }

    public static void renderArmor(class_1297 entity, class_572<class_1309> leggings, class_572<class_1309> armor, class_1059 armorTrimAtlas, class_4587 stack, class_4597 source, int packedLight, class_1799 itemStack, int ix) {
        class_1792 item = itemStack.method_7909();
        if (!(item instanceof class_1738)) {
            return;
        }
        class_1738 armorItem = (class_1738)item;
        class_1304 slot = class_1309.method_32326((class_1799)itemStack);
        class_572<class_1309> m = slot == class_1304.field_6172 ? leggings : armor;
        stack.method_22907(class_7833.field_40716.rotation(ix == 0 ? 1.5707964f : -1.5707964f));
        m.method_2805(false);
        m.field_3399 = class_572.class_573.field_3409;
        m.field_3395 = class_572.class_573.field_3409;
        m.field_3400 = false;
        m.field_3396 = 0.0f;
        m.field_3448 = false;
        switch (slot) {
            case field_6169: {
                stack.method_22904(0.0, 0.1, 0.0);
                m.field_3398.field_3654 = 0.2f;
                m.field_3394.method_17138(m.field_3398);
                m.field_3398.field_3665 = true;
                m.field_3394.field_3665 = true;
                break;
            }
            case field_6174: {
                stack.method_22904(0.0, -0.4, -0.15);
                m.field_27433.field_3654 = -0.15f;
                m.field_3401.field_3654 = -0.15f;
                m.field_3391.field_3654 = 0.9f;
                m.field_3391.field_3665 = true;
                m.field_3401.field_3665 = true;
                m.field_27433.field_3665 = true;
                break;
            }
            case field_6172: {
                stack.method_22904(0.0, -0.7, -0.15);
                m.field_3391.field_3654 = 0.0f;
                m.field_3392.field_3654 = 1.2f;
                m.field_3397.field_3654 = 1.2f;
                m.field_3392.field_3675 = -0.3f;
                m.field_3397.field_3675 = 0.3f;
                m.field_3391.field_3665 = true;
                m.field_3392.field_3665 = true;
                m.field_3397.field_3665 = true;
                break;
            }
            case field_6166: {
                stack.method_22904(0.0, -1.15, -0.1);
                m.field_3392.field_3654 = 0.0f;
                m.field_3397.field_3654 = 0.0f;
                m.field_3392.field_3675 = -0.1f;
                m.field_3397.field_3675 = 0.0f;
                m.field_3392.field_3665 = true;
                m.field_3397.field_3665 = true;
            }
        }
        stack.method_22905(0.75f, 0.75f, 0.75f);
        class_4588 armorBuf = class_918.method_27952((class_4597)source, (class_1921)class_1921.method_25448((class_2960)CargoRenderUtil.getArmorResource(itemStack, slot, null)), (boolean)false, (boolean)itemStack.method_7958());
        if (armorItem instanceof class_4057) {
            int rgb = ((class_4057)armorItem).method_7800(itemStack);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            CargoRenderUtil.renderArmorModelPart(stack, source, packedLight, itemStack, m, slot, r, g, b, null);
            CargoRenderUtil.renderArmorModelPart(stack, source, packedLight, itemStack, m, slot, 1.0f, 1.0f, 1.0f, "overlay");
        } else {
            m.method_2828(stack, armorBuf, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        class_8053.method_48428((class_5455)entity.method_37908().method_30349(), (class_1799)itemStack).ifPresent(armorTrim -> {
            class_1058 textureAtlasSprite = armorTrimAtlas.method_4608(slot == class_1304.field_6172 ? armorTrim.method_48434(armorItem.method_7686()) : armorTrim.method_48436(armorItem.method_7686()));
            class_4588 vertexConsumer = textureAtlasSprite.method_24108(source.getBuffer(class_4722.method_48480()));
            m.method_2828(stack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        });
        if (itemStack.method_7958()) {
            m.method_2828(stack, source.getBuffer(class_1921.method_27949()), packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private static void renderArmorModelPart(class_4587 poseStack, class_4597 multiBufferSource, int i, class_1799 armorItem, class_572<class_1309> humanoidModel, class_1304 slot, float f, float g, float h, @Nullable String string) {
        class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_25448((class_2960)CargoRenderUtil.getArmorResource(armorItem, slot, string)));
        humanoidModel.method_2828(poseStack, vertexConsumer, i, class_4608.field_21444, f, g, h, 1.0f);
    }

    public static class_2960 getArmorResource(class_1799 stack, class_1304 slot, @Nullable String type) {
        class_1738 item = (class_1738)stack.method_7909();
        return CargoRenderUtil.getArmorLocation(item, slot == class_1304.field_6172, type);
    }

    private static class_2960 getArmorLocation(class_1738 armorItem, boolean bl, @Nullable String string) {
        String var10000 = armorItem.method_7686().method_7694();
        String string2 = "textures/models/armor/" + var10000 + "_layer_" + (bl ? 2 : 1) + (String)(string == null ? "" : "_" + string) + ".png";
        return new class_2960(string2);
    }

    public static void renderPainting(class_1535 painting, class_4587 stack, class_4588 buf, int packedLight) {
        class_4044 uploader = class_310.method_1551().method_18321();
        int width = painting.method_6945();
        int height = painting.method_6943();
        class_1058 art = uploader.method_18345(painting);
        class_1058 back = uploader.method_18342();
        Matrix4f model = stack.method_23760().method_23761();
        Matrix3f normal = stack.method_23760().method_23762();
        int blockWidth = width / 16;
        int blockHeight = height / 16;
        float offsetX = (float)(-blockWidth) / 2.0f;
        float offsetY = (float)(-blockHeight) / 2.0f;
        float depth = 0.03125f;
        float bu0 = back.method_4594();
        float bu1 = back.method_4577();
        float bv0 = back.method_4593();
        float bv1 = back.method_4575();
        float bup = back.method_4580(1.0);
        float bvp = back.method_4570(1.0);
        double uvX = 16.0 / (double)blockWidth;
        double uvY = 16.0 / (double)blockHeight;
        for (int x = 0; x < blockWidth; ++x) {
            for (int y = 0; y < blockHeight; ++y) {
                float x1 = offsetX + (float)(x + 1);
                float x0 = offsetX + (float)x;
                float y1 = offsetY + (float)(y + 1);
                float y0 = offsetY + (float)y;
                float u0 = art.method_4580(uvX * (double)(blockWidth - x));
                float u1 = art.method_4580(uvX * (double)(blockWidth - x - 1));
                float v0 = art.method_4570(uvY * (double)(blockHeight - y));
                float v1 = art.method_4570(uvY * (double)(blockHeight - y - 1));
                CargoRenderUtil.vert(model, normal, buf, x1, y0, u1, v0, -0.03125f, 0, 0, -1, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x0, y0, u0, v0, -0.03125f, 0, 0, -1, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x0, y1, u0, v1, -0.03125f, 0, 0, -1, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x1, y1, u1, v1, -0.03125f, 0, 0, -1, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x1, y1, bu0, bv0, 0.03125f, 0, 0, 1, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x0, y1, bu1, bv0, 0.03125f, 0, 0, 1, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x0, y0, bu1, bv1, 0.03125f, 0, 0, 1, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x1, y0, bu0, bv1, 0.03125f, 0, 0, 1, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x1, y1, bu0, bv0, -0.03125f, 0, 1, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x0, y1, bu1, bv0, -0.03125f, 0, 1, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x0, y1, bu1, bvp, 0.03125f, 0, 1, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x1, y1, bu0, bvp, 0.03125f, 0, 1, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x1, y0, bu0, bv0, 0.03125f, 0, -1, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x0, y0, bu1, bv0, 0.03125f, 0, -1, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x0, y0, bu1, bvp, -0.03125f, 0, -1, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x1, y0, bu0, bvp, -0.03125f, 0, -1, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x1, y1, bup, bv0, 0.03125f, -1, 0, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x1, y0, bup, bv1, 0.03125f, -1, 0, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x1, y0, bu0, bv1, -0.03125f, -1, 0, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x1, y1, bu0, bv0, -0.03125f, -1, 0, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x0, y1, bup, bv0, -0.03125f, 1, 0, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x0, y0, bup, bv1, -0.03125f, 1, 0, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x0, y0, bu0, bv1, 0.03125f, 1, 0, 0, packedLight);
                CargoRenderUtil.vert(model, normal, buf, x0, y1, bu0, bv0, 0.03125f, 1, 0, 0, packedLight);
            }
        }
    }

    private static void vert(Matrix4f stack, Matrix3f normal, class_4588 buf, float x, float y, float u, float v, float z, int nx, int ny, int nz, int packedLight) {
        buf.method_22918(stack, x, y, z).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(packedLight).method_23763(normal, (float)nx, (float)ny, (float)nz).method_1344();
    }
}

