/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.advancement;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class SimpleBlockPredicate
implements Predicate<class_2680> {
    public static final SimpleBlockPredicate ANY = new SimpleBlockPredicate(null, null);
    @Nullable
    private final class_6862<class_2248> blockTag;
    @Nullable
    private final Set<class_2248> blocks;

    public SimpleBlockPredicate(@Nullable class_6862<class_2248> blockTag, @Nullable Set<class_2248> blocks) {
        this.blockTag = blockTag;
        this.blocks = blocks;
    }

    @Override
    public boolean test(class_2680 block) {
        if (this.blockTag == null && this.blocks == null) {
            return true;
        }
        return block.method_26164(this.blockTag) || this.blocks != null && this.blocks.contains(block.method_26204());
    }

    public JsonElement serializeJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (this.blocks != null) {
            JsonArray array = new JsonArray();
            this.blocks.forEach(b -> {
                class_2960 id = class_7923.field_41175.method_10221(b);
                array.add(id.toString());
            });
        }
        if (this.blockTag != null) {
            jsonObject.addProperty("tag", this.blockTag.comp_327().toString());
        }
        return jsonObject;
    }

    public static SimpleBlockPredicate deserializeJson(JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            class_6862 tag = null;
            if (object.has("tag")) {
                String tagId = object.getAsJsonPrimitive("tag").getAsString();
                tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(tagId));
            }
            ImmutableSet blocks = null;
            if (object.has("blocks")) {
                JsonArray array = object.getAsJsonArray("blocks");
                HashSet blocks2 = new HashSet();
                array.forEach(j -> {
                    String blockId = j.getAsString();
                    blocks2.add((class_2248)class_7923.field_41175.method_10223(new class_2960(blockId)));
                });
                blocks = ImmutableSet.copyOf(blocks2);
            }
            if (tag == null && blocks == null) {
                return ANY;
            }
            return new SimpleBlockPredicate((class_6862<class_2248>)tag, (Set<class_2248>)blocks);
        }
        return ANY;
    }

    public static class Builder {
        @Nullable
        private Set<class_2248> blocks;
        @Nullable
        private class_6862<class_2248> tag;

        private Builder() {
        }

        public static Builder block() {
            return new Builder();
        }

        public Builder of(class_2248 ... blocks) {
            this.blocks = (Set)Arrays.stream(blocks).collect(ImmutableSet.toImmutableSet());
            return this;
        }

        public Builder of(class_6862<class_2248> tag) {
            this.tag = tag;
            return this;
        }

        public SimpleBlockPredicate build() {
            return new SimpleBlockPredicate(this.tag, this.blocks);
        }
    }
}

